/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program : kfstab
 * Authors : Andreas Reuter
 * E-Mail  : holtwick@uni-duisburg.de
 *           Andreas.Reuter@munich.netsurf.de
*****************************************************************************/

#ifndef _devpref_h_included
#define _devpref_h_included

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif  

#include <ktopwidget.h>
#include <kwizard.h>
#include <kprocess.h>

/**
 * This is class DevPreferences.
 * It handles users device selection 
 * and sends them back using signal NewDevice
 */

class DevPreferences : public KDialog
{
   Q_OBJECT
 public:
   /**
    * This is the constructor of class DevPreferences.
    */
   DevPreferences( QWidget *parent=0, const char *name=0 );
   /**
    * This is the destructor of class DevPreferences.
    * When the dialog is closed, we will kill all remaining fdisk tasks.
    */
   ~DevPreferences();
 public slots:
   /**
    * This module handles Floppy devices.
    */
   void devFloppy();
   /**
    * This module handles EIDE devices.
    */
   void devEide();
   /**
    * Sends the selected device back if the selection is accepted.
    */
   void devSelect();
   /**
    * This module handles SCSI devices.
    */
   void devScsi();
   /**
    * This module handles File devices.
    */
   void devFile();
   /**
    * This method handles /dev/<somedev> directly as KFileDialog can do so.
    */
   void devDevice();
 signals:
   /**
    * This signal is emmited whenever a new Device is selected.
    */
   void newDevice( char *devStr );
 protected slots:
   /**
    * This slot is responsable when a KProcess is finished or killed.
    */
   virtual void slotProcessDead( KProcess * );
   /**
    * This slot is called whenever a output of a KProcess is send
    * using stdout.
    */
   virtual void slotCmdStdout( KProcess *, char *, int );
 private:
   QPushButton   *QPBFloppy;
   QPushButton   *QPBEide;
   QPushButton   *QPBScsi;
   QPushButton   *QPBDevice;
   QPushButton   *QPBFile;
   QPushButton   *QPBCancel;
   QPushButton   *QPBAccept;

   QComboBox   *QCBDevice;

   QLabel   *specDev;
   /**
    * This module reads the available partitions from stdout
    * which is send as a QString to this module.
    * The partitions are send to a ComboBox, a text is shown.
    */
   void foundPart( QString *stdOutBuffer );
   /**
    * fdiskProc[] holds the KProcesspointers for the fdisk calls
    */
   KProcess fdiskProc[ 16 ];
   /**
    * This module is used by devEide and devScsi to check which partitions
    * are found by fdisk.
    */
   void devEideScsi( const char *name = 0,
           const char majorDev = 'h', 
           const char endDev = 'i' );
};

#endif






