/***********************************************************************
**
**   igc.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef IGC_H
#define IGC_H

#include <flight.h>
#include <qfile.h>

/**
  * Reads a file in the IGC-format and loads the flight-data.
  * Until now, only IGC-files are supported. Therefore, the only
  * test is the extension of the file. If one loads a file of an
  * other format but with the extension ".igc", the result is unknown.
  */
void loadIGC(QFile* flightDataFile, Flight* currentFlight);

#endif