/***********************************************************************
**
**   mapconfig.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef MAPCONFIG_H
#define MAPCONFIG_H

//#include <kslider.h>
#include <kwizard.h>

// include the qt-header
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qregion.h>
#include <qslider.h>
#include <qwidget.h>

/**
  * Opens a KWizard-dialog for configuring the mapelements.
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */
class MapConfig : public KWizard
{
  Q_OBJECT

 public:
  MapConfig(QWidget* parent);
  ~MapConfig();

 public slots:
  /** */
  void slotSetValues();
  /** */
  void slotSetuLimit(int limit);
  /** */
  void slotSetBorder1(int limit);
  /** */
  void slotSetBorder2(int limit);
  /** */
  void slotSetBorder3(int limit);
  /** */
  void slotSetBorder4(int limit);
  /** */
  void slotSetBorder5(int limit);
  /** */
  void slotSetDefaultValues();

 private:
  /** */
  void loadValues();
  /** */
  int getScaleValue(int value);
  /** */
  int setScaleValue(int value);
  /**
    * Pointer to the parent window.
    */
//  QWidget* parentWidget;

  QSlider* lLimit;
  QSlider* uLimit;
  QSlider* scale1;
  QSlider* scale2;
  QSlider* scale3;
  QSlider* scale4;
  QSlider* scale5;
  QLCDNumber* lLimitN;
  QLCDNumber* uLimitN;
  QLCDNumber* scale1N;
  QLCDNumber* scale2N;
  QLCDNumber* scale3N;
  QLCDNumber* scale4N;
  QLCDNumber* scale5N;

  QCheckBox* vorB;
  QCheckBox* vordmeB;
  QCheckBox* vortacB;
  QCheckBox* ndbB;
  QCheckBox* compB;
  QCheckBox* intairB;
  QCheckBox* airB;
  QCheckBox* milAirB;
  QCheckBox* civmilAirB;
  QCheckBox* airfieldB;
  QCheckBox* closedAirB;
  QCheckBox* civHeliB;
  QCheckBox* milHeliB;
  QCheckBox* ambHeliB;
  QCheckBox* ulfB;
  QCheckBox* hangB;
  QCheckBox* parachuteB;
  QCheckBox* ballonB;

  QSpinBox* airportB;
  QSpinBox* addAirportB;
  QSpinBox* gliderB;
  QSpinBox* outB;
  QSpinBox* waypointB;
  QSpinBox* radioB;
  QSpinBox* airspaceB;
  QSpinBox* coastB;
  QSpinBox* lakeBigB;
  QSpinBox* lakeMidB;
  QSpinBox* lakeSmallB;
  QSpinBox* damB;
  QSpinBox* obstacleB;
  QSpinBox* spotB;
  QSpinBox* passB;
  QSpinBox* iceB;
  QSpinBox* reportB;
  QSpinBox* hugeCityB;
  QSpinBox* bigCityB;
  QSpinBox* midCityB;
  QSpinBox* smallCityB;
  QSpinBox* villageB;
  QSpinBox* highB;
  QSpinBox* highEB;
  QSpinBox* roadMidB;
  QSpinBox* roadSmallB;
  QSpinBox* railB;
  QSpinBox* stationB;
  QSpinBox* aerialB;
  QSpinBox* landB;
};

#endif
