/***********************************************************************
**
**   mapcalc.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Mon Jul  26 1999
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef MAPCALC_H
#define MAPCALC_H

#include <wp.h>

#define PI 3.141592654

/**
  * The earth's radius used for calculation, given in Meter.
  * NOTE: We use the earth as a sphere, not as a spheroid!
  */
#define RADIUS 6370289.509

/**
  * Converts the longitute or latitute into the internal format
  * suitable for the Location-class. "degree" is a string in the
  * format: [g]gg.mm'ss"X where g,m,s are any digits from 0 to 9
  * and X is one of N, S, E, W.
  */
long degreeToNum(const char* degree);

/**
  * Convert internal representation to radians.
  */
double numToRad(long internal);

/**
  * Convert radians into internal data.
  */
long radToNum(double radial);

/**
  * Returns the x-coordinate for the Lambert-projection.
  */
double calc_X_Lambert(double latitude, double longitude);

/**
  * Returns the y-coordinate for the Lambert-projection.
  */
double calc_Y_Lambert(double latitude, double longitude);

/** Calculates the geographical position of a given point in the
  * map. The position is stored in "lat" and "lon" in the internal
  * format.
  */
void map2Lambert(double x, double y, struct point* loc);

long map2LambertLat(double x, double y);

long map2LambertLon(double x, double y);

/**
  * Calculates the distance between two given points (in km).
  */
double dist(double lat1, double lon1, double lat2, double lon2);

/**
  *
  */
QString printPos(long coord, bool isLat = true);

/**
  *
  */
QString printTime(int time);

#endif
