/*************************************************************************
 *                                                                       *
 *  KDisk Utils - KSlot V0.9.5                                           *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#ifndef KSLOT_H
#define KSLOT_H

#include "configdlg.h"

#include <qpainter.h>
#include <qpopmenu.h>
#include <qwidget.h>

#include <kapp.h>

class KSlotWidget:public QWidget{
	Q_OBJECT
public:
	KSlotWidget(QWidget *parent=0, const char *name=0, bool init=FALSE);
	~KSlotWidget();

public slots:
	void mouseReleaseEvent(QMouseEvent *e);
	void slot_quit();
	void slot_about();
	void slot_setDevice();
	void slot_applyDevice(QString d);

private:
	QBrush			brush_0;
	QBrush			brush_1;
	QBrush			brush_2;
	int			slot;
	QString 		device;

	KSlotConfigDLG		*cfgdialog;
	QPopupMenu		*slotmenu;

	void readSettings();
	void paintEvent(QPaintEvent *);
};

#endif KDU_H

