/***************************************************************************
                          kdmainfo.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 10 14:10:52 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kdmainfo.h"
#include <kmsgbox.h>

Kdmainfo::Kdmainfo(QWidget*parent,const char* name):QWidget(parent,name){
initializewindow();
}
Kdmainfo::~Kdmainfo(){
}
void Kdmainfo::initializewindow()
{
//  system("echo initialize");
  this->resize(330, 300);
  tablistbox = new KTabListBox(this, "tablistbox");
  tablistbox->setGeometry(0,0,330,270);
  tablistbox->setNumCols(2);
  tablistbox->setColumn(0, i18n("DMA"), 100);
  tablistbox->setColumn(1, i18n("Information"), 225);
  readfromfile(tablistbox);

  infobutton = new QPushButton(this, "infobutton");
  infobutton->setGeometry(0, 270, 60, 30);
  infobutton->setText(i18n("&About"));
  connect(infobutton, SIGNAL(clicked()), SLOT(infoclicked()));

  exitbutton = new QPushButton(this, "exitbutton");
  exitbutton->setGeometry(270, 270, 60, 30);
  exitbutton->setText(i18n("&Exit"));
  connect(exitbutton, SIGNAL(clicked()), SLOT(exitclicked()));
//  system("echo initialized ended");
}

void Kdmainfo::exitclicked()
{
  close();
}

void Kdmainfo::infoclicked()
{
  KMsgBox::message(this, i18n("Info to Kdmainfo"), i18n("Kdmainfo show your dma informations"));
}

void Kdmainfo::readfromfile(KTabListBox *tablistbox)
{
  char splitchar = ':';
  QString str;
  char buf[512];
  tablistbox->setSeparator(splitchar);
  QFile *file = new QFile("/proc/dma");

  if (!file->open(IO_ReadOnly))
  {
    delete file;
  }
  while (file->readLine(buf, sizeof(buf)-1)>0)
  {
    if (strlen(buf))
    {
      char *p=buf;
      if (splitchar!=0)
      while (*p)
      {
        if (*p==splitchar)
        {
          *p++ == ' ';
          while (*p == ' ') ++p;
          *(--p) = splitchar;
          ++p;
        }
        else ++p;
      }
      tablistbox->insertItem(buf);
    }
  }
  file->close();
  delete file;
}
