/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef VKVAR_H
#define VKVAR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <vkerr.h>

class v
{

public:
	v();

	v(int);
	v(long);
	v(double);
	v(bool);
	v(QString);
	v(const char*);

	//v& operator= ( v & );
	//v& operator= ( const char * );

	int i(); //converted to int
	long l();
	double f();
	double d() { return f(); }
	bool b();
	QString str();
	v val();

	
	v s( int ); //me.setNum(int)
	v s( long );
	v s( double );
	v s( bool );
	v s( QString );
	v s( const char * );

	v s( v );

	void makeConst();

	inline void setFile( bool fb ) { fileBit = fb; }
	inline bool isFile() { return fileBit; }

	virtual ~v();

private:
	void constructBase();

	void updateFlag();

	QString me;
	int myFlag;

	#define stringFlag 0
	#define floatFlag  1
	#define longFlag   2
	#define intFlag    3

	vkErr *varErr;

	bool isConst, fileBit;
};

#endif //VKVAR_H
