/*
   KDiskCat-Plugin [MP3 ID3 tag extraction]
   (C) 1999 by Balzs Ternyi <terenyi@freemail.c3.hu>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <tag.h>

/*
   Edit these variables
*/
/* BEGIN */
char* version="0.1";
char* author="Balzs Ternyi";
char* email="terenyi@freemail.c3.hu";
char* pluginname="KADEmp3";
char* date="1999";
char* DEFAULT_associations="*.mp3,*.MP3";
char* DEFAULT_fire="";
/* END */

char* RESPONSE_END="|END|";

void info()
{
	cout << pluginname << " " << version << "(C) " << date << " " << author << " <" << email << ">" << endl;
	cout << endl;
	/*
	   Write the description and usage (customizable output) of your plugin here
	*/
	/* BEGIN */
	cout << "MP3 ID3 tag extraction plugin with customizable output" << endl;
	cout << endl;
	cout << "To customize the output compose a mask with the following possible elements:" << endl;
	cout << endl;
	cout << "   %ALBUM" << endl;
	cout << "   %ARTIST" << endl;
	cout << "   %COMMENT" << endl;
	cout << "   %GENRE" << endl;
	cout << "   %TITLE" << endl;
	cout << "   %YEAR" << endl;
	cout << endl;
	cout << "Example:" << endl;
	cout << "   KADEmp3 ""%ALBUM (%YEAR): %TITLE""" << endl;
	/* END */
}

void defaultSettings()
{
	cout << DEFAULT_associations << "|" << DEFAULT_fire;
}

int main(int argc, char** argv)
{
   char buff[1000];
   char* fname=buff;
   FILE *f;
   Tag mp3tag;
   
   if (!strcmp(argv[argc - 1],"--help"))
   {
      info();
      exit(0);
   }
   if (!strcmp(argv[argc - 1],"--default"))
   {
      defaultSettings();
      exit(0);
   }
   while (true)
   {
      cin.gets(&fname);
      if ((f=fopen(fname,"r")) != NULL)
      {
         /*
            Do your description extraction here
         */
         /* BEGIN */
	 if (mp3tag.get(f))
	 {
            cout << mp3tag.getArtist() << " - " << mp3tag.getAlbum() << " : " << mp3tag.getTitle() << RESPONSE_END << endl;
	 }
	 else
	 {
            cout << RESPONSE_END << endl;
	 }
         /* END */
         fclose(f);
      }
      else
      {
         cout << RESPONSE_END << endl;
      }
   }
}