/*
	optionsdlg.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kcombo.h>

#include "optionsdlg.h"
#include "cathandler.h"
#include "kdiskcat.h"

extern CategoryHandler* cathandler;
extern Prefs* prefs;

OptionsDlg::OptionsDlg(QWidget *parent, const char *name)
   :QDialog(parent,name,TRUE)
{
   int i, width1, width2, width3=0, width4, maxwidth;
   QStrList strlist;

   setCaption(i18n("Preferences"));

   kc_start_category= new KCombo(this,"kc_start_category");
   strlist=cathandler->getCategoryNames();
   kc_start_category->insertStrList(&strlist);
   kc_start_category->insertItem(i18n("<none>"));
   
   i=0;
   while (i <= kc_start_category->count() - 1)
   {
      if (width3 < kc_start_category->fontMetrics().width(kc_start_category->text(i)))
      	width3 = kc_start_category->fontMetrics().width(kc_start_category->text(i));
      if ((QString) kc_start_category->text(i)==prefs->default_category)
      {
         kc_start_category->setCurrentItem(i);
      }
      i++;
   }

   lb_start_category= new QLabel(this,"lb_start_category");
   lb_start_category->setText(i18n("Category to display on startup:"));
   
   lb_default_mount_point= new QLabel(this,"lb_default_mount_point");
   lb_default_mount_point->setText(i18n("Default path to scan from:"));
   
   sle_default_mount_point= new QLineEdit(this,"sle_default_mount_point");
   sle_default_mount_point->setText(prefs->default_mountpoint);

   lb_export_delimiter=new QLabel(this,"lb_export_delimiter");
	lb_export_delimiter->setText(i18n("Export delimiter:"));
	
	sle_export_delimiter=new QLineEdit(this,"sle_export_delimiter");
	sle_export_delimiter->setText(prefs->export_delimiter);

   width1 = lb_start_category->fontMetrics().width(lb_start_category->text());
   width2 = lb_default_mount_point->fontMetrics().width(lb_default_mount_point->text());
   width4 = lb_export_delimiter->fontMetrics().width(lb_export_delimiter->text());

   if (width1 < width2) maxwidth = width2; else maxwidth = width1;
   if (width4 > maxwidth) maxwidth = width4;
   maxwidth += 10;

   lb_start_category->setGeometry(10, 10, maxwidth, 24);
   lb_default_mount_point->setGeometry(10, 40, maxwidth, 24);
   lb_export_delimiter->setGeometry(10,70,maxwidth,24);

   kc_start_category->setGeometry(10+maxwidth, 10, width3+40, 24);
   sle_default_mount_point->setGeometry(10+maxwidth, 40, width3+40, 24);
	sle_export_delimiter->setGeometry(10+maxwidth,70,width3+40,24);

   pb_ok= new QPushButton(i18n("Ok"),this);
   pb_ok->setDefault(true);
   
   pb_cancel= new QPushButton(i18n("Cancel"),this);
   
   setMinimumSize(kc_start_category->x()+kc_start_category->width()+10, 150);
   setMaximumSize(kc_start_category->x()+kc_start_category->width()+10, 150);

   width1 = pb_ok    ->fontMetrics().width(pb_ok    ->text());
   width2 = pb_cancel->fontMetrics().width(pb_cancel->text());
   if (width1 < width2) maxwidth = width2; else maxwidth = width1;
   maxwidth += 20;

   pb_ok    ->setGeometry( width()/2-20-maxwidth, height()-40, maxwidth, 30 );
   pb_cancel->setGeometry( width()/2+20,          height()-40, maxwidth, 30 );

   kc_start_category->setFocus();
   
   connect(pb_ok,SIGNAL(clicked()),SLOT(accept()));
   connect(pb_cancel,SIGNAL(clicked()),SLOT(reject()));
};

OptionsDlg::~OptionsDlg()
{
   delete kc_start_category;
   delete lb_start_category;
   delete sle_default_mount_point;
   delete lb_default_mount_point;
   delete lb_export_delimiter;
   delete sle_export_delimiter;
};