/*
	kdiskcat.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpushbutton.h>
#include <qwidget.h>
#include <qmessagebox.h>
#include <qregexp.h>
#include <kmsgbox.h>
#include <strstream.h>

#include "kdiskcat.h"
#include "optionsdlg.h"
#include "searchdlg.h"
#include "catsearch.h"
#include "pluginconfig.h"
#include "setupupdatedlg.h"

extern void micro(QString* the_text);
extern CategoryHandler* cathandler;
extern Prefs* prefs;
extern const char* VERSION_NUMBER;

Kdiskcat::Kdiskcat()
{
   config=kapp->getConfig();
   prefs= new Prefs();
   init();
}

Kdiskcat::~Kdiskcat()
{
	delete prefs;
}

void Kdiskcat::init()
{
  int i;

  view= new CatView(this,"view",KNewPanner::Vertical,KNewPanner::Percent,25);

  initMenu();
  initToolbar();
  initStatusBar();

  cathandler= new CategoryHandler();

  setView(view);
  connect(view,SIGNAL(categoriesChanged(QStrList*)),this,SLOT(slotRefreshCategoryCombo(QStrList*)));
  connect(view,SIGNAL(comboSelectionRequired(QString*)),this,SLOT(slotSelectComboItem(QString*)));
  readSettings();
  view->init();
  
  if (prefs->default_category != i18n("<none>"))
  {
     i=slotSelectComboItem(&prefs->default_category);
     if (i != -1) slotCategoryChoice(i);
  }
}

void Kdiskcat::initMenu()
{
	QString str;
	
  // build the file menu
   QPopupMenu* p = new QPopupMenu;
   p->insertItem(i18n("&New category..."), view, SLOT(slotNewCategory()));
	p->insertItem(i18n("&Rename category..."), view, SLOT(slotRenameCategory()));
   p->insertItem(i18n("&Delete category"), view, SLOT(slotDelCategory()));
   p->insertSeparator();
	p->insertItem(i18n("&Export category"), view, SLOT(slotExportCategory()));
   p->insertSeparator();
   p->insertItem(i18n("&Quit"), this, SLOT(slotQuit()), CTRL+Key_Q);

   // put the popupmenu as File-menu into the menu bar
   menuBar()->insertItem(i18n("&File"), p);
   menuBar()->insertSeparator();

   // build the edit menu
   p = new QPopupMenu;
   p->insertItem(i18n("&New catalog..."), view, SLOT(slotNew()),CTRL+Key_N);
//   p->insertItem(i18n("&Rename catalog..."), view, SLOT(slotRenameCatalog()));
//   p->insertItem(i18n("&Move catalog..."), view, SLOT(slotMoveCatalog()));
//   p->insertItem(i18n("&Delete catalog..."), view, SLOT(slotDeleteCatalog()));
   p->insertSeparator();
   p->insertItem(i18n("&Search..."), this, SLOT(slotSearch()),CTRL+Key_F);
   p->insertSeparator();
   p->insertItem(i18n("Catalog &properties..."), view, SLOT(slotProperties()),CTRL+Key_P);
//   p->insertItem(i18n("Catalog &summary"), this, SLOT(slotSummary()));
  
   menuBar()->insertItem(i18n("&Catalog"), p);
   menuBar()->insertSeparator();

   // build the Options menu
   p = new QPopupMenu;
   p->insertItem(i18n("Toggle &Toolbar"),this, SLOT(slotViewTToolbar()),CTRL+Key_T);
   p->insertItem(i18n("Toggle Status&bar"),this, SLOT(slotViewTStatusbar()),CTRL+Key_B);
   p->insertSeparator();
   p->insertItem(i18n("Plugin &configuration..."), this, SLOT(slotPluginConfig()));
   p->insertItem(i18n("&Preferences..."), this, SLOT(slotPreferences()), CTRL+Key_O);
  
   menuBar()->insertItem(i18n("&Options"), p);
   menuBar()->insertSeparator();

  // generate the help menu
	str="KDiskCat - ";
	str+=i18n("The KDE disk catalog");
	str+="\n";
	str+=i18n("Version ");
	str+=VERSION_NUMBER;
	str+="\n\n";
	str+="Copyright (c) 1998-2000 Balzs Ternyi <terenyi@freemail.c3.hu>\n\n";
	str+=i18n("This program is licensed under the GNU General Public License.");
	str+="\n\n";
	str+=i18n("Homepage at http://devel-home.kde.org/~kdiskcat");
   p = kapp->getHelpMenu(true,str);
   menuBar()->insertItem(i18n("&Help"), p);
}

void Kdiskcat::initToolbar()
{
   KCombo* comb;

   toolBar()->insertCombo("Category",TOOLBAR_CATEGORY,true,SIGNAL(activated(int)),this,SLOT(slotCategoryChoice(int)),true,i18n("Categories"),160);
   comb=toolBar()->getCombo(TOOLBAR_CATEGORY);
   comb->setFocusPolicy(QWidget::NoFocus);

   toolBar()->insertButton(Icon("filenew.xpm"),TOOLBAR_NEW, true,i18n("New catalog"));
   toolBar()->insertButton(Icon("find.xpm"),TOOLBAR_SEARCH, true,i18n("Search"));

   toolBar()->insertSeparator();
   toolBar()->insertButton(Icon("openfolder.xpm"),TOOLBAR_OPEN,true,i18n("Open"));
   toolBar()->insertButton(Icon("properties.xpm"),TOOLBAR_PROP,true,i18n("Properties"));

   toolBar()->insertSeparator();
   toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_QUIT,true,i18n("Quit"));
  
   connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
}

void Kdiskcat::initStatusBar()
{
   statusBar()->setInsertOrder(KStatusBar::RightToLeft);
   statusBar()->insertItem(i18n("DISK!"),STATUSBAR_DISK);
   statusBar()->changeItem("",STATUSBAR_DISK);
   statusBar()->insertItem(i18n("MODIFIED!"),STATUSBAR_MOD);
   statusBar()->changeItem("",STATUSBAR_MOD);
   statusBar()->insertItem(i18n("Ready."),STATUSBAR_TEXT);
}

void Kdiskcat::slotQuit()
{
  close();
}

void Kdiskcat::slotSummary()
{
}

void Kdiskcat::slotPluginConfig()
{
	PluginConfig dia(this,"dia");
	
	if (dia.exec())
	{
	}
	statusBar()->changeItem(i18n("Ready"),STATUSBAR_TEXT);
}

void Kdiskcat::slotPreferences()
{
  OptionsDlg dia(this,"dia");
  if (dia.exec())
  {
     prefs->default_category=dia.kc_start_category->currentText();
     prefs->default_mountpoint=dia.sle_default_mount_point->text();
     prefs->export_delimiter=dia.sle_export_delimiter->text();
  }
  statusBar()->changeItem(i18n("Ready"),STATUSBAR_TEXT);
}

void Kdiskcat::slotViewTToolbar()
{
  enableToolBar();
}

void Kdiskcat::slotViewTStatusbar()
{
  enableStatusBar();
}

void Kdiskcat::slotToolbarClicked(int item)
{
  switch (item) 
  {
     case TOOLBAR_NEW:
        view->slotNew();
        break;
     case TOOLBAR_SEARCH:
        slotSearch();
        break;
     case TOOLBAR_SAVE:
        view->slotSave();
        break;
     case TOOLBAR_PROP:
        view->slotProperties();
        break;
     case TOOLBAR_QUIT:
        slotQuit();
        break;
     case TOOLBAR_OPEN:
		  view->slotOpen();
		  break;
  }
}

void Kdiskcat::slotRefreshCategoryCombo(QStrList * cats)
{
   KCombo* comb=toolBar()->getCombo(TOOLBAR_CATEGORY);
   
   comb->clear();
  	comb->insertStrList(cats);
}

void Kdiskcat::slotCategoryChoice(int index)
{
	if (cathandler->getCategoryNames().count() > 0)
	{
		view->slotCategoryChoice(index);
	}
}

void Kdiskcat::slotSearch()
{
	QStrList strl=cathandler->getCategoryNames();
   SearchDlg dia(this,"dia",&strl,cathandler->getCurrentCategory());
   CatCriteria* crit;
   CatSearch* search;

   if (dia.exec())
   {
   	crit=new CatCriteria();
   	dia.getCriteria(crit);
   	
   	search=new CatSearch(crit);
   	connect(search,SIGNAL(categoryChangeRequired(int)),this,SLOT(slotCategoryChoice(int)));
   	search->go();

      delete search;
      delete crit;
   }
   statusBar()->changeItem(i18n("Ready"),STATUSBAR_TEXT);
}

void Kdiskcat::readSettings()
{
	QString version;
	
   config->setGroup(kapp->appName());
	version=config->readEntry("VERSION","");
	if (VERSION_NUMBER != version)
	{
		// Updating the config file
		SetupUpdateDlg dia(0,"dia");
		dia.show();
		kapp->processEvents();
		dia.message(i18n("Updating the old configuration file (kdiskcatrc)"));
		dia.message(i18n("Autoconfiguring ADE plugins"));
		PluginConfig::autoConfig(&dia);
      config->setGroup(kapp->appName());
      config->writeEntry("VERSION",VERSION_NUMBER);
	}
   config->setGroup(kapp->appName());
   view->setSeparatorPos(config->readNumEntry("PannerPos",30));
   resize(config->readNumEntry("Width",600),config->readNumEntry("Height",375));
   prefs->default_category=config->readEntry("DefaultCategory","<none>");
   prefs->default_mountpoint=config->readEntry("DefaultMountPoint","/cdrom");
   prefs->export_delimiter=config->readEntry("ExportDelimiter",";");
}

void Kdiskcat::writeSettings()
{
   config->setGroup(kapp->appName());
   config->writeEntry("PannerPos",view->separatorPos());
   config->writeEntry("Width",width());
   config->writeEntry("Height",height());
   config->writeEntry("DefaultCategory",prefs->default_category);
   config->writeEntry("DefaultMountPoint",prefs->default_mountpoint);
   config->writeEntry("ExportDelimiter",prefs->export_delimiter);
}

void Kdiskcat::gotoSelected(QString category,KPath branch,QString filename)
{
	view->gotoSelected(category,branch,filename);
}


//void Kdiskcat::saveData(KConfig* sessionConfig) // logoutnal fut le
//{
//}

void Kdiskcat::closeEvent(QCloseEvent* e)
{
   view->slotSave();
   writeSettings();
   KTMainWindow::closeEvent(e);
}

int Kdiskcat::slotSelectComboItem(QString* str)
{
  int i;
  KCombo* kc=toolBar()->getCombo(TOOLBAR_CATEGORY);
  bool found=false;
  
  i=0;
  while (i <= kc->count() - 1 && !found)
  {
     if ((QString) kc->text(i)==*str)
     {
        kc->setCurrentItem(i);
        found=true;
     }
     i++;
  }
  if (!found) i= -1;
  else i--;
  
  return i;
}


