/*
	searchprogress.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include "searchprogress.h"

SearchProgress::SearchProgress(QWidget* parent = 0,const char* name = 0)
   :QSemiModal(parent,name,true,0)
{
   setCaption(i18n("Searching..."));
   prg=new KProgress(KProgress::Horizontal,this,"prg");
   prg->setGeometry(10,70,240,20);

   lb_current_catalog= new QLabel(this,"lb_current_catalog");
   lb_current_catalog->setGeometry(10,10,200,20);

   lb_found= new QLabel(this,"lb_found");
   lb_found->setGeometry(10,40,200,20);

   pb_cancel= new QPushButton(i18n("Cancel"),this,"pb_cancel");
	pb_cancel->setGeometry(80,100,100,30);
	
	connect(pb_cancel,SIGNAL(clicked()),this,SLOT(slotCancel()));
}

SearchProgress::~SearchProgress()
{
   delete prg;
   delete lb_current_catalog;
   delete lb_found;
   delete pb_cancel;
}

void SearchProgress::setTotal(int total)
{
   prg->setRange(0,total);
   setValue(0);
}

void SearchProgress::setValue(int val)
{
   prg->setValue(val);
   kapp->processEvents();
}

void SearchProgress::setCategory(QString cat)
{
   lb_current_catalog->setText((const char *) cat);
   kapp->processEvents();
}

void SearchProgress::setFound(QString text)
{
   lb_found->setText((const char *) text);
   kapp->processEvents();
}


void SearchProgress::slotCancel()
{
	emit stopped();
}


