/*
	catsearch.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <strstream.h>
#include "catsearch.h"

extern CategoryHandler* cathandler;
extern CatHandler* cat;
extern char list_separator;

CatSearch::CatSearch(CatCriteria* pcrit)
{
	QString res_title;
	crit=pcrit;
	
   res_title=i18n("Search results (");
   res_title+=crit->rexp.pattern();
   res_title+=")";
	
	dia_resultview=new ResultView((const char*) res_title,&list_separator);
	dia_progress=new SearchProgress(0,"SearchPrg");
	dia_progress->setTotal(100);
	
	connect(dia_progress,SIGNAL(stopped()),this,SLOT(slotStop()));
}

CatSearch::~CatSearch()
{
}

void CatSearch::go()
{
   QStrList all_categories;
   QString category_before;
   uint cur_file;
   int current_item=0;
   QString text,s;
   QString text_found=i18n("Found:");
   CatEntry* ce;

	stopping_required=false;
   found=0;
   total_scanned=0;
   int i;

   dia_progress->show();
   all_categories=cathandler->getCategoryNames();
   category_before=cathandler->getCurrentCategory();
	
	for (i=0;i < (int)crit->categories.count() - 1 && crit->categories.at(i) != category_before;i++) {}
	/* Optimizing the category list to first scan the already loaded catalog
		(if it's selected)*/
	if (crit->categories.at(i) == category_before)
	{
		crit->categories.remove(i);
		crit->categories.insert(0,category_before);
	}

   for (cur_file=0;cur_file < crit->categories.count();cur_file++)
   {
      dia_progress->setValue(0);
      dia_progress->setCategory(i18n("Searching category: ")+QString(crit->categories.at(cur_file)));
      cathandler->setActiveCategory(crit->categories.at(cur_file));

		if (cat->firstBranch() == 1)
		{
  		   // Adding mount points to the list
  		   ce=cat->first();
  		   while (ce!=0)
  		   {
  		      dia_resultview->addMount(cathandler->getCurrentCategory(),ce->filename,ce->mount_point);
  		      ce=cat->next();
  		   }
  			
			current_branch=cat->nextBranch();
         dia_progress->setTotal(cat->branchCount());
         current_item=1;
			while ((current_branch.count() > 0) && (!stopping_required))
			{
				searchBranch();
				current_branch=cat->nextBranch();
				current_item++;
            dia_progress->setValue(current_item);
			}
         text.sprintf(text_found+" %d / %d",found,total_scanned);
         dia_progress->setFound(text);
		}
		if (stopping_required)
		{
			break;
		}
   }
   if (category_before != "")
   {
      emit categoryChangeRequired(all_categories.find(category_before));
   }
		
   if (found > 0 || !stopping_required)
   {
      text=dia_resultview->caption();
      s.setNum(found);
      text+=" - ";
      text+=s+i18n(" rows");
      dia_resultview->setCaption((const char*) text);

      dia_resultview->show();
   }
   else
   {
   	delete dia_resultview;
   }

   delete dia_progress;
}

void CatSearch::searchBranch()
{
   CatEntry* ce;
   QString text,s;
   bool got;
   QString text_found=i18n("Found:");
	
	ce=cat->first();
	while (ce != 0)
	{
		got=true;

		// Text search
		if (crit->filename_on)
		{
  		   got=crit->rexp.match((const char*) ce->filename,0,0) != -1;
  		}
  		
  		if ((crit->description_on) && (!got || (got && !crit->filename_on)))
  		{
     	   got=crit->rexp.match((const char*) ce->description,0,0) != -1;
   	}

		// Size search
  		if (got && crit->size_from_on)
  		{
  			if (ce->f_size < crit->size_from)
  			{
  				got=false;
  			}
  		}
			
  		if (got && crit->size_to_on)
  		{
  			if (ce->f_size > crit->size_to)
  			{
  				got=false;
  			}  			
  		}			
   	
		// Datetime search
  		if (got && crit->date_from_on)
  		{
  			if (ce->mod_date < crit->date_from)
  			{
  				got=false;
  			}
  		}
			
  		if (got && crit->date_to_on)
  		{
  			if (ce->mod_date > crit->date_to)
  			{
  				got=false;
  			}  			
  		}

		if (got)
		{
			found++;
      	dia_resultview->addResult(ce,current_branch);
   	}

	   total_scanned++;
	   if (total_scanned % 1000==0)
   	{
      	text.sprintf(text_found+" %d / %d",found,total_scanned);
         dia_progress->setFound(text);
		}							
		ce=cat->next();
	}
}

void CatSearch::slotStop()
{
	stopping_required=true;
}
