/*
	cathandler.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CATHANDLER_H
#define CATHANDLER_H

#include <qlist.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qstrlist.h>
#include <qdict.h>
#include <ktreelist.h>

#include "postprocess.h"

class CatEntry
{
public:
   CatEntry(int p_entry_type,QString p_filename,QDateTime p_mod_date,uint p_f_size,QString p_description,QString p_mp);
   CatEntry();
   ~CatEntry();
   enum {E_LINK=1,
         E_DIR=2,
         E_FILE=4,
         E_CATALOG=8};
   int 			entry_type;
   QString 		filename;
   QDateTime 	mod_date;
   uint 			f_size;
   QString 		description;
   QString 		mount_point;
};

class IndexEntry
{
public:
   QString	key;
   uint		position;
};

class IndexList : public QList<IndexEntry>
{
private:
   int	compareItems(GCI s1,GCI s2);
};

class CatHandler : public QObject
{
    Q_OBJECT
public:
   CatHandler(QObject* parent=0,const char* name=0);
   ~CatHandler();
   QString Path2Char(KPath path);
   QString Path2Char(KPath path,uint depth);
   KPath Char2Path(const QString* str);

   void init(QString filename);
   void setCurrentBranch(KPath what);
   KPath getCurrentBranch();
   int firstBranch();
   KPath lastBranch();
   KPath nextBranch();
   KPath prevBranch();
   CatEntry* first();
   CatEntry* last();
   CatEntry* next();
   CatEntry* prev();
   int findEntry(KPath what);
   CatEntry* getCurrentEntry();
   void setCurrentEntry(CatEntry* ce);
   void synchronizeAll();
   bool scanNewCatalog(QString catalog_name,QString mount_point);
   void newBranch(KPath branch);
   void newBranch(QString key,uint pos);
   void deleteBranch();
   void addEntry(CatEntry* ce);
   void insertInSortEntry(CatEntry* ce);
   void setCatalogLoading(bool onoff);
   uint branchCount();
   void clearAll();
   void deleteEntry();
   uint getCurrentBranchPosition();

protected:
   void synchronize();
   int loadCatalog();
   uint saveCatalog();
   int loadIndex();
   int saveIndex();
   void clearIndex();
   void clearCatalog();
   uint scanDir(const char *cur_dir, KPath cur_path);

   PostProcess* postproc;
   KPath current_branch;
   uint current_branch_position;
   uint current_branch_index;
   QString category_file;
   QList<CatEntry> catalog;
   IndexList catindex;
   QStrList* sorted_index;
   bool is_catalog_modified;
   bool is_catindex_modified;
   bool is_catalog_loading_on;
};

class CategoryEntry
{
public:
   QString filename;
   bool read_only;
};

class CategoryHandler
{
public:
   CategoryHandler();
   ~CategoryHandler();
   void init(QString dir);
   int newCatalog(QString name,QString mp);
   int copyCatalog(QString source,QString dest_category_name);
   int deleteCatalog(QString name);
   int renameCatalog(QString old_name,QString new_name);
   int newCategory(QString name);
   int deleteCategory(QString name);
   int renameCategory(QString old_name,QString new_name);
   void compactAll();
   QStrList getCategoryNames();
   void setActiveCategory(QString name);
   QString getCurrentCategory();
   QString getCatalogName(KPath kp);
protected:
   void refreshCategoryList();

   QString current_category;
   QList<CategoryEntry> categories;
   QString db_dir;
};

#endif
