/*
	PropertiesDlg.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <qregexp.h>
#include "PropertiesDlg.h"

#define Inherited PropertiesDlgData

extern CatHandler* cathandler;

PropertiesDlg::PropertiesDlg
(
	QWidget* parent,
	const char* name,
	CatEntry* ce,
	KPath* branch
)
	:
	Inherited( parent, name )
{
   KPath kp;
   QString str, val;
   QDate d;
   QTime t;
	KConfig* conf;
	
	setCaption( i18n("Properties") );
	
	conf=kapp->getConfig();
	
   conf->setGroup("PropertiesDlg");
   resize(conf->readNumEntry("Width",400),conf->readNumEntry("Height",300));
	
   kp=*branch;
   lb_filename->setText((const char*) ce->filename);
   lb_location->setText((const char*) cathandler->Path2Char(kp));
   str.sprintf("%d",ce->f_size);
   lb_size->setText((const char*) str);
   d=ce->mod_date.date();
   t=ce->mod_date.time();
   // QT v. 2 supports QString::arg, that's easier than the following:
   str=i18n("yyyy.mm.dd hh:MM");
   val.setNum(d.year())  ;str.replace("yyyy",val);
   val.setNum(d.month()) ;str.replace("mm"  ,("0"+val).right(2));
   val.setNum(d.day())   ;str.replace("dd"  ,("0"+val).right(2));
   val.setNum(t.hour())  ;str.replace("hh"  ,("0"+val).right(2));
   val.setNum(t.minute());str.replace("MM"  ,("0"+val).right(2));

   lb_date->setText((const char*) str);
   mle_description->setText((const char*) ce->description);

   mle_description->setFocus();

   CurrentEntry=ce;

   connect(pb_ok,SIGNAL(clicked()),this,SLOT(slotOk()));
   connect(pb_cancel,SIGNAL(clicked()),this,SLOT(reject()));
}


PropertiesDlg::~PropertiesDlg()
{
	KConfig* conf;
	
	conf=kapp->getConfig();
	
	conf->setGroup("PropertiesDlg");
	conf->writeEntry("Width",width());
	conf->writeEntry("Height",height());
}

void PropertiesDlg::slotOk()
{
   accept();
   if (((const char*) CurrentEntry->description) != mle_description->text())
   {
      CurrentEntry->description=mle_description->text();
   }
}