/*
 * $Id: cpu.cpp,v 1.3.2.1 1996/12/19 19:23:42 alex Exp $
 *
 * $Log: cpu.cpp,v $
 * Revision 1.3.2.1  1996/12/19 19:23:42  alex
 * fist public release, 0.1.alpha
 *
 * Revision 1.3  1996/12/19 19:14:31  alex
 * first public release, version 0.1.alpha
 *
 */


#include <qwidget.h>
#include <qevent.h>
#include <qpainter.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <asm/param.h>
#include <sys/mman.h>

#include "cpu.h"
#include "Kconfig.h"

extern KConfig *config;

CpuMon::CpuMon(QWidget *parent, const char *name, WFlags f)
    : QWidget (parent, name, f)
{
    struct timezone timez;
    char dummy[10];
    
    setBackgroundColor(black);


    load_values = 0;

    /*
     * set up the initial values
     */

    statfile = 0;
    statfile = fopen("/proc/stat", "r");
    setvbuf(statfile, NULL, _IONBF, 0);
    /*
     * read in the initial tick values
     */
    fscanf(statfile, "%s %d %d %d %d", dummy, &old_user_ticks, &old_nice_ticks, &old_system_ticks, &old_idle_ticks);
    gettimeofday(&oldtime, &timez);

    /*
     * get the configuration value for the update speed
     */
    timer_interval = 1000;     /* this is default (1 sec) */
    
    tid = startTimer(timer_interval);

    /*
     * set up 2 common needed brushes for the painting job
     */

    brush_0 = QBrush(QColor("black"), SolidPattern);
    brush_1 = QBrush(QColor(   0, 225,   0), SolidPattern);

    show();
}

CpuMon::~CpuMon()
 {
    killTimer(tid);
 }

void CpuMon::paintEvent(QPaintEvent *)
{
    QPainter p;
    unsigned cur_y;


    

    p.begin(this);
    p.setPen(green);
    p.setBackgroundMode(OpaqueMode);

    cur_y = load_values;
    /*
     * again, set viewport to prevent the frame from beeing overwritten
     * the translation is simple: 100 units x-axis and 100 units (100%) y-axis
     */
    //    p.setViewport(0, 10, w, h - 30);
    p.setWindow(0, 0, 100, 100);
    p.fillRect(0, 0, 100, 100, brush_0);
    p.fillRect(0, 100 - cur_y, 100, cur_y, brush_1);

    p.end();
    
}

/*
 * this function records the actual load values
 */

void CpuMon::timerEvent(QTimerEvent *)
{
    char buffer[100];
    struct timeval time;
    struct timezone timez;
    float elapsed_time;
    unsigned elapsed_ticks, load_ticks, load_percent;
    
    rewind(statfile);
    fscanf(statfile, "%s %d %d %d %d", buffer, &user_ticks, &nice_ticks, &system_ticks, &idle_ticks);

    gettimeofday(&time, &timez);
    elapsed_time = (time.tv_sec - oldtime.tv_sec)
        + (float) (time.tv_usec - oldtime.tv_usec) / 1000000.0;
    oldtime.tv_sec = time.tv_sec;
    oldtime.tv_usec = time.tv_usec;

    elapsed_ticks = (int)(elapsed_time * HZ * 100);
    load_ticks = (system_ticks - old_system_ticks) + (nice_ticks - old_nice_ticks) +
        (user_ticks - old_user_ticks);

    load_percent = (load_ticks * 100) / (elapsed_ticks / 100);



    if(load_percent > 100)
        load_percent = 100;

    load_values = load_percent;


    old_system_ticks = system_ticks;
    old_nice_ticks = nice_ticks;
    old_user_ticks = user_ticks;

    repaint();
}


