/****************************************************************************
 * KGhostscriptInfo - holds a list of printer types and the magicfilter
 *  information needed for them.
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kgsinfo.h,v 1.6 1998/04/24 17:14:04 nhart Exp $
 *                                                                   
 ****************************************************************************/

#ifndef __KGSINFO_H__
#define __KGSINFO_H__

#include <qstring.h>

class KGhostscriptInfo
{
public:
	KGhostscriptInfo();
	~KGhostscriptInfo();
	int init();
	int numberOfPrinterTypes();
	// set pType to point to a text description of the numbered printer type
	//  if number is out of range, return false
	bool getGsPrinterType(int index, QString** pType);

	// set pFilter to point to a filter name
	//  if number is out of range, return false
	bool getGsPrinterFilter(int index, QString** pFilter);

	// given a filter name, set pType to point to a text description of 
	//  the printer type. If filter name doesn't exist, return false
	bool getTypeFromFilter(const QString* filter, QString** pType);

	// given a filter name, set pIndex to point to index of that filter
	//  in the list of filter types. If filter name doesn't exist, return false
	bool getIndexFromFilter(const QString* filter, int* pIndex);
private:
	QString* pInfo[256][2];
	int piCtr;
};

#endif
