/*
 * pgpkeyring.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGPKEYRING_H
#define PGPKEYRING_H

#include "pgpkey.h"
#include "pgpconfig.h"

#include <kconfig.h>
#include <qstring.h>
#include <qlist.h>

class PgpKeyring
{
public:
  
  static PgpKeyring* getPgpKeyring();
  static PgpKeyring* pgpkeyring;

public:

  QList<PgpKey> findKey(QString uid = "", QString keyId = "", bool pub = true);

  // keyId should be unique, so only one key is returned
  PgpKey*       findKeyId(const QString keyId) const;

  // updates key. Use write() to make changes permanent
  void          updateKey(PgpKey *key);

  // removes a key from the internal key list. Use write() to make changes permanent
  void          removeKey(PgpKey *key);

  // updates all keys, uids and signatures with changedKey
  void          updateKeys(const PgpKey &changedKey);

  // reloads the key list
  void          reload();

  // writes keylist into keyring
  void          write();

  // deletes Key
  // void          write(QList<PgpKey> new_list);

protected:
  
  PgpKeyring();
  ~PgpKeyring();

  // loads keys from keyring
  void          load();

protected: 

  PgpConfig           *pgp_config;
  QString             pubring;

  QList<PgpKey>       key_list;
  QDict<PgpKey>       key_dict;
  
  QList<PgpSignature> revocation_list;
};

#endif
