/*
 * pgpkey.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGP2KEY_H
#define PGP2KEY_H

#include "pgpmpi.h"
#include "pgpkey.h"
#include "pgptrust.h"

#define KEYID_FORMAT "%2.2X%2.2X%2.2X%2.2X"

const UINT8 PGP2_KEY       = 6;
const UINT8 PGP2_USERID    = 13;
const UINT8 PGP2_SIGNATURE = 2;
const UINT8 PGP2_SIGNATURE_KEY    = 0x10;
const UINT8 PGP2_SIGNATURE_REVOKE = 0x20;

const UINT8 PGP2_PLAINTEXT_PACKET = 11;
const UINT8 PGP2_TRUST     = 12;
const UINT8 PGP2_COMMENT_PACKET   = 14;


class Pgp2Key : public PgpKey
{
public:
  
  Pgp2Key(QDataStream &source, UINT8 &ctb);
  virtual ~Pgp2Key();

  // void        load(QDataStream &source) {};
  void        store(QDataStream &dest);

  PgpUserId*  newUserId(QString uid);
  void        extractKey(QString filename);

  void        setDefault(bool _default);
  void        setRevoked();
  void        setPaused(bool paused);
  QString     keyId() const;
  QString     fingerprint();
  int         bitlen();
  QDateTime   created();
  PgpSignature*  sign(PgpKey *key);
  int         getTrust() const;
  void        setTrust(int new_trust);

  /* returns a descrption of the key algorithm */
  QString     algorithm() const;

  /* returns version information of this key */
  QString     format() const;

  
  
protected:

  UINT8              CTB;
  UINT32             len;

  UINT32             timestamp;
  UINT8              version;
  UINT16             validity;
  UINT8              algo;
  // UINT8              keyId[8];
  
  PgpMPI             n;
  PgpMPI             e;
  
  PgpTrust           *trust;

  
};

#endif
