/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qfont.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include "view.h"
#include <klocale.h>

void  view_w::initDialog(){
  this->resize(360,270);
  this->setMinimumSize(0,0);

  id_lcd= new QLCDNumber(this,"id");
  id_lcd->setGeometry(15,50,70,60);
  id_lcd->setMinimumSize(0,0);
  id_lcd->display("0");
  id_lcd->setNumDigits(1);
	QToolTip::add(id_lcd,i18n("Permision in octal form"));

  user_lcd= new QLCDNumber(this,"user");
  user_lcd->setGeometry(100,50,70,60);
  user_lcd->setMinimumSize(0,0);
  user_lcd->display("0");
  user_lcd->setNumDigits(1);
	QToolTip::add(user_lcd,i18n("Permision in octal form"));

  group_lcd= new QLCDNumber(this,"group");
  group_lcd->setGeometry(185,50,70,60);
  group_lcd->setMinimumSize(0,0);
  group_lcd->display("0");
  group_lcd->setNumDigits(1);
	QToolTip::add(group_lcd,i18n("Permision in octal form"));

  other_lcd= new QLCDNumber(this,"other");
  other_lcd->setGeometry(270,50,70,60);
  other_lcd->setMinimumSize(0,0);
  other_lcd->display("0");
  other_lcd->setNumDigits(1);
	QToolTip::add(other_lcd,i18n("Permision in octal form"));

  id_label= new QLabel(this,"id_label");
  id_label->setGeometry(37,23,40,27);
  id_label->setMinimumSize(0,0);
  id_label->setFont(QFont("helvetica", 12, 75,true));
  id_label->setText(i18n("UID"));

  user_label= new QLabel(this,"user_label");
  user_label->setGeometry(122,23,40,27);
  user_label->setMinimumSize(0,0);
  user_label->setFont(QFont("helvetica", 12, 75,true));
  user_label->setText(i18n("User"));

  group_label= new QLabel(this,"group_label");
  group_label->setGeometry(205,23,40,27);
  group_label->setMinimumSize(0,0);
  group_label->setFont(QFont("helvetica", 12, 75,true));
  group_label->setText(i18n("Group"));

  other_label= new QLabel(this,"other_label");
  other_label->setGeometry(290,23,40,27);
  other_label->setMinimumSize(0,0);
  other_label->setFont(QFont("helvetica", 12, 75,true));
  other_label->setText(i18n("Other"));

  id_box= new QButtonGroup(this,"id_box");
  id_box->setGeometry(15,115,70,70);
  id_box->setMinimumSize(0,0);

  user_box= new QButtonGroup(this,"user_box");
  user_box->setGeometry(100,115,70,70);
  user_box->setMinimumSize(0,0);

  group_box= new QButtonGroup(this,"group_box");
  group_box->setGeometry(185,115,70,70);
  group_box->setMinimumSize(0,0);

  other_box= new QButtonGroup(this,"other_box");
  other_box->setGeometry(270,115,70,70);
  other_box->setMinimumSize(0,0);

  separator= new KSeparator(this,"separator");
  separator->setGeometry(10,210,340,20);
  separator->setMinimumSize(0,0);
  separator->setOrientation(KSeparator::HLine);

  recursive= new QCheckBox(this,"recursive");
  recursive->setGeometry(10,189,90,23);
  recursive->setMinimumSize(0,0);
  QToolTip::add(recursive,i18n("Applies to all items in directory"));
  recursive->setFont(QFont("helvetica", 12, 75,true));
  recursive->setText(i18n("Recursive"));
  recursive->setChecked(true);

}
