#include <iostream.h>
#include <kapp.h>

#include "kbootsel.h"

int main(int argc, char *argv[])
{
	bool debug = false;
	bool giveHelp = false;

	KApplication app(argc, argv, "kbootsel");

    int i = 1;
    while ( i < argc )
    {
        if ( ! qstrcmp ( argv[i], "-d" ) ) debug = true;
        if ( ! qstrcmp ( argv[i], "-h" ) || ! qstrcmp ( argv[i], "-?" ) ) giveHelp = true;
        i++;
    }

    if ( giveHelp )
    {
        cout << endl;
        cout << CAPTION << " " << i18n("version") << " " << VERSION << endl;
        cout << "(c) 1999 " << AUTHOR << " <" << EMAIL << ">" << endl;
        cout << CAPTION << " " << i18n("is free software and comes with ABSOLUTELY NO WARRANTY.") << endl;
        cout << endl;
        cout << i18n("Usage") << ":" << endl;
        cout << "  " << argv[0] << " [" << i18n("options") << "]" << endl;
        cout << endl;
        cout << i18n("Options") << ":" << endl;
        cout << "  -d    " << i18n("Enable debug output") << endl;
        cout << "  -h    " << i18n("Show this help page") << endl;
    } else {
		// All session management is handled in the RESTORE macro
		if (app.isRestored())
		{
			RESTORE(KBootSel)
		}
		else
		{
			KBootSel *widget = new KBootSel ( debug );
			widget->show();
		}

		return app.exec();
	}
}
