/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonconfigdlg.h,v 1.4 1999/01/15 06:08:49 russ Exp $
 *
 * $Log: kbatmonconfigdlg.h,v $
 * Revision 1.4  1999/01/15 06:08:49  russ
 * Added file headers.
 *
 *
 */
 
#ifndef _KBATMONCONFIGDLG_H_
#define _KBATMONCONFIGDLG_H_

#include <qdialog.h>

#include "kbatmonapp.h"
#include "kbatmonconfig.h"

class QPushButton;
class KTabCtl;
class KKeyChooser;
class QCheckBox;
class QWidgetStack;

class TabPage : public QWidget
{
   Q_OBJECT
     
 public:
   TabPage( KTabCtl *, KBatMonConfig & );
   virtual ~TabPage();

   virtual void prepare(void) = 0;
   virtual void apply(void) = 0;
   
 protected:
   KBatMonConfig &config;
   
};

class GeneralSettingsPage : public TabPage
{
   Q_OBJECT
     
 public:
   GeneralSettingsPage( KTabCtl *, KBatMonConfig & );
   virtual ~GeneralSettingsPage();

   void prepare(void);
   void apply(void);
     
 protected:
   QCheckBox *dockInPanel;
   QCheckBox *useSessionManagement;
};

class WarningSettingsPage : public TabPage
{
  Q_OBJECT

 public:
   WarningSettingsPage( KTabCtl *, KBatMonConfig & );
   virtual ~WarningSettingsPage();
   
   void prepare(void);
   void apply(void);
   
 protected:
   QCheckBox *lowBatWarning;
};

class KeyConfigPage : public TabPage
{
   Q_OBJECT
     
 public:
   KeyConfigPage( KTabCtl *, KBatMonConfig & );
   virtual ~KeyConfigPage();
   
   void prepare(void);
   void apply(void);
   
 protected:
   
   QDict<KKeyEntry> keyDict;
   KKeyChooser *keyChooser;
   
};

class KBatMonConfigDialog : public QDialog
{
   Q_OBJECT

 public:
   KBatMonConfigDialog( KBatMonConfig & );
   virtual ~KBatMonConfigDialog();

 private slots:
   void showTab( int );

   void okPressed();
   void applyPressed();
   void cancelPressed();
   
 private:

   // Pages
   GeneralSettingsPage *generalSettings;
   WarningSettingsPage *warningSettings;
   KeyConfigPage *keySettings;
   
   KBatMonConfig &config;
   KTabCtl *tabBar;
   QPushButton *okBtn;
   QPushButton *applyBtn;
   QPushButton *cancelBtn;
   QCheckBox *dockInPanel;
   QCheckBox *lowBatWarning;
   QWidgetStack *pages;
   
};

#endif /* _KBATMONCONFIG_H_ */

