/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "crecherche.h"

CRecherche::CRecherche(QDialog *parent, const char *name ) : QDialog(parent,name,TRUE)
{
	listView = new QListView( this, "ListView_1" );
	listView->setGeometry( 5, 0, 210, 300 );
	listView->setMinimumSize( 0, 0 );
	listView->setMaximumSize( 32767, 32767 );
	listView->setFocusPolicy( QWidget::TabFocus );
	listView->setBackgroundMode( QWidget::PaletteBackground );
	listView->setFontPropagation( QWidget::NoChildren );
	listView->setPalettePropagation( QWidget::NoChildren );
	listView->setFrameStyle( 0 );
	listView->setLineWidth( 1 );
	listView->setMidLineWidth( 0 );
	listView->QFrame::setMargin( 0 );
	listView->setResizePolicy( QScrollView::Manual );
	listView->setVScrollBarMode( QScrollView::Auto );
	listView->setHScrollBarMode( QScrollView::Auto );
	listView->setTreeStepSize( 20 );
	listView->setMultiSelection( FALSE );
	listView->setAllColumnsShowFocus( FALSE );
	listView->setItemMargin( 1 );
	listView->setRootIsDecorated( FALSE );
	listView->addColumn( i18n("Where to search:"), -1 );
	listView->setColumnWidthMode( 0, QListView::Maximum );
	listView->setColumnAlignment( 0, 1 );

	repertoire=new Directory(listView);
	repertoire->setOpen(TRUE);
	connect(listView, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(recupere(QListViewItem*)));

	qtarch_LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
	qtarch_LineEdit_1->setGeometry( 330, 10, 150, 30 );
	qtarch_LineEdit_1->setMinimumSize( 0, 0 );
	qtarch_LineEdit_1->setMaximumSize( 32767, 32767 );
	qtarch_LineEdit_1->setFocusPolicy( QWidget::StrongFocus );
	qtarch_LineEdit_1->setBackgroundMode( QWidget::PaletteBase );
	qtarch_LineEdit_1->setFontPropagation( QWidget::NoChildren );
	qtarch_LineEdit_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_LineEdit_1->setText( "" );
	qtarch_LineEdit_1->setMaxLength( 32767 );
	qtarch_LineEdit_1->setFrame( QLineEdit::Normal );
	qtarch_LineEdit_1->setFrame( TRUE );

	archtrouvees = new QListBox(this,"listBox_archives_trouvees");
	archtrouvees->setGeometry(225, 50,250,200);
	
	QLabel* qtarch_Label_1;
	qtarch_Label_1 = new QLabel( this, "Label_1" );
	qtarch_Label_1->setGeometry( 225, 10, 100, 30 );
	qtarch_Label_1->setMinimumSize( 0, 0 );
	qtarch_Label_1->setMaximumSize( 32767, 32767 );
	qtarch_Label_1->setFocusPolicy( QWidget::NoFocus );
	qtarch_Label_1->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_Label_1->setFontPropagation( QWidget::NoChildren );
	qtarch_Label_1->setPalettePropagation( QWidget::NoChildren );
	qtarch_Label_1->setFrameStyle( 0 );
	qtarch_Label_1->setLineWidth( 1 );
	qtarch_Label_1->setMidLineWidth( 0 );
	qtarch_Label_1->QFrame::setMargin( 0 );
	qtarch_Label_1->setText( i18n("Search in:") );
	qtarch_Label_1->setAlignment( 289 );
	qtarch_Label_1->setMargin( -1 );

	/*aditional init*/
  led1=new KLed(KLed::green,this,"led1");
  led1->setGeometry(228,260,10,10);

  led2=new KLed(KLed::green,this,"led2");
  led2->setGeometry(241,260,10,10);

  led3=new KLed(KLed::green,this,"led3");
  led3->setGeometry(254,260,10,10);

  led4=new KLed(KLed::green,this,"led4");
  led4->setGeometry(267,260,10,10);

  initLeds();

	bextraire=new QPushButton(i18n("Search"), this, "bouton extraction");
  bextraire->setGeometry( 300, 270, 85, 30 );
  bextraire->setFont( QFont( "Times", 18, QFont::Bold ) );	
  connect(bextraire, SIGNAL(clicked()), SLOT(slotDemarreRecherche()));

	QPushButton *bannulle;	
	bannulle=new QPushButton(i18n("Close"), this, "bouton annuller");
  bannulle->setGeometry( 400, 270, 85, 30 );
  connect(bannulle, SIGNAL(clicked()), SLOT(PasExtraction()));

	resize( 490,310 );
	setMinimumSize( 490, 310 );
	setMaximumSize( 490, 310 );
	chemin="";
	stade=0;
	
	connect(&processrecherche, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(recueStdout(KProcess*, char*, int)));
	connect(&processrecherche, SIGNAL(processExited(KProcess*)), this, SLOT(sortieProcess(KProcess*)));
	
}

CRecherche::~CRecherche(){
}

void CRecherche::recupere(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		chemin="/"+chemin;
		chemin=l->text(0)+chemin;
		recupere(l->parent());
	}
	else
	{
		chemin="/"+chemin;
		qtarch_LineEdit_1->setText( chemin );
		chemin="";
	}
}

const char* CRecherche::getCheminAcces()
{
	return (const char*)chemin;
}

void CRecherche::PasExtraction()
{
	reject();	
}

void CRecherche::setCheminAcces(const char* chemin, int optionExtraction){
	switch(optionExtraction)
	{
		case 0:
			qtarch_LineEdit_1->setText(chemin);
			break;
		case 1:
			qtarch_LineEdit_1->setText(QDir::homeDirPath());
			break;
		case 2:
			qtarch_LineEdit_1->setText(QDir::currentDirPath());
			break;
	}			
}

/** Start the search */
void CRecherche::slotDemarreRecherche(){
	chemin=qtarch_LineEdit_1->text();

	if(chemin=="")
		return;

	initLeds();
	stade=1;		
	archtrouvees->clear();
	processrecherche.clearArguments();
	processrecherche << "find";
	processrecherche << (const char*)chemin;
	processrecherche << "-iname";
	processrecherche << "*.gz";
	processrecherche.start(KProcess::NotifyOnExit, KProcess::Stdout);
}

/** The process ended */
void CRecherche::sortieProcess(KProcess*)
{
	processrecherche.clearArguments();
	processrecherche << "find";
	processrecherche << (const char*)chemin;
	processrecherche << "-iname";
	stade++;
	if(stade==2)
	{
		led1->setState(KLed::On);
	  processrecherche << "*.bz2";
	}
	else if(stade==3)
	{
		led2->setState(KLed::On);
		processrecherche << "*.tgz";
	}
	else if(stade==4)
	{
		led3->setState(KLed::On);
		processrecherche << "*.zip";
	}	
	else if(stade==5)
	{
		led4->setState(KLed::On);
		stade=0;
		return;
	}
	else
		return;
		
	processrecherche.start(KProcess::NotifyOnExit, KProcess::Stdout);
}

/** output of the process */
void CRecherche::recueStdout(KProcess* p, char* buffer, int len)
{
	QString str;
	int i;
	
	str="";
	for(i=0;i<len;i++)
	{
		if(buffer[i]=='\n')
		{
			archtrouvees->insertItem((const char*)str);
			str="";
		}
		else
			str+=buffer[i];
	}
}

/** Set all leds to green, state=off */
void CRecherche::initLeds()
{
	led1->setState(KLed::Off);
	led1->setColor(KLed::green);
	led2->setState(KLed::Off);
	led2->setColor(KLed::green);
	led3->setState(KLed::Off);
	led3->setColor(KLed::green);		
	led4->setState(KLed::Off);
	led4->setColor(KLed::green);
}