#include "play.H"

#include <unistd.h>
#include <signal.h>

#include <qmsgbox.h>
#include <qstring.h>

#include <kconfig.h>
#include <kprocess.h>
#include <kapp.h>


TPlay::TPlay( QWidget *parent, const char *name )
      : QWidget( parent, name ) {

	Play = 0;

}


TPlay::~TPlay() {

  stop();
  
}


void TPlay::start( const char *filename, const int volume ) {

  QString vol;
  vol.sprintf( "%i", volume );
  
  stop();
  
  Play = new KProcess();
  
  // figure out which version we are running
  KConfig *conf   = kapp->getConfig();
  int     version = conf->readNumEntry( "VboxVersion", 1 );

  if ( version == 1 )
    *Play << "auplay" << filename << vol.data();
  if ( version == 2 )
    *Play << "vboxplay" << filename << vol.data();
  
  connect( Play, SIGNAL( processExited( KProcess* ) ),
	   SLOT( slotPlayStopped( KProcess* ) ) );
  
  if ( ! Play->start() ) 
    QMessageBox::warning( this, "Fatal Error",
			  "Message could not be\n"
			  "played !\n\n", "OK", 0);
  
  // need to set process group id to process id, so
  // that the whole group can be killed w/o killing kam ;-)
  setpgid( Play->getPid(), 0 );
  
}


void TPlay::stop() {

  if ( Play ) {
    Play->kill( SIGKILL );
    // kill the whole group
    killpg( getpgid( Play->getPid() ), SIGKILL );
    delete Play;
    Play = 0;
  }

}

void TPlay::slotPlayStopped( KProcess *process ) {

  debug( "Process terminated. Pid: %i\n", (int)process->getPid() );

}


#include "play.moc"
