/**********************************************************************

	--- Qt Architect generated file ---

	File: TalkDialog.cpp
	Last generated: Fri Apr 3 14:57:17 1998

 *********************************************************************/

#include "TalkDialog.h"
#include <kapp.h>
#include "debug.h"
#define Inherited TalkDialogData

TalkDialog::TalkDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  setCaption(i18n("Select talk address"));
  buttonOK->setText(i18n("OK"));
  buttonCancel->setText(i18n("Cancel"));
  // -----
  initializeGeometry();
}


TalkDialog::~TalkDialog()
{
}

void TalkDialog::add(const string& text)
{
  comboAddresses->insertItem(text.c_str());
}

string TalkDialog::address()
{
  return comboAddresses->currentText();
}

void TalkDialog::initializeGeometry()
{
  const int Grid=5;
  int cx=2*Grid+comboAddresses->fontMetrics().width
    ("a very very very long talk address"),
    cy=Grid, 
    tempx=QMAX
    (buttonOK->sizeHint().width(),
     buttonCancel->sizeHint().width()),
    tempy;
  cx=QMAX(cx, tempx);
  // -----
  tempy=comboAddresses->sizeHint().height();
  comboAddresses->setGeometry
    (Grid, cy, cx-2*Grid, tempy);
  cy+=tempy+Grid;
  // -----
  frameLine->setGeometry
    (Grid, cy, cx-2*Grid, Grid);
  cy+=2*Grid;
  // -----
  buttonOK->setGeometry
    (Grid, cy, tempx, buttonOK->sizeHint().height());
  buttonCancel->setGeometry
    (cx-tempx-Grid, cy, tempx, buttonOK->sizeHint().height());
  cy+=buttonOK->sizeHint().height()+Grid;
  // -----
  setFixedSize(cx, cy);
}

#include "TalkDialog.moc"
#include "TalkDialogData.moc"
