#include "accdlg.h"
#include "pixmaps/keys.xpm"


AuthWidget::AuthWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 323, 316);
  GBox->setTitle(klocale->translate("Authentication"));
  
  AuthGroup = new QButtonGroup(this);
  AuthGroup->setLineWidth(0);
  AuthVBox = new QVBoxLayout(AuthGroup, 10);
  AuthGroup->move(84, 60);
  
  PAPButton = new QRadioButton(AuthGroup);
  PAPButton->setText(klocale->translate("PAP Authentication"));
  PAPButton->setChecked((ISDNData.Current)->UsePAP);
  AuthVBox->addWidget(PAPButton);
  PAPButton->setMinimumSize(PAPButton->sizeHint());
  QToolTip::add( PAPButton, klocale->translate("Normal Authentication") );
  
  CHAPButton = new QRadioButton(AuthGroup);
  CHAPButton->setText(klocale->translate("CHAP Authentication"));
  CHAPButton->setChecked((ISDNData.Current)->UseCHAP);
  AuthVBox->addWidget(CHAPButton);
  CHAPButton->setMinimumSize(CHAPButton->sizeHint());
  QToolTip::add( CHAPButton, klocale->translate("Encrypted Authentication") );
    
  AuthVBox->activate();

  connect(AuthGroup, SIGNAL(clicked(int)), SLOT(slotAuthChanged(int))); 

  pmKey = new QLabel(this);
  pmKey->setPixmap(keys_xpm);
  pmKey->setGeometry(274, 32, 48, 48);

  /*
  Etched = new QFrame(this);
  Etched->setFrameStyle(0x34);
  Etched->setLineWidth(2);
  Etched->setGeometry(20, 100, 300, 2);
  */
  
  Userlabel = new QLabel(klocale->translate("User Name:"), this);
  Userlabel->setGeometry(72, 160, 80, 24);
  
  User = new QLineEdit(this);
  User->setGeometry(150, 160, 100, 24);
  User->setMaxLength(NAMESIZE);
  User->setText((ISDNData.Current)->username.data());

  Passwordlabel = new QLabel(klocale->translate("Password:"), this);
  Passwordlabel->setGeometry(80, 192, 100, 24);
  
  Password = new QLineEdit(this);
  Password->setGeometry(150, 192, 100, 24);
  Password->setMaxLength(NAMESIZE);
  Password->setText((ISDNData.Current)->password.data());
  Password->setEchoMode(QLineEdit::Password);
}    


void AuthWidget::slotAuthChanged(int type)
{
  AccData *acc = ISDNData.Current;
  
  acc->UsePAP  = !(bool) type;
  acc->UseCHAP = (bool) type;
}
