#include "accdlg.h"


DNSWidget::DNSWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 323, 316);
  GBox->setTitle(klocale->translate("DNS Setup"));
  
  Domainlabel = new QLabel(klocale->translate("Domain:"), this);
  Domainlabel->setGeometry(30, 50, 60, 24);
  
  Domain = new QLineEdit(this);
  Domain->setGeometry(114, 50, 140, 24);
  Domain->setMaxLength(NAMESIZE);
  Domain->setText((ISDNData.Current)->domain);
  
  DNSlabel = new QLabel(klocale->translate("IP Address:"), this);
  DNSlabel->setGeometry(30, 114, 80, 24);
  
  DNS = new QLineEdit(this);
  DNS->setGeometry(114, 114, 118, 24);
  DNS->setMaxLength(IPNMSIZE);
  
  AddButton = new QPushButton(klocale->translate("Add"), this);
  AddButton->setGeometry(244, 113, 70, 28);
  connect(AddButton, SIGNAL(clicked()), SLOT(slotAddDNS()));
  
  DNSListlabel = new QLabel(klocale->translate("Address List:"), this);
  DNSListlabel->setGeometry(30, 148, 80, 24);
  
  DNSList = new QListBox(this);
  DNSList->setGeometry(114, 152, 118, 120);
  
  if ((ISDNData.Current)->FirstDNS != (DNSData *) 0L)
  {
    DNSData *actual = (ISDNData.Current)->FirstDNS;
    
    while (actual != (DNSData *) 0L)
    {
      DNSList->insertItem(actual->ipaddress.data());
      actual = actual->next;
    }
  }
  
  RemButton = new QPushButton(klocale->translate("Remove"), this);
  RemButton->setGeometry(244, 152, 70, 28);
  connect(RemButton, SIGNAL(clicked()), SLOT(slotRemoveDNS()));
}


void DNSWidget::messageBadIP(void)
{
      QMessageBox::warning(this, "Invalid IP number",
    			         "An IP address consists of 4\n"    				   
		                 "numbers in the range 0..255\n"
				 "separated by dots\n\n", "OK", 0);

}


void DNSWidget::slotAddDNS(void)
{   
  IP *ip = new IP(DNS->text());

  if (!ip->isValidIP())
  {
    messageBadIP();
    return;
  }    
  delete ip;
  
  (ISDNData.Current)->CurrDNS = new DNSData();
  if ((ISDNData.Current)->FirstDNS != (DNSData *) 0L)
  {
    ((ISDNData.Current)->CurrDNS)->prev = (ISDNData.Current)->LastDNS;
    ((ISDNData.Current)->LastDNS)->next = (ISDNData.Current)->CurrDNS;
  }
  else (ISDNData.Current)->FirstDNS = (ISDNData.Current)->CurrDNS;
  
  (ISDNData.Current)->LastDNS = (ISDNData.Current)->CurrDNS;
  ((ISDNData.Current)->CurrDNS)->ipaddress = DNS->text();
  DNSList->insertItem(((ISDNData.Current)->CurrDNS)->ipaddress.data());
  DNS->setText("");
}
  
  
void DNSWidget::slotRemoveDNS(void)
{
  int help, index = DNSList->currentItem();
  
  if (index > -1)
  {
    DNSData *actual = (ISDNData.Current)->FirstDNS;
    help = index;
    
    while (index > 0)
    {
      actual = actual->next;
      index--;
    }
    
    if (actual->next != (DNSData *) 0L) (actual->next)->prev = actual->prev;
    else (ISDNData.Current)->LastDNS = actual->prev;
    if (help == 0) (ISDNData.Current)->FirstDNS = actual->next;
    else (actual->prev)->next = actual->next;
    
    delete actual;
    DNSList->removeItem(help);
  }
}
