/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _CRITERIA_H_
#define _CRITERIA_H_


#include <qwidget.h>
#include <qdatetime.h>


class QComboBox;
class QCheckBox;
class QLabel;
class QBoxLayout;
class KDatePicker;


class CriterionSpecial : public QObject
{
    Q_OBJECT
    
public:
    virtual ~CriterionSpecial()
	{}
    virtual QString type() = 0;
    virtual void addToLayout(QBoxLayout *lay) = 0;
    virtual QString findString() = 0;

signals:
    void wantLayout();
};


class CriterionTime : public CriterionSpecial
{
    Q_OBJECT
    
public:
    CriterionTime(QWidget *parent);
    virtual ~CriterionTime();
    
    virtual QString type();
    virtual void addToLayout(QBoxLayout *lay);
    virtual QString findString();

private slots:
    void datePicked(QDate);

private:
    QComboBox *combo;
    KDatePicker *picker;
    QDate date;
};


class Criterion : public QWidget
{
    Q_OBJECT
    
public:
    Criterion( QWidget *parent=0, const char *name=0 );
    QString findString();

protected slots:
    void typeActivated(const char *type);
    void layout();

private:
    QBoxLayout *lay;
    QComboBox *typecombo;
    CriterionSpecial *spec;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
