/*
                          casp.cpp  -  description
                             -------------------
    begin                : Mon Nov 29 20:04:41 MET 1999
    copyright            : (C) 1999 by Andreas Heil
    email                : Andreas@Heil.net
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

#include "casp.h"

Casp::Casp(QWidget*parent,const char* name):KTMainWindow(name){
	config = kapp->getConfig();
	srand(time(0));
	initMenuBar();
	initView();
	readOptions();
}

Casp::~Casp(){
	if(autoSave)
		saveOptions();
}

void Casp::initMenuBar(){
	fileMenu = new QPopupMenu();
	fileMenu->insertItem(i18n("E&xit"),ID_FILE_EXIT);

	optionsMenu = new QPopupMenu();
	optionsMenu->setCheckable(true);
	optionsMenu->insertItem(i18n("&Save Options"),ID_OPTIONS_SAVE_OPTIONS);
	optionsMenu->insertItem(i18n("&Autosave"),ID_OPTIONS_AUTOSAVE_OPTIONS);

	menuBar()->insertItem(i18n("&File"),fileMenu);
	menuBar()->insertItem(i18n("&Options"),optionsMenu);
	menuBar()->insertSeparator();
	menuBar()->insertItem(i18n("&Help"),kapp->getHelpMenu(true,"Create A Secure Password\n Version " VERSION "\n(c) 1999 by Andreas Heil"));

  connect(fileMenu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(optionsMenu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
}

void Casp::saveOptions(){
	config->setGroup("General Options");
	config->writeEntry("AutoSave", autoSave);

	config->setGroup("Password Options");
	config->writeEntry("Length", lenBox->value());
	config->writeEntry("UseNumbers", number->isChecked());
	config->writeEntry("UseLower", lower->isChecked());
	config->writeEntry("UseUpper", upper->isChecked());
	config->writeEntry("UseDollar", dollar->isChecked());
	config->writeEntry("UseSpecials", specials->isChecked());
	config->writeEntry("Specials", specialsField->text());
}

void Casp::readOptions() {
	QString p="";
	
	config->setGroup("General Options");
	autoSave=config->readBoolEntry("AutoSave",true);
	optionsMenu->setItemChecked(ID_OPTIONS_AUTOSAVE_OPTIONS, autoSave);

	config->setGroup("Password Options");
	lenBox->setValue(config->readNumEntry("Length",8));
	number->setChecked(config->readBoolEntry("UseNumbers",true));
	upper->setChecked(config->readBoolEntry("UseUpper",false));
	dollar->setChecked(config->readBoolEntry("UseDollar",false));
	specials->setChecked(config->readBoolEntry("UseSpecials",false));
	lower->setChecked(config->readBoolEntry("UseLower",true));
	p.append(config->readEntry("Specials","+-"));
	specialsField->setText(p);
}

void Casp::commandCallback(int id_){
  switch (id_){
		case ID_FILE_EXIT:
			close();
			break;
    case ID_OPTIONS_AUTOSAVE_OPTIONS:
    	optionsAutosave();
			config->setGroup("General Options");
			config->writeEntry("AutoSave", autoSave);
    	break;
		case ID_OPTIONS_SAVE_OPTIONS:
			saveOptions();
			break;
    default:
    	break;
  }
}

void Casp::optionsAutosave(){
	if(optionsMenu->isItemChecked(ID_OPTIONS_AUTOSAVE_OPTIONS))
		autoSave=false;
	else
		autoSave=true;
	optionsMenu->setItemChecked(ID_OPTIONS_AUTOSAVE_OPTIONS, autoSave);
}

void Casp::initView(){
	mainView = new KTabCtl(this,"mainView");
	singleTab = new QWidget(mainView,"singleTab");
	QBoxLayout* vBox = new QVBoxLayout(singleTab,5);
	QGridLayout* gBox = new QGridLayout(5,3);

	pwdField = new KLined(singleTab);
	pwdField->setFont(QFont("courier",18));
	pwdField->setText("XXXXXXXXXXXXXXX");
	pwdField->setMinimumWidth(pwdField->sizeHint().width());
	pwdField->setFixedHeight(pwdField->sizeHint().height());
	pwdField->clear();

	goButton = new QPushButton(i18n("Go Create Password!"),singleTab);
	goButton->setFixedHeight(goButton->sizeHint().height());

	lenBox = new QSpinBox(5,15,1,singleTab);
	lenBox->setValue(8);
	lenBox->setFixedSize(lenBox->sizeHint());

	lenLabel = new QLabel(i18n("Length:"),singleTab);
	lenLabel->setMinimumSize(lenLabel->sizeHint().width(),lenBox->height());

	typeLabel = new QLabel(i18n("Type:"),singleTab);
	typeLabel->setMinimumSize(typeLabel->sizeHint());

	number = new QCheckBox("0-9",singleTab);
	number->setMinimumSize(number->sizeHint());

	lower = new QCheckBox("a-z",singleTab);
	lower->setMinimumSize(lower->sizeHint());

	upper = new QCheckBox("A-Z",singleTab);
	upper->setMinimumSize(upper->sizeHint());

	dollar = new QCheckBox("$",singleTab);
	dollar->setMinimumSize(dollar->sizeHint());

	specials = new QCheckBox(i18n("Specials"),singleTab);
	specials->setMinimumSize(specials->sizeHint());

	specialsField = new KLined(singleTab);
	specialsField->setMaxLength(15);
	specialsField->setFont(QFont("courier",18));
	specialsField->setFixedHeight(pwdField->height());

	vBox->addWidget(pwdField,0,AlignCenter);
	vBox->addWidget(goButton,0,AlignCenter);
	vBox->addLayout(gBox,0);

	gBox->addWidget(lenLabel,0,0);
	gBox->addWidget(lenBox,0,1);
	gBox->addWidget(typeLabel,1,0);
	gBox->addWidget(number,1,1);
	gBox->addWidget(dollar,1,2);
	gBox->addWidget(lower,2,1);
	gBox->addWidget(upper,2,2);
	gBox->addMultiCellWidget(specials,3,3,1,2);
	gBox->addMultiCellWidget(specialsField,4,4,0,2);

	vBox->activate();

	mainView->addTab(singleTab,i18n("Single Password"));
	setView(mainView);

	mainView->adjustSize();
	setFixedSize(mainView->x()+mainView->width(),mainView->y()+mainView->height()+menuBar()->height());

	connect(goButton,SIGNAL(clicked()),this,SLOT(slotGenPwd()));
}

void Casp::slotGenPwd(){
	QString n="",p="", str="";
	int i,len=0,pwdLength=lenBox->value();

	if(number->isChecked()) {
		str.append("0123456789");
	}
	if(lower->isChecked()) {
		str.append("abcdefghijklmnopqrstuvwxyz");
	}
	if(upper->isChecked()) {
		str.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	}
	if(dollar->isChecked()) {
		str.append("$");
	}
	if(specials->isChecked()) {
		str.append(specialsField->text());
	}
	
	len = str.length();
	
	for (i=0;i<pwdLength;i++) {
		n.sprintf("%c",str.at((int)(1.0*len*rand()/(RAND_MAX+1.0))));
		p.append(n);
	}
	
	pwdField->setText(p);
}
