/***************************************************************************
                            -  description
                             -------------------
    begin                : Sat Oct 23 1999
    copyright            : (C) 1999 by Rene Mrten, Christian Fricke
                           und Torsten Enkelmann
    email                : @-Mail to: delta_x@LinuxCoding.DE
                                      cfricke@LinuxCoding.DE
                                      Torsten@LinuxCoding.DE
****************************************************************************/

#include "dlgsysinfo.h"
#include "sys0.xpm"
#include "sys1.xpm"
#include "sys2.xpm"
#include "sys3.xpm"
#include "sys4.xpm"
#include "sys5.xpm"
#include "sys6.xpm"
#include "sys7.xpm"



bool fertich1 = false;

dlgSysInfo::dlgSysInfo(QWidget *parent, const char *name ) : QDialog(parent,name,true)
{
	setGeometry(x()-100,y()-100,10,10);
	setMinimumSize(650,420);
	setMaximumSize(650,420);
	setCaption(i18n("System information : Use + or - to select, ESC to quit"));
	init();
}

dlgSysInfo::~dlgSysInfo()
{
	delete pmsys0;
	delete pmsys1;
	delete pmsys2;
	delete pmsys3;
	delete pmsys4;
	delete pmsys5;
	delete pmsys6;
	delete pmsys7;
}

void dlgSysInfo::init()
{
	ked = new KEdit(kapp,this,"Show");
	ked->setGeometry(155,0,490,420);
	ked->show();
	tree = new KTreeList(this,"neu");
	tree->resize(150,420);
	
	pmsys0 = new QPixmap((const char **)sys0);
	pmsys1 = new QPixmap((const char **)sys1);
	pmsys2 = new QPixmap((const char **)sys2);
	pmsys3 = new QPixmap((const char **)sys3);
	pmsys4 = new QPixmap((const char **)sys4);
	pmsys5 = new QPixmap((const char **)sys5);
	pmsys6 = new QPixmap((const char **)sys6);
	pmsys7 = new QPixmap((const char **)sys0);
	
	KTreeListItem *cpu = new KTreeListItem(i18n("CPU"),pmsys0);
	KTreeListItem *interupts = new KTreeListItem(i18n("Interupts"),pmsys7);
	KTreeListItem *memory = new KTreeListItem(i18n("Memory"),pmsys1);
	KTreeListItem *modules = new KTreeListItem(i18n("Modules"),pmsys4);
	KTreeListItem *mounted = new KTreeListItem(i18n("Mounted"),pmsys4);
	KTreeListItem *partitions = new KTreeListItem(i18n("Partitions"),pmsys3);
	KTreeListItem *pci = new KTreeListItem(i18n("PCI devices"),pmsys6);
	KTreeListItem *rtc = new KTreeListItem(i18n("RTC"),pmsys0);
	KTreeListItem *stat = new KTreeListItem(i18n("Stat"),pmsys0);
	KTreeListItem *swap = new KTreeListItem(i18n("Swap"),pmsys0);
	KTreeListItem *uptime = new KTreeListItem(i18n("Uptime"),pmsys0);
	KTreeListItem *version = new KTreeListItem(i18n("Version"),pmsys0);

	  tree->insertItem(cpu);
	  tree->insertItem(interupts);
		tree->insertItem(memory);
		tree->insertItem(modules);
		tree->insertItem(mounted);
		tree->insertItem(partitions);
		tree->insertItem(pci);
		tree->insertItem(rtc);
		tree->insertItem(stat);
		tree->insertItem(swap);
		tree->insertItem(uptime);
		tree->insertItem(version);
	
	QApplication::connect(tree,SIGNAL(highlighted(int)),this,SLOT(auswahl(int)));
	tree->setCurrentItem(0);
  tree->show();
}

void dlgSysInfo::auswahl(int id)
{
	KShellProcess proc("bash");
	switch (id)
			{
				case 0:
								anzeige(QString("/proc/cpuinfo"));
				break;
				case 1:
						  	anzeige(QString("/proc/interrupts"));						
				break;
				case 2:
						  	anzeige(QString("/proc/meminfo"));
				break;
				case 3:
						  	anzeige(QString("/proc/modules"));
				break;
				case 4:
								anzeige(QString("/proc/mounts"));
				break;
				case 5:
								anzeige(QString("/proc/partitions"));
				break;
				case 6:
								anzeige(QString("/proc/pci"));
				break;
				case 7:
								anzeige(QString("/proc/rtc"));
				break;
				case 8:
								anzeige(QString("/proc/stat"));
				break;
				case 9:
								anzeige(QString("/proc/swaps"));
				break;
				case 10:
								anzeige(QString("/proc/uptime"));
				break;
				case 11:
								anzeige(QString("/proc/version"));
				break;
			}
	return;
}

void dlgSysInfo::anzeige(QString d)
{
							KShellProcess proc("bash");
							ked->hide();
							proc.clearArguments();
							proc <<"cp";
							proc << d;
							proc << "/tmp/info";
							
							QApplication::connect(&proc, SIGNAL(processExited(KProcess*)),this,SLOT(slotExamine()));							
							proc.start(KProcess::Block,KProcess::All);
		
							while(!fertich1)
							kapp->processEvents();
	
							ked->loadFile("/tmp/info",2);
	
							resize(450,400);
 							ked->show();
 							QDir temp;
						  temp.remove("/tmp/info",true);
						  return;
}

void dlgSysInfo::slotExamine()
{
	fertich1 = true;
	return;
}

void dlgSysInfo::keyPressEvent(QKeyEvent *e)
{
 int key = e->key();
// int state = e->state();
// key = key & 0xfff;
 switch (key)
 	{
 		case 4096:
	 			close();
 			break;
 		case 81:
	 			close();
 			break;
 		case 43:
 				{
	 				int current = tree->currentItem();
	 				if (current <= 10) {tree->setCurrentItem(current+1);}
	 				else tree->setCurrentItem(0);
	 			}
 			break;
 		case 45:
 				{
	 				int current = tree->currentItem();
	 				if (current >> 0) {tree->setCurrentItem(current-1);}
	 				else tree->setCurrentItem(11);
	 			}
 			break;
 	}
}





