/***************************************************************************
                          keyes.cpp  -  description                              
                             -------------------                                         
    begin                : Sun May  2 16:43:55 CEST 1999
                                           
    copyright            : (C) 1999 by Jerome Tollet                         
    email                : jtollet@magic.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kwm.h>
#include <kmsgbox.h>
#include <qpainter.h>
#include "keyes.h"

#define min(a,b) ((a) < (b) ? (a) : (b))

Keyes::Keyes( QWidget *parent, const char *name ) : QWidget(parent, name, WType_Modal)
{
	display=KApplication::getKApplication()->getDisplay();
	root = RootWindow(display,DefaultScreen(display));
	KWM::setDockWindow(winId());
	popup = new QPopupMenu();
	popup->insertItem(i18n("About"));
	popup->insertSeparator();
	popup->insertItem(i18n("Quit"));
	sizeEye=min(height(),width())/6;
	oldPoint1.setX(width()/4);
	oldPoint1.setY(height()/2);
	oldPoint2.setX(3*width()/4);
	oldPoint2.setY(height()/2);
	connect(popup,SIGNAL(activated(int)),SLOT(reactOn(int)));
	startTimer(10);
}

void Keyes::reactOn(int index) {
	if(index == 0 )
		showAbout();
	if(index == 2)
		kapp->quit();
}


void Keyes::showAbout()
{
    KMsgBox::message(0, i18n("About Keyes"),
		     i18n("KDE is watching you\n\n"
			  "Written by Jerome Tollet <tollet@rp.lip6.fr>\n"
			  "\n"));
			
}


void Keyes::paintEvent(QPaintEvent *p )
{
	if(!isVisible())
		return;
	QPainter paint(this);
	paint.setBrush(white);
	paint.drawEllipse(0,0,width()/2,height());
	paint.drawEllipse(width()/2,0,width()/2,height());
}



void Keyes::timerEvent(QTimerEvent*) {
	QPoint p,mouse,vect;
	double cos_alpha,sin_alpha;
    	int WinX, WinY;
	int XCoord,YCoord;

	XQueryPointer (display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	mouse = mapFromGlobal(QPoint(XCoord,YCoord));
	int tmp=min(height(),width())/6;
	//Left eye
	vect.setX(mouse.x()-width()/4);
	vect.setY(mouse.y()-height()/2);

	cos_alpha=vect.x()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
	sin_alpha=vect.y()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
	
	if(vect.x()*vect.x() + vect.y()*vect.y() > (width()/4-tmp)*(width()/4-tmp)*cos_alpha*cos_alpha+(height()/2-tmp)*(height()/2-tmp)*sin_alpha*sin_alpha) {
		p.setX((width()/4-tmp)*cos_alpha+width()/4);
		p.setY((height()/2-tmp)*sin_alpha+height()/2);	
	} else {
		p=mouse;
	}
	
	if( (p.x() != oldPoint1.x()) || (p.y() != oldPoint1.y())) {
		QPainter paint(this);
		paint.setPen(white);
		paint.setBrush(white);
		paint.drawEllipse(oldPoint1.x()-sizeEye/2,oldPoint1.y()-sizeEye/2,sizeEye,sizeEye);
		paint.setPen(QPen(black));
		paint.drawEllipse(0,0,width()/2,height());
		paint.setBrush(QBrush(black));
		sizeEye=min(height(),width())/6;
		paint.drawEllipse(p.x()-sizeEye/2,p.y()-sizeEye/2,sizeEye,sizeEye);	
		oldPoint1 = p;
	}

	//Right eye
	vect.setX(mouse.x()-3*width()/4);
	vect.setY(mouse.y()-height()/2);

	cos_alpha=vect.x()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
	sin_alpha=vect.y()/sqrt(vect.x()*vect.x()+vect.y()*vect.y());
	
	if(vect.x()*vect.x() + vect.y()*vect.y() > (width()/4-tmp)*(width()/4-tmp)*cos_alpha*cos_alpha+(height()/2-tmp)*(height()/2-tmp)*sin_alpha*sin_alpha) {
		p.setX((width()/4-tmp)*cos_alpha+3*width()/4);
		p.setY((height()/2-tmp)*sin_alpha+height()/2);	
	} else {
		p=mouse;
	}

	
	if( (p.x() != oldPoint2.x()) || (p.y() != oldPoint2.y())) {
		QPainter paint(this);
		paint.setPen(white);
		paint.setBrush(white);
		paint.drawEllipse(oldPoint2.x()-sizeEye/2,oldPoint2.y()-sizeEye/2,sizeEye,sizeEye);
		paint.setPen(QPen(black));
		paint.drawEllipse(width()/2,0,width()/2,height());
		paint.setBrush(QBrush(black));
		sizeEye=min(height(),width())/6;
		paint.drawEllipse(p.x()-sizeEye/2,p.y()-sizeEye/2,sizeEye,sizeEye);	
		oldPoint2 = p;
	}

}


void Keyes::mousePressEvent(QMouseEvent *e) {
 if (e->button() == RightButton) {
	popup->popup(mapToGlobal(e->pos()));
	popup->exec();
    }
    if (e->button() == LeftButton) {
	showAbout();
    }
}




