/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef KTHEMECOLORCONFIG_H
#define KTHEMECOLORCONFIG_H

#include <kapp.h>
#include <kcontrol.h>
#include <widgetcanvas.h>
#include <qlistbox.h>

class KThemeColorConfig : public KConfigWidget{
	Q_OBJECT
public:
	KThemeColorConfig(QWidget *parent=0, const char *name=0, bool init=FALSE);
	~KThemeColorConfig();
	void resizeEvent(QResizeEvent *);
	void writeSettings();
	void loadSettings();

	Display 	*kde_display;
	Atom 		KDEChangePalette;
	Window          root;
	int 		screen;

public slots:
	void applySettings();
	void selectScheme(int index);
	void apply();
	void loadScheme(QString name);

protected:
	QListBox 	*scheme_Listbox;
	WidgetCanvas	*preview;
	QString		path_scheme;
	QString		oldscheme;
};

#endif


