#include <qbitmap.h>

#include "animcur.hpp"
#include "animcur.moc"

KAnimCursor::KAnimCursor
(
	unsigned char *bs[],
	unsigned char *ms[],
	int cnt
)
{
	cursors = new QArray<QCursor*>(cnt);
	for (int i = 0; i < cnt; i++)
		cursors->at(i) = new QCursor(
			QBitmap(32, 32, bs[i], TRUE), QBitmap(32, 32, ms[i], TRUE));

	widget = NULL;
	fnum = 0;

	connect(&timer, SIGNAL(timeout()), this, SLOT(nextFrame()));
}

KAnimCursor::~KAnimCursor()
{
	for (int i = 0, sz = cursors->size(); i < sz; delete cursors->at(i++));
	delete cursors;
}

void KAnimCursor::nextFrame()
{
	int sz;

	if (widget && (sz = cursors->size()))
	{
		widget->setCursor(*cursors->at(fnum));
		if (++fnum >= sz)
			fnum = 0;
	}
}

void KAnimCursor::start
(
	QWidget *w
)
{
	widget = w;
	timer.start(500);
}

void KAnimCursor::stop()
{
	timer.stop();
}
