#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <linux/soundcard.h>

#include <qwidget.h>

//#include "sound.h"
#include "fft.moc"
#include "oss.h"

#define FFT_MAX     8192
#define FFT_LEFT     100
#define FFT_RIGHT  20000

/* soundfft.c */
extern int *BitReversed;
extern "C" void InitializeFFT(int fftlen);
extern "C" void EndFFT();
extern "C" void RealFFT(short *buffer);

/* ---------------------------------------------------------------------- */

FFTWindow::FFTWindow(QWidget *parent, char *name) : QWidget(parent,name,0)
{
    /* flag: no init so far... */
    channels = 0;
    logmap = NULL;
    paused=0;
}

void
FFTWindow::make_logmap()
{
    int   i,w,h;
    float freq,up;

    w = 200;
    h = 100;

    if (!w || !h || !channels)
	return;
    
    if (logmap) {
        free(logmap);
	free(buffer);
	EndFFT();
    }
    logmap   = (int*) malloc((w+1)*sizeof(int));
    buffer   = (short*)malloc(fft_size*sizeof(short)*channels);
    InitializeFFT(fft_size);

    up = log(FFT_RIGHT/FFT_LEFT)/log(2);
    for (i = 0; i <= w; i++)
      {
        freq = pow(2,up*i/w)* FFT_LEFT;
	logmap[i] = (int)(fft_size*freq/rate);
      }
}

void
FFTWindow::calculate(unsigned char *data)
{
    int i,j;

    switch (afmt) {
    case FMT_8BIT:
        for (i = 0; i < audio_size; i++)
            buffer[i] = (data[i] ^ 0x80) << 8;
        break;
#if 0
    case AFMT_S8:
        for (i = 0; i < audio_size; i++)
            buffer[i] = data[i] << 8;
        break;
#endif
    case FMT_16BIT:
        memcpy(buffer,data,audio_size);
#if 0
	/* byte swap */
	for (i = 0; i < fft_size; i++)
	    buffer[i] =
		((buffer[i] & 0xff00) >> 8) |
		((buffer[i] & 0x00ff) << 8);
	/* unsigned -> signed */
        if (afmt == AFMT_U16_LE || afmt == AFMT_U16_BE)
            for (i = 0; i < fft_size; i++)
                buffer[i] ^= 0x8000;
#endif
        break;
    default:
        fprintf(stderr,"oops(fft): unknown sound format\n");
        exit(1);
    }

    for (i = 0, lmax = 0; i < fft_size; i++)
        if ((j = abs((signed short)buffer[i])) > lmax)
            lmax = j;

    if (channels == 2) {
        for (i = 0, j = 0; i < fft_size; i++, j+=2)
            buffer[i] = (buffer[j]+buffer[j+1])>>1;
    }
    RealFFT(buffer);
}

void
FFTWindow::drawhist()
{
    data=0;
    for (int k=0;k<20;k++) fdata.num[k] = 0;

    int re,im,ab;
    int i,j,max,w,h;
    int len = fft_size>>1;

    w = 200;
    h = 100;

    for (i = 0; i < w; i++) {
        max = 0;
        j = logmap[i];
        do {
            if (j >= len)
                break;
            re = buffer[BitReversed[j]];
            im = buffer[BitReversed[j]+1];
            ab = re*re+im*im;
            if (ab > max)
                max = ab;
            j++;
        } while (j < logmap[i+1]);
        //max = (int)sqrt(max) * h * logmap[i/2] / 4/  FFT_MAX;
        max = (int)sqrt(max) * (h << 1) / (20+logmap[w-i]/10)/ 128;
	//max = (int)sqrt(max) * logmap[w] / 32;
	//max = 5 + logmap[w-i]/10;
	int a;
	a = max/10;

	fdata.num[i/10] += a;
    }
    emit sendData(&fdata);
}

/* ---------------------------------------------------------------------- */

void
FFTWindow::new_params(struct SOUNDPARAMS *p)
{
    afmt        = p->format;
    channels    = p->channels;
    rate        = p->rate;
    audio_size  = p->blocksize;

    fft_size = audio_size/channels/2;
    if (afmt != FMT_16BIT)
        fft_size *= 2;

    make_logmap();
}

void
FFTWindow::new_data(void *data)
{
    if (!paused)
    {
      calculate((unsigned char*)data);
      drawhist();
    }
}

void
FFTWindow::pause()
{
   paused = !paused;
}

