// VU meter widget demonstration program
// my first ever widget using Qt :-)

#include <qpushbt.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qfont.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qframe.h>
#include <qimage.h>
#include <string.h>
#include <kapp.h>

#include "qvumeter.h"

class MyWidget : public QWidget
{
public:
    MyWidget( QWidget *parent=0, const char *name=0 );
protected:
    void resizeEvent( QResizeEvent * );
private:
    QPushButton *quit;
    QScrollBar  *sBar;
    QLCDNumber  *lcd;
    Qvumeter *ledvu[4];
};

MyWidget::MyWidget( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
    setMinimumSize( 450, 200 );

    quit = new QPushButton( "Quit", this, "quit" );
    quit->setGeometry( 10, 10, 75, 30 );

    connect( quit, SIGNAL(clicked()), qApp, SLOT(quit()) );

    lcd  = new QLCDNumber( 2, this, "lcd" );
    lcd->move( 10, quit->y() + quit->height() + 10 );

    sBar = new QScrollBar( 0, 99,                       // range
                           1, 10,                       // line/page steps
                           0,                           // inital value
                           QScrollBar::Horizontal,      // orientation
                           this, "scrollbar" );

    connect( sBar, SIGNAL(valueChanged(int)), lcd, SLOT(display(int)) );

	// setup led VU-meter widgets and show them
    
	ledvu[0] = new Qvumeter(
			   33,			// number of steps (leds)
			   0, 99,		// range min, range max
			   // "lin",		// scale
			   0,			// damping (between 0 and 100)
			   23,28,31,		// led color changes
		           'V',			// orientation, LED set
			   this );

	ledvu[0]->move( 150, 30 );  // put them side by side

	connect( sBar, SIGNAL(valueChanged(int)), ledvu[0],
		SLOT(setValue(int)));

	ledvu[1] = new Qvumeter(
			   33,			// number of steps (leds)
			   0, 99,		// range min, range max
			   // "lin",		// scale
			   0,			// damping (between 0 and 100)
			   17,17,18,		// led color changes
		           'V',			// orientation, LED set
			   this );

	ledvu[1]->move( 170, 30 );  // put them side by side

	connect( sBar, SIGNAL(valueChanged(int)), ledvu[1],
		SLOT(setValue(int)));

	ledvu[2] = new Qvumeter(
			   20,			// number of steps (leds)
			   0, 99,		// range min, range max
			   // "lin",		// scale
			   5,			// damping (between 0 and 100)
			   0,0,0,		// led color changes
		           'h', this );

	ledvu[2]->move( 240, 50 );  // put them side by side

	connect( sBar, SIGNAL(valueChanged(int)), ledvu[2],
		SLOT(setValue(int)));

	ledvu[3] = new Qvumeter(
			   11,			// number of steps (leds)
			   0, 99,		// range min, range max
			   // "lin",		// scale
			   10,			// damping (between 0 and 100)
			   4,15,26,		// led color changes
		           'H', this );

	ledvu[3]->move( 240, 150 );  // put them side by side

	connect( sBar, SIGNAL(valueChanged(int)), ledvu[3],
		SLOT(setValue(int)));

}

void MyWidget::resizeEvent( QResizeEvent * )
{
    sBar->setGeometry( 10, height() - 10 - 16, width() - 20, 16 );
    lcd->resize( 100, sBar->y() - lcd->y() - 5 );
}

int main( int argc, char **argv )
{
    KApplication a( argc, argv );

    MyWidget w;
    w.setGeometry( 100, 100, 450, 200 );
    a.setMainWidget( &w );
    w.show();
    return a.exec();
}
