// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with the package.



#ifdef HAVE_CONFIG_H
#  include "config.h"
#else
#  define VERSION ""
#endif
#include "krot.h"
#include "frontend/mainwindow.h"
#include "arnirot/arnirot.h"

#include <kapp.h>

#include <qstring.h>

#include <iostream>

extern "C" {
#  ifdef HAVE_SIGNAL_H
#    include <signal.h>
#  endif
#  ifdef HAVE_UNISTD_H
#    include <unistd.h>
#  endif
#  include <string.h>
};


/**
 * some global parameter
 */
extern const int KROT_DIALOGMARGIN = 10; // margins around list displays

// kdebug constants
const unsigned short KDEBUG_KROT_ASSERT          = 4201;
const unsigned short KDEBUG_KROT_FILE            = 4202;
const unsigned short KDEBUG_KROT_GENERAL         = 4203;
const unsigned short KDEBUG_KROT_GUI             = 4204;
const unsigned short KDEBUG_KROT_LAUNCH          = 4220;
const unsigned short KDEBUG_KROT_LAUNCH_OFTEN    = 4221;
const unsigned short KDEBUG_KROT_DEBUG           = 4230;
const unsigned short KDEBUG_KROT_DEBUG_VERBOSE   = 4231;


// KConfig sections
const char * const KROT_CONFIG_CALCULATION  = "Calculation";
const char * const KROT_CONFIG_GENERAL      = "";
const char * const KROT_CONFIG_IMPORT       = "Import";


// keep the actual version in the object file, so ident / what can determine it.
static const char vcid[] = "@(" "#)" " $" "I" "d: " "KRot-" VERSION " $";


QString aboutKRot( "KRot\nVersion " VERSION "\n\n"
		   "Copyright (C) 1997-1999\n"
		   "Jochen Kpper <jochen@uni-duesseldorf.de>\n" );



int main( int argc, char **argv )
{
    // If our name is "arnirot", we work exactly like arnirot !
    // This means we ignore all options and read/write input/output
    // from/to stdin/stdout.
    string name = string( argv[ 0 ] ).substr( string( argv[ 0 ] ).find_last_of( '/' ) + 1 );
    if( name == "arnirot" ) {
	//arni_();
	return 0;
    } else {
	// Well, we can work in a regular fashion :-)
#ifdef HAVE_SIGNAL_H
	sigaction( SIGHUP, static_cast< struct sigaction *>( 0 ),
		   static_cast< struct sigaction *>( 0 ) );
#endif
	KApplication app( argc, argv, "krot" );
	aboutKRot += i18n( "and the KRot development team." );
	aboutKRot += "\n\n";
	aboutKRot += i18n( "This program is for the assignment, simulation\n"
			   "and fit of rovibronic spectra." );
	QObject::connect( &app, SIGNAL( lastWindowClosed() ),
			  &app, SLOT( quit() ) );
#ifdef HAVE_UNISTD_H
	// parse remaining command line options 
	// ( KApplication constructor removes the options it recognizes )
	// QTextStream cout( stdout, IO_WriteOnly );
	char options[] = "+hv";
	int val;
	while( EOF != ( val = getopt( argc, argv, options ) ) )
	    switch( val ) {
	    case 'h':
		cout << endl << "KRot " VERSION "\n"
		     << "Copyright (C) 1997-1999 Jochen Kpper <jochen@uni-duesseldorf.de>\n"
		     << i18n( "                        and the KRot development team." )
		     << endl << endl
		     << i18n( "Recognized options:" ) << endl
		     << "-bg" << endl
		     << "-background       " << i18n( "Set the default background color and an application\n"
						      "                  "
						      "palette (light and dark shades are calculated)." ) << endl
		     << "-cmap             " << i18n( "On an 8-bit display, install a private color map." ) 
		     << endl
		     << "-display          " << i18n( "Set the X display (default is $DISPLAY)." ) << endl
		     << "-fn" << endl
		     << "-font <font>      " << i18n( "Select font to use." ) << endl
		     << "-fg" << endl
		     << "-foreground       " << i18n( "Set the default foreground color." ) << endl
		     << "-geometry         " << i18n( "Set the client geometry of the main widget." ) << endl
		     << "-h                " << i18n( "Display this help message." )<< endl
		     << "-name             " << i18n( "Set the application name." ) << endl
		     << "-ncols <count>    " << i18n( "Limit the number of colors allocated in the color cube\n"
						      "                  "
						      "on a 8-bit display, if the application is using the\n"
						      "                  "
						      "QApplication::ManyColor color specification.\n"
						      "                  "
						      "If count is 216 then a 6x6x6 color cube is used\n"
						      "                  "
						      "(ie. 6 levels of red, 6 of green, and 6 of blue);\n"
						      "                  "
						      "for 108, a 3x3x3, and for other values, a cube\n"
						      "                  "
						      "approximately proportional to a 2x3x1 cube is used." )
		     << endl
		     << "-title            " << i18n( "Set the application title (caption)." ) << endl
		     << "-v                " << i18n( "Display version information and exit." ) << endl
		     << "-visual TrueColor " << i18n( "Force the application to use a TrueColor visual\n"
						      "                  "
						      "on an 8-bit display." ) << endl
		     << endl;
		return 0;
		break;
	    case 'v':
		cout << endl << aboutKRot << endl << endl;
		return 0;
		break;
	    default:
		return 1;
		break;
	    }
#endif
	MainWindow window( "MainWindow" );
	window.show();
	// this comparison is to keep vcid in the object file !
	return app.exec() + ( ! strcmp( vcid, argv[0] ) );
    }
}



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
