/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> PRT_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"

#define QN_NO		6



short PrntTrs( char *out_flnm ) ;
void PrntEigErg( long j_qn, short *ka_ary, short *kc_ary, double *erg_ary ) ;
void PrntEigVec( long j_qn, short *ka_ary, short *kc_ary, double *vec_mat ) ;

short CAlloc1Dim( char **ptpt, long sz ) ;
void CFree1Dim( char **ptpt ) ;
short SAlloc1Dim( short **ptpt, long sz ) ;
void SFree1Dim( short **ptpt ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;
void PrntPrm( void ) ;






/*PRINT TRANSITION QN'S, INTENSITIES, OBSERVED AND CALCULATED FREQUENCIES IN ASCII FORM*/
short PrntTrs( char *out_flnm )
   {
   char ascii_flnm[ FLNM_LEN ], fib_flnm[ FLNM_LEN ], q_flnm[ FLNM_LEN ] ;
   long cnt, cts ;
   int fib_fd, q_fd ;
   FILE *ascii_fp ;
   short *ts1_ary, *ts2_ary ;
   long *tl1_ary, *tl2_ary ;
   float *tf_ary ;
   double *td1_ary, *td2_ary ;
   char *tc_ary, tc_ele ;
   double sum_int ;



/*CREATE ASCII FILENAME TO CONTAIN BT'S, QN'S, SIM ERG'S, EXP ERG'S AND SIM INT'S*/
   strcpy( ascii_flnm, out_flnm ) ;

/*GIVE OLD JB FORMAT A LINES.DAT FORMAT WITH .DAT EXTENSION*/
   if( JB_stat )
      strcat( ascii_flnm, ".dat" ) ;
   else
      strcat( ascii_flnm, ".a" ) ;

/*MAKE FILENAME TO READ SIM ENERGIES, EXP ENERGIES, SIM INTENSITY AND BAND TYPES*/
   strcpy( fib_flnm, out_flnm ) ;
   strcat( fib_flnm, ".f" ) ;

/*MAKE CREATE FILENAME TO READ QUANTUM #'S*/
   strcpy( q_flnm, out_flnm ) ;
   strcat( q_flnm, ".q" ) ;



/*CREATE ASCII FILE TO CONTAIN BT'S, QN'S, SIM ERG'S, EXP ERG'S AND SIM INT'S*/
   if( (ascii_fp = fopen( ascii_flnm, "w" )) == NULL )
      {
      fprintf( Log_fp, "\nPRNTTRS -> CAN'T CREATE '%s' FILE !\n", ascii_flnm ) ;
      return( E_RT_UNK ) ;
      }

/*OPEN SIM AND EXP FREQUENCY, INTENSITY AND BAND TYPE FILE FOR READING ONLY*/
   if( (fib_fd = open( fib_flnm, O_RDONLY | O_BINARY )) == -1 )
      {
      fprintf( Log_fp, "\nPRNTTRS -> CAN'T OPEN '%s' FILE !\n", fib_flnm ) ;
      return( E_RT_UNK ) ;
      }

/*OPEN QUANTUM # FILE FOR READING ONLY*/
   if( (q_fd = open( q_flnm, O_RDONLY | O_BINARY )) == -1 )
      {
      fprintf( Log_fp, "\nPRNTTRS -> CAN'T OPEN '%s' FILE !\n", q_flnm ) ;
      return( E_RT_UNK ) ;
      }



/*ALLOCATE SPACE FOR ALL BAND TYPE LABELS - FORMAT OF NEW AND OLD JB IS THE SAME*/
   tc_ary = NULL ;
   if( CAlloc1Dim( &tc_ary, Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nPRNTTRS (TC_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }


/*ALLOCATE SPACE FOR ALL QUANTUM #'S FOR ALL SIMULATED LINES - FORMAT OF NEW AND OLD JB IS THE SAME*/
   ts1_ary = NULL ;
   if( SAlloc1Dim( &ts1_ary, QN_NO * Trs_nolvs ) == -1 )
      {
      fprintf( Log_fp, "\nPRNTTRS (TS1_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }




/*READ IN NEW STYLE JB FORMAT OF FREQUENCIES (DOUBLE) AND INTENITIES (FLOAT)*/
   if( !JB_stat )
      {

   /*ALLOCATE SPACE FOR ALL BAND SIMULATED TRANSITION ENERGIES*/
      td1_ary = NULL ;
      if( DAlloc1Dim( &td1_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TD1_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }


   /*ALLOCATE SPACE FOR ALL BAND EXPERIMENTAL ENERGIES*/
      td2_ary = NULL ;
      if( DAlloc1Dim( &td2_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TD2_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }


   /*ALLOCATE SPACE FOR ALL SIMULATED TRANSITION INTENSITIES*/
      tf_ary = NULL ;
      if( FAlloc1Dim( &tf_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TF_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }



   /*READ ORDERED SIMULATED ENERGIES*/
      read( fib_fd, (char *)td1_ary, Trs_nolvs * sizeof( double ) ) ;

   /*READ ORDERED EXPERIMENTAL ENERGIES*/
      read( fib_fd, (char *)td2_ary, Trs_nolvs * sizeof( double ) ) ;

   /*READ ORDERED SIMULATED INTENSITIES*/
      read( fib_fd, (char *)tf_ary, Trs_nolvs * sizeof( float ) ) ;

   /*READ ORDERED BAND TYPES*/
      read( fib_fd, (char *)tc_ary, Trs_nolvs * sizeof( char ) ) ;

   /*READ ORDERED SIMULATED QUANTUM #'S*/
      read( q_fd, (char *)ts1_ary, QN_NO * Trs_nolvs * sizeof( short ) ) ;


   /*LOOP THROUGH AND WRITE ALL TRANSITIONS OUT TO ASCII FILE*/
      for( sum_int = 0.0, cnt = cts = 0; cnt < Trs_nolvs; cnt++, cts += QN_NO )
         {
         fprintf( ascii_fp, "%c%3hd%3hd%3hd%4hd%3hd%3hd %7.3f %11.4f %11.4f", tc_ary[ cnt ], ts1_ary[ cts ], ts1_ary[ cts + 1 ], ts1_ary[ cts + 2 ], ts1_ary[ cts + 3 ], ts1_ary[ cts + 4 ], ts1_ary[ cts + 5 ], tf_ary[ cnt ], td2_ary[ cnt ], td1_ary[ cnt ] ) ;

      /*OBSERVED LINE*/
         if( td2_ary[ cnt ] )
            fprintf( ascii_fp, "%12.4f\n", td2_ary[ cnt ] - td1_ary[ cnt ] ) ;

         else
            fprintf( ascii_fp, "\n" ) ;

      /*SUM INTENSITIES*/
         sum_int += (double)tf_ary[ cnt ] ;
         }


   /*FREE SPACE*/
      DFree1Dim( &td1_ary ) ;
      DFree1Dim( &td2_ary ) ;
      FFree1Dim( &tf_ary ) ;
      }




/*READ IN OLD STYLE FORMAT OF JB FREQUENCIES (DOUBLE) AND INTENITIES (FLOAT)*/
   else
      {

   /*ALLOCATE SPACE FOR ALL BAND SIMULATED TRANSITION ENERGIES*/
      tl1_ary = NULL ;
      if( LAlloc1Dim( &tl1_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TL1_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }


   /*ALLOCATE SPACE FOR ALL BAND EXPERIMENTAL ENERGIES*/
      tl2_ary = NULL ;
      if( LAlloc1Dim( &tl2_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TL2_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }


   /*ALLOCATE SPACE FOR ALL SIMULATED TRANSITION INTENSITIES*/
      ts2_ary = NULL ;
      if( SAlloc1Dim( &ts2_ary, Trs_nolvs ) == -1 )
         {
         fprintf( Log_fp, "\nPRNTTRS (TS2_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }



   /*READ ORDERED SIMULATED ENERGIES*/
      read( fib_fd, (char *)tl1_ary, Trs_nolvs * sizeof( long ) ) ;

   /*READ ORDERED EXPERIMENTAL ENERGIES*/
      read( fib_fd, (char *)tl2_ary, Trs_nolvs * sizeof( long ) ) ;

   /*READ ORDERED SIMULATED INTENSITIES*/
      read( fib_fd, (char *)ts2_ary, Trs_nolvs * sizeof( short ) ) ;

   /*READ ORDERED BAND TYPES*/
      read( fib_fd, (char *)tc_ary, Trs_nolvs * sizeof( char ) ) ;

   /*READ ORDERED SIMULATED QUANTUM #'S*/
      read( q_fd, (char *)ts1_ary, QN_NO * Trs_nolvs * sizeof( short ) ) ;



   /*LOOP THROUGH AND WRITE ALL TRANSITIONS OUT TO ASCII FILE*/
      for( sum_int = 0.0, cnt = cts = 0; cnt < Trs_nolvs; cnt++, cts += QN_NO )
         {

      /*BRANCH TYPE*/
         if( ts1_ary[ cts + 0 ] > ts1_ary[ cts + 3 ] )
            tc_ele = 'R' ;
         else if( ts1_ary[ cts + 0 ] < ts1_ary[ cts + 3 ] )
            tc_ele = 'P' ;
         else
            tc_ele = 'Q' ;

      /*OUTPUT IS IN LINES.DAT FORMAT "H O R  1   5  5  0  4  4  1   1.460      .000     398759.758"*/
         fprintf( ascii_fp, "%c%2c%2c%3hd%4hd%3hd%3hd%4hd%3hd%3hd %7.3f %11.4f %11.4f", tc_ary[ cnt ], ((ts1_ary[ cts + 4 ] + ts1_ary[ cts + 5 ])%2) ? 'O': 'E', tc_ele, ts1_ary[ cts + 1 ] - ts1_ary[ cts + 4 ], ts1_ary[ cts ], ts1_ary[ cts + 1 ], ts1_ary[ cts + 2 ], ts1_ary[ cts + 3 ], ts1_ary[ cts + 4 ], ts1_ary[ cts + 5 ], (double)(ts2_ary[ cnt ]) / JB_ITNMULT_2_SHORT * JB_itnfactor, (double)(tl2_ary[ cnt ]) / JB_ERGMULT_2_LONG * JB_ergfactor, (double)(tl1_ary[ cnt ]) / JB_ERGMULT_2_LONG * JB_ergfactor ) ;


      /*OBSERVED LINE*/
         if( tl2_ary[ cnt ] )
            fprintf( ascii_fp, "%12.4f\n", (double)(tl2_ary[ cnt ] - tl1_ary[ cnt ]) / JB_ERGMULT_2_LONG * JB_ergfactor ) ;

         else
            fprintf( ascii_fp, "\n" ) ;

      /*SUM INTENSITIES*/
         sum_int += (double)(ts2_ary[ cnt ]) / JB_ITNMULT_2_SHORT * JB_itnfactor ;
         }


   /*FREE SPACE*/
      LFree1Dim( &tl1_ary ) ;
      LFree1Dim( &tl2_ary ) ;
      SFree1Dim( &ts2_ary ) ;
      }



/*
/PRINT OUT SUM OF INTENSITIES/
   fprintf( ascii_fp, "SUM OF INTENSITIES = %lf\n", sum_int ) ;
*/


/*CLOSE BINARY FREQUENCY,INTENSITY,BAND TYPE AND QUANTUM # FILES*/
   close( fib_fd ) ;
   close( q_fd ) ;

/*CLOSE ASCII FILE*/
   fclose( ascii_fp ) ;


/*FREE SPACE*/
   CFree1Dim( &tc_ary ) ;
   SFree1Dim( &ts1_ary ) ;


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*PRINT EIGEN ENERGIES FOR SELECTED LEVELS*/
void PrntEigErg( long j_qn, short *ka_ary, short *kc_ary, double *erg_ary )
   {
   FILE *ascii_fp ;
   char ascii_flnm[ FLNM_LEN ] ;
   long cnt, bs_sz ;


/*CALCULATE DIMENSION OF MATRIX*/
   bs_sz = 2 * j_qn + 1 ;


/*PRINT HEADER STUFF*/
   fprintf( Log_fp, "\n\n----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "|Ka Kc|     ENERGY                   J = %2ld\n", j_qn ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;

/*PRINT EIGEN ENERGIES*/
   for( cnt = 0; cnt < bs_sz; cnt++ )
      fprintf( Log_fp, "|%2hd%3hd|%12.5f\n", *(ka_ary + cnt), *(kc_ary + cnt), *(erg_ary + cnt) ) ;




/*CREATE ASCII FILE TO CONTAIN EIGEN VALUES*/
   strcpy( ascii_flnm, Out_flnm ) ;
   strcat( ascii_flnm, ".e" ) ;

/*REMOVE OLD FILE FOR J = 0*/
   if( !j_qn )
      unlink( ascii_flnm ) ;

/*APPEND TO ASCII FILE CONTAINING EIGEN VALUES*/
   if( (ascii_fp = fopen( ascii_flnm, "a" )) == NULL )
      {
      fprintf( Log_fp, "\nPRNTTRS -> CAN'T APPEND TO '%s' FILE !\n", ascii_flnm ) ;
      return ;
      }

/*WRITE OUT QUANTUM NUMBERS AND ENERGIES*/
   for( cnt = 0; cnt < bs_sz; cnt++ )
      fprintf( ascii_fp, "%-4hd%-4hd%-4hd%-.4f\n", j_qn, *(ka_ary + cnt), *(kc_ary + cnt), *(erg_ary + cnt) ) ;

/*CLOSE FILE*/
   fclose( ascii_fp ) ;
   }









/*PRINT EIGEN ENERGIES FOR SELECTED LEVELS*/
void PrntEigVec( long j_qn, short *ka_ary, short *kc_ary, double *vec_mat )
   {
   long set, col, row, bs_sz ;


/*CALCULATE DIMENSION OF MATRIX*/
   bs_sz = 2 * j_qn + 1 ;



/*PRINT COEFFICIENTS OF SYMMETRIC TOP BASIS SET FUNTIONS -> EIGEN VECTORS*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;

/*LOOP THROUGH ALL SETS OF 8 VECTORS COLUMNS PER SET*/
   for( set = 0; 8 * set < bs_sz; set++ )
      {

   /*PRINT HEADER INFO*/
      fprintf( Log_fp, "|Ka Kc>  " ) ;


   /*PRINT EIGEN FUNCTION LABELS*/
      for( row = 8 * set; row < 8 * (set + 1) && row < bs_sz; row++ )
         fprintf( Log_fp, "%hd%-8hd", ka_ary[ row ], kc_ary[ row ] ) ;
      fprintf( Log_fp, "\n----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;



   /*PRINT BASIS SET LABELS AND EIGEN VECTORS*/
      for( row = 0; row < bs_sz; row++ )
         {

      /*PRINT BASIS SET LABELS*/
         fprintf( Log_fp, "|K%4ld|", row - j_qn ) ;

      /*PRINT VECTOR COEFFICIENTS*/
         for( col = 8 * set; col < 8 * (set + 1) && col < bs_sz; col++ )
            fprintf( Log_fp, "%9.5f", *(vec_mat + col * bs_sz + row) ) ;
         fprintf( Log_fp, "\n" ) ;
         }

      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n\n" ) ;
      }
   }









/*FORMATED PRINT OF CONSTANTS -> INFORMATION LOGGED TO FILE*/
void PrntPrm()
   {
   long no_par, col ;

/*LOOP THROUGH ALL GROUND AND EXCITED STATE PARAMETERS*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "GROUND  STATE :\n" ) ;
   for( no_par = 0; no_par < ST_NOPAR; )
      {
      for( col = 0; col < 3 && no_par < ST_NOPAR; col++, no_par++ )
         {
         if( no_par < DK || no_par > dJ )
            {
            if( col < 2 )
               fprintf( Log_fp, "%s = %-23.6f", Rc_str[ no_par ], Rc[ GND ][ no_par ] ) ;
            else
               fprintf( Log_fp, "%s = %.6f", Rc_str[ no_par ], Rc[ GND ][ no_par ] ) ;
            }
         else
            {
            if( col < 2 )
               fprintf( Log_fp, "%s = %-23.4e", Rc_str[ no_par ], Rc[ GND ][ no_par ] ) ;
            else
               fprintf( Log_fp, "%s = %.4e", Rc_str[ no_par ], Rc[ GND ][ no_par ] ) ;
            }
         }
      fprintf( Log_fp, "\n" ) ;
      }

   fprintf( Log_fp, "\nEXCITED STATE :\n" ) ;
   for( no_par = 0; no_par < ST_NOPAR; )
      {
      for( col = 0; col < 3 && no_par < ST_NOPAR; col++, no_par++ )
         {
         if( no_par < DK || no_par > dJ )
            {
            if( col < 2 )
               fprintf( Log_fp, "%s = %-23.6f", Rc_str[ no_par ], Rc[ EXE ][ no_par ] ) ;
            else
               fprintf( Log_fp, "%s = %.6f", Rc_str[ no_par ], Rc[ EXE ][ no_par ] ) ;
            }
         else
            {
            if( col < 2 )
               fprintf( Log_fp, "%s = %-23.4e", Rc_str[ no_par ], Rc[ EXE ][ no_par ] ) ;
            else
               fprintf( Log_fp, "%s = %.4e", Rc_str[ no_par ], Rc[ EXE ][ no_par ] ) ;
            }
         }
      fprintf( Log_fp, "\n" ) ;
      }

   fprintf( Log_fp, "\n%s = %.6f\n", Rc_str[ no_par ], Rc[ EXE ][ no_par ] ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   }




/*
         fprintf( ascii_fp, "%c%3hd%3hd%3hd%4hd%3hd%3hd%8.3f%12.4lf%12.4lf", tc_ary[ cnt ], ts1_ary[ cts ], ts1_ary[ cts + 1 ], ts1_ary[ cts + 2 ], ts1_ary[ cts + 3 ], ts1_ary[ cts + 4 ], ts1_ary[ cts + 5 ], (float)(ts2_ary[ cnt ] / JB_ITNMULT_2_SHORT * JB_itnfactor), (double)(tl2_ary[ cnt ] / JB_ERGMULT_2_LONG * JB_ergfactor), (double)(tl1_ary[ cnt ] / JB_ERGMULT_2_LONG * JB_ergfactor) ) ;
*/

