/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> DHR_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"



short *Ka_ary[ ST_NO ], *Kc_ary[ ST_NO ] ;
double *h2v_mat ;
double *px_vec, *pxpz_vec ;

extern int ev_fd, ee_fd, qn_fd, dv_fd ;
extern double *dvs_mat, *pp2pm2_vec, *od_vec ;

short RHamSoln( int st ) ;
short RHamInit( int st ) ;
void PrntEigErg( long j_qn, short *ka_ary, short *kc_ary, double *erg_ary ) ;
void PrntEigVec( long j_qn, short *ka_ary, short *kc_ary, double *vec_mat ) ;
short DerBackRotation( int st, double *dvp_mat, double dc_mat[ 3 ][ 3 ], double dvr_mat[ 3 ][ 3 ] ) ;
int tred2_( long *nm, long *n, double *a, double *d__, double *e, double *z ) ;
int imtql2_( long *nm, long *n, double *d__, double *e, double *z__, long *ierr ) ;

short SAlloc1Dim( short **ptpt, long sz ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;








/*GENERATE HAMILTONIAN MATRIX*/
short RHamSoln( int st )
   {
   long ierr ;
   long cnt, cts, row, col, row_ofs, dv_ct ;
   long j_qn, k_qn, jj1_val ;
   long kac_ct, erg_ofs, bs_sz, no_dvs ;
   double ak_hp, aj_hp, akpkm_hp ;
   double *v_pt, erg ;
   double dv_val, dv0_val, dv12_val, dv3_val ;
   double dv5_val, dv7_val, dv10_val, dv13_val, dv14_val ;
   double dvr_mat[ 3 ][ 3 ] ;


/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL MATRICIES AND VECTORS*/
   if( RHamInit( (int)st ) == -1 )
      return( -1 ) ;


/*MICROWAVE - FOR EXCITED STATE MAKE SAME AS GND STATE ARRAYS*/
   if( st && !Rc[ EXE ][ ORI ] )
      {

   /*COPY EIGEN ENERGIES AND QUANTUM #'S*/
      for( cnt = 0; cnt < J_max * (J_max + 2) + 1 ; cnt++ )        
         {
         *(*(Erg_vec + 1) + cnt) = *(*(Erg_vec + 0) + cnt) ;
         Ka_ary[ 1 ][ cnt ] = Ka_ary[ 0 ][ cnt ] ;
         Kc_ary[ 1 ][ cnt ] = Kc_ary[ 0 ][ cnt ] ;
         }

   /*RETURN SUCCESS*/
      return( 1 ) ;
      }



/*DEFINE KAPPA -> PROLATE OR NEAR PROLATE TOP*/
   if( Rc[ st ][ A ] != Rc[ st ][ C ] )
      Kap[ st ] = (2 * Rc[ st ][ B ] - Rc[ st ][ A ] - Rc[ st ][ C ]) /
           (Rc[ st ][ A ] - Rc[ st ][ C ]) ;

/*PRINT KAPPA VALUE*/
   fprintf( Log_fp, "%s STATE KAPPA = %f (REAL)\n\n", St_str[ st ], Kap[ st ] ) ;



/*DEFINE SYMMETRIC ROTOR PARAMETERS -> REP IR*/
   aj_hp = 0.5 * (Rc[ st ][ B ] + Rc[ st ][ C ]) ;
   ak_hp = Rc[ st ][ A ] - 0.5 * (Rc[ st ][ B ] + Rc[ st ][ C ]) ;

/*DEFINE ASYMMETRIC ROTOR PARAMETER*/
   akpkm_hp = 0.5 * (Rc[ st ][ B ] - Rc[ st ][ C ]) ;

/*DEREFERENCE TOTAL # OF DERVATIVES FOR STATE*/
   no_dvs = St_nodv[ st ] ;



/*CALCULATE MATRIX ELEMENTS AND DIAGONALIZE FOR EVERY J BETWEEN 0 AND J_MAX*/
   for( kac_ct = 0, bs_sz = 1, erg_ofs = 0, j_qn = 0; j_qn <= J_max; bs_sz = 2 * ++j_qn + 1 )
      { 

   /*DEFINE J * (J + 1) VALUE*/
      jj1_val = j_qn * (j_qn + 1) ;



   /*INITIALIZE MATRIX*/
      for( row = 0; row < bs_sz; row++ )        
         for( col = 0; col < bs_sz; col++ )
            *(h2v_mat + row * bs_sz + col) = 0.0 ;



   /*GENERATE DIAGONAL ELEMENTS IN ASYMMETRIC ROTOR HAMILTONIAN MATRIX*/
      for( k_qn = 0, row = 0; row <= j_qn; row++, k_qn++ )
         *(h2v_mat + (j_qn + row) * bs_sz + j_qn + row) =
         *(h2v_mat + (j_qn - row) * bs_sz + j_qn - row) = 
               aj_hp * jj1_val +
               ak_hp * k_qn * k_qn ;


   /*GENERATE OFF-DIAGONAL ELEMENTS IN ASYMMETRIC ROTOR HAMILTONIAN MATRIX*/
      for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
         *(h2v_mat + row * bs_sz + row + 2) =
         *(h2v_mat + (row + 2) * bs_sz + row) =
               akpkm_hp * (pp2pm2_vec[ row ] = 0.5 * sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                     (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;


   /*GENERATE <PX> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PX ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row + 1) =
            (*(h2v_mat + (row + 1) * bs_sz + row) += Rc[ st ][ PX ] *
                  (px_vec[ row ] = 0.5 * sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) ))) ;


   /*GENERATE <PZ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PZ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row) +=
                  Rc[ st ][ PZ ] * k_qn ;


   /*GENERATE <PXPZ + PZPX> PERTURBATION OR PRODUCT TENSOR MATRIX ELEMENTS*/
      if( Rc_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PXPZ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 1; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row + 1) =
            (*(h2v_mat + (row + 1) * bs_sz + row) +=
                  Rc[ st ][ PXPZ ] * (pxpz_vec[ row ] = 0.5 * (2.0 * k_qn + 1) *
                  sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) ))) ;



   /*GENERATE <DK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DK ] * k_qn * k_qn * k_qn * k_qn ;

   /*GENERATE <DJK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DJK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DJK ] * jj1_val * k_qn * k_qn ;

   /*GENERATE <DJ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ DJ ] )
         for( row = 0; row < bs_sz; row++ )
            *(h2v_mat + row * bs_sz + row) +=
                  -Rc[ st ][ DJ ] * jj1_val * jj1_val ;

   /*GENERATE <dK> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX - A REDUCTION*/
      if( Rc_stat[ st ][ dK ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row + 2) =
            (*(h2v_mat + (row + 2) * bs_sz + row) +=
                  -Rc[ st ][ dK ] * 0.5 * (k_qn * k_qn + (k_qn + 2) * (k_qn + 2)) *
                        sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                        (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;

   /*GENERATE <dJ> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX - A REDUCTION*/
      if( Rc_stat[ st ][ dJ ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz - 2; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row + 2) =
            (*(h2v_mat + (row + 2) * bs_sz + row) +=
                  -Rc[ st ][ dJ ] * 1.0 * jj1_val *
                        sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                      (jj1_val - (k_qn + 1) * (k_qn + 2)) )) ;




   /*GENERATE <PZ**3> PERTURBATION MATRIX ELEMENTS OF HAMILTONIAN MATRIX*/
      if( Rc_stat[ st ][ PZ3 ] )
         for( k_qn = -j_qn, row = 0; row < bs_sz; row++, k_qn++ )
            *(h2v_mat + row * bs_sz + row) +=
                  Rc[ st ][ PZ3 ] * k_qn * k_qn * k_qn ;




   /*PRINT HAMILTONIAN MATRIX*/
      if( Err == 1 )
         {
         printf( "\nHAM MATRIX J = %ld\n", j_qn ) ;
         for( row = 0; row < bs_sz; row++ )
            {
            for( col = 0; col < bs_sz; col++ )
               printf( "%15.5f", *(h2v_mat + row * bs_sz + col) ) ;
            printf( "\n" ) ;
            }
         printf( "\n" ) ;
         }





   /*TRI DIAGONALIZATION PROCEDURE FOR SYMMETRIC REAL MATRICIES*/
      tred2_( &bs_sz, &bs_sz, h2v_mat, *(Erg_vec + st) + erg_ofs, od_vec, h2v_mat ) ;
/*
int tred2_( long *nm, long *n, double *a, double *d__, double *e, double *z ) ;
      tred2( h2v_mat, bs_sz, *(Erg_vec + st) + erg_ofs, od_vec ) ;
*/

   /*DIAGONALIZATION PROCEDURE FOR TRIDIAGONAL MATRICIES -> RETURNS EIGEN VALUES AND VECTORS*/
      imtql2_( &bs_sz, &bs_sz, *(Erg_vec + st) + erg_ofs, od_vec, h2v_mat, &ierr ) ;
/*
      tqli( *(Erg_vec + st) + erg_ofs, od_vec, bs_sz, h2v_mat ) ;
      imtql2_( &bs_sz, &bs_sz, *(Erg_vec + st) + erg_ofs, od_vec, h2v_mat, &ierr ) ;
*/




   /*WRITE EIGENVECTORS OUT TO FILE -> VECTOR I IS IN ROW I*/
      write( ev_fd, (char *)h2v_mat, bs_sz * bs_sz * sizeof( double ) ) ;



   /*CALCULATE DERIVATIVES FOR LEAST SQUARES PHASE OR FOR DERIVATIVE APPROXIMATION*/
      for( dv_ct = 3, row_ofs = 0, row = 0; row < bs_sz; row_ofs = ++row * no_dvs, dv_ct = 3 )
         {

      /*REASSIGN ADDRESS TO TEMPORARY POINTER*/
         v_pt = h2v_mat + row * bs_sz ;


      /*CALCULATE DERIVATIVES (DE/DPZ) AND (DE/DPZ**2) -> LOOP THROUGH EIGENVECTOR*/
         for( dv0_val = dv5_val = dv10_val = dv13_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz; col++, k_qn++ )
            {
            dv_val = *(v_pt + col) * *(v_pt + col) * k_qn ;
            dv0_val += dv_val * k_qn ;
            dv5_val += dv_val ;
            dv10_val += dv_val * k_qn * k_qn ;
            dv13_val += dv_val * k_qn * k_qn * k_qn ;
            }

      /*CALCULATE DER (DE/DX**2) AND (DE/DY**2) -> LOOP THROUGH EIGENVECTOR*/
         for( dv12_val = 0.0, col = 0; col < bs_sz - 2; col++ )
            dv12_val += *(v_pt + col) * *(v_pt + col + 2) * pp2pm2_vec[ col ] ;




      /*ASSIGN PZ**2 DERIVATIVE*/
         *(dvs_mat + row_ofs + A) = dv0_val ;

      /*ASSIGN B AND C DERIVATIVES -> DV12_VAL FACTOR 2 FROM SYMMETRIX MATRIX*/
         *(dvs_mat + row_ofs + B) = 0.5 * (jj1_val - dv0_val) + dv12_val ;
         *(dvs_mat + row_ofs + C) = 0.5 * (jj1_val - dv0_val) - dv12_val ;



      /*CALCULATE AND ASSIGN <PX> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PX ] )
            {

         /*CALCULATE DER (DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dv3_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv3_val += *(v_pt + col) * *(v_pt + col + 1) * px_vec[ col ] ;

         /*ASSIGN <PX> PERTURBATION DERIVATIVE -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv3_val ;
            }



      /*ASSIGN PZ DERIVATIVE*/
         if( Rc_stat[ st ][ PZ ] )
            *(dvs_mat + row_ofs + dv_ct++) = dv5_val ;



      /*CALCULATE AND ASSIGN <PXPZ + PZPX> PERTURBATION DERIVATIVE*/
         if( Rc_stat[ st ][ PXPZ ] )
            {

         /*CALCULATE DER (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dv7_val = 0.0, col = 0; col < bs_sz - 1; col++ )
               dv7_val += *(v_pt + col) * *(v_pt + col + 1) * pxpz_vec[ col ] ;

         /*ASSIGN <PXPZ + PZPX> PERTURBATION OR TENSOR PRODUCT DERIVATIVE -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = 2.0 * dv7_val ;
            }


      /*DETERMINE PRINCIPAL AXIS DERIVATIVES FOR ROTATION OUT OF TWO PRINCIPAL AXES - F TO g*/
         if( Tp_stat[ st ][ PXPZ ] )
            {

         /*CALCULATE DER (AB) (DE/DX*DE/DZ + DE/DZ*DE/DX) -> LOOP THROUGH EIGENVECTOR*/
            for( dvr_mat[ 0 ][ 2 ] = 0.0, col = 0; col < bs_sz - 1; col++ )
               dvr_mat[ 0 ][ 2 ] += *(v_pt + col) * *(v_pt + col + 1) * pxpz_vec[ col ] ;
            dvr_mat[ 1 ][ 0 ] = dvr_mat[ 0 ][ 1 ] = 0.0 ;
            dvr_mat[ 2 ][ 0 ] = dvr_mat[ 0 ][ 2 ] ;
            dvr_mat[ 2 ][ 1 ] = dvr_mat[ 1 ][ 2 ] = 0.0 ;

         /*ROTATE DERIVATIVE MATRIX BACK INTO PRINCIPAL AXIS FRAME*/
            DerBackRotation( st, dvs_mat + row_ofs, HamRot_mat[ st ], dvr_mat ) ;
            }



      /*ASSIGN DK DERIVATIVE*/
         if( Rc_stat[ st ][ DK ] )
            *(dvs_mat + row_ofs + dv_ct++) = -dv13_val ;

      /*ASSIGN DJK DERIVATIVE*/
         if( Rc_stat[ st ][ DJK ] )
            *(dvs_mat + row_ofs + dv_ct++) = -jj1_val * dv0_val ;

      /*ASSIGN DJ DERIVATIVE*/
         if( Rc_stat[ st ][ DJ ] )
            *(dvs_mat + row_ofs + dv_ct++) = -(double)jj1_val * jj1_val ;

      /*ASSIGN dK DERIVATIVE - COULD SAVE FROM MATRIX ELEMENT GENERATION*/
         if( Rc_stat[ st ][ dK ] )
            {

         /*LOOP THROUGH EIGENVECTOR*/
            for( dv14_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz - 2; col++, k_qn++ )
               dv14_val += *(v_pt + col) * *(v_pt + col + 2) * 
                     (k_qn * k_qn + (k_qn + 2) * (k_qn + 2)) *
                     sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                   (jj1_val - (k_qn + 1) * (k_qn + 2)) ) ;

         /*ASSIGN <dK> DISTORTION PERTURBATION -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = -1.0 * dv14_val ;
            }

      /*ASSIGN dJ DERIVATIVE - COULD SAVE FROM MATRIX ELEMENT GENERATION*/
         if( Rc_stat[ st ][ dJ ] )
            {

         /*LOOP THROUGH EIGENVECTOR*/
            for( dv14_val = 0.0, k_qn = -j_qn, col = 0; col < bs_sz - 2; col++, k_qn++ )
               dv14_val += *(v_pt + col) * *(v_pt + col + 2) *
                     jj1_val *
                     sqrt( (double)(jj1_val - k_qn * (k_qn + 1)) *
                                   (jj1_val - (k_qn + 1) * (k_qn + 2)) ) ;

         /*ASSIGN <dJ> DISTORTION PERTURBATION -> 2 FROM SYMMETRIC MATRIX*/
            *(dvs_mat + row_ofs + dv_ct++) = -2.0 * dv14_val ;
            }



      /*ASSIGN PZ**3 DERIVATIVE*/
         if( Rc_stat[ st ][ PZ3 ] )
            *(dvs_mat + row_ofs + dv_ct++) = dv10_val ;




      /*ERROR ANALYSIS*/
         if( Err == 1 )
            {

         /*PRINT DERIVATIVES FOR A, B, AND C*/
            printf( "\nJ> %ld R> %ld ", j_qn, row ) ;
            printf( "PZ**2> %f   ", *(dvs_mat + row_ofs + A) ) ;
            printf( "PX**2> %f   PY**2> %f   ", *(dvs_mat + row_ofs + B), *(dvs_mat + row_ofs + C) ) ;

         /*PRINT DERIVATIVES FOR REMAINING ACTIVE PARAMETERS*/
            if( Rc_stat[ st ][ PX ] )
               printf( "PX> %f   ", 2.0 * dv3_val ) ;

            if( Rc_stat[ st ][ PZ ] )
               printf( "PZ> %f   ", dv5_val ) ;

            if( Rc_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PXPZ ] )
               printf( "PXPZ> %f   ", 2.0 * dv7_val  ) ;

            if( Rc_stat[ st ][ DJ ] )
               printf( "DJ> %f   ", (double)-j_qn * (j_qn + 1) * j_qn * (j_qn + 1) ) ;

            if( Rc_stat[ st ][ PZ3 ] )
               printf( "PZ3> %f", dv10_val ) ;
            printf( "\n" ) ;


         /*CALCULATE ENERGY BASED ON DERIVATIVES*/
            erg = Tp[ st ][ A ] * *(dvs_mat + row_ofs + A) + Tp[ st ][ B ] * *(dvs_mat + row_ofs + B) +
                  Tp[ st ][ C ] * *(dvs_mat + row_ofs + C) ;

         /*LOOP THROUGH REMAINING DERIVATIVES FOR ACTIVE PARAMETERS*/
            for( cnt = 2, cts = 3; cts < no_dvs; cts++ )
               {
               while( !Rc_stat[ st ][ ++cnt ] )
                  ;
               erg += Rc[ st ][ cnt ] * *(dvs_mat + row_ofs + cts) ;
               }

         /*PRINT ENERGY FROM DIAGONALIZATION AND FROM DERIVATIVE CALCULATION*/
            printf( "HAM ERG = %f DER ERG = %f\n", *(*(Erg_vec + st) + erg_ofs + row), erg ) ;
            fflush( stdout ) ;
            }
         }



   /*MICROWAVE - WRITE DERIVATIVES OUT TO FILE*/
   /*SIGN CHANGE FOR LOWER STATE DONE IN TRANSITION CALCULATION - PHASE III*/
      write( dv_fd, (char *)dvs_mat, bs_sz * no_dvs * sizeof( double ) ) ;



   /*CALCULATE QUANTUM #'S*/
      for( k_qn = 0; k_qn < bs_sz; kac_ct++ )
         {

      /*CALCULATE KC*/
         *(*(Kc_ary + st) + kac_ct) = j_qn - (k_qn++ >> 1) ;

      /*CALCULATE KA*/
         *(*(Ka_ary + st) + kac_ct) = k_qn >> 1 ;
         }



   /*PRINT EIGEN ENERGIES FOR SELECTED LEVELS*/
      if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
         PrntEigErg( j_qn, Ka_ary[ st ] + erg_ofs, Kc_ary[ st ] + erg_ofs, Erg_vec[ st ] + erg_ofs ) ;


   /*PRINT EIGEN VECTORS FOR SELECTED LEVELS*/
      if( j_qn <= Prt_ev[ 1 ] && j_qn >= Prt_ev[ 0 ] )
         PrntEigVec( j_qn, Ka_ary[ st ] + erg_ofs, Kc_ary[ st ] + erg_ofs, h2v_mat ) ;



   /*INCREAMENT ENERGY OFFSET FACTOR*/
      erg_ofs += bs_sz ;
      }



/*CALCULATE TOTAL SIZE OF VECTORS*/
   bs_sz = (J_max * (J_max + 2) + 1) ;

/*WRITE ALL EIGENVALUES OUT TO FILE*/
   write( ee_fd, (char *)*(Erg_vec + st), bs_sz * sizeof( double ) ) ;

/*WRITE ALL QUANTUM #'S OUT TO FILE*/
   write( qn_fd, (char *)*(Ka_ary + st), bs_sz * sizeof( short ) ) ;
   write( qn_fd, (char *)*(Kc_ary + st), bs_sz * sizeof( short ) ) ;



/*FREE SPACE*/
   DFree1Dim( &h2v_mat ) ;
   DFree1Dim( &od_vec ) ;
   DFree1Dim( &dvs_mat ) ;
   DFree1Dim( &pp2pm2_vec ) ;

   if( Rc_stat[ st ][ PX ] )
      DFree1Dim( &px_vec ) ;

   if( Rc_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PXPZ ] )
      DFree1Dim( &pxpz_vec ) ;


/*CLOSE FILES*/
   close( ee_fd ) ;
   close( qn_fd ) ;
   close( ev_fd ) ;
   close( dv_fd ) ;



/*RETURN SUCCESS*/
   return( 1 ) ;
   }














/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL MATRICIES AND VECTORS*/
short RHamInit( int st )
   {
   char end_flnm[ FLNM_LEN ] ;
   short ext ;
   long cnt, sz ;



/*CALCULATE TOTAL # OF EIGEN ENERGIES*/
   sz = J_max * (J_max + 2) + 1 ;

/*ALLOCATE SPACE FOR ALL EIGENVALUES*/
   Erg_vec[ st ] = NULL ;
   if( DAlloc1Dim( &Erg_vec[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (ERG_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }

/*ZERO ENERGY MATRIX*/
   for( cnt = 0; cnt < sz; cnt++ )        
      *(*(Erg_vec + st) + cnt) = 0.0 ;




/*CALCULATE TOTAL # OF QUANTUM #'S*/
   sz = J_max * (J_max + 2) + 1 ;

/*ALLOCATE SPACE FOR ALL KA QUANTUM #'S*/
   Ka_ary[ st ] = NULL ;
   if( SAlloc1Dim( &Ka_ary[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (KA_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }

/*ALLOCATE SPACE FOR ALL KC QUANTUM #'S*/
   Kc_ary[ st ] = NULL ;
   if( SAlloc1Dim( &Kc_ary[ st ], sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (KC_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }



/*MICROWAVE - SAME AS GND STATE FILESNAMES*/
   if( !Rc[ EXE ][ ORI ] )
      ext = 0 ;
   else
      ext = st ;



/*CREATE FILENAME FOR STATE EIGENVALUES*/
   strcpy( See_flnm[ st ], "SEE-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( See_flnm[ st ], end_flnm ) ;
   strcat( See_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE QUANTUM #'S*/
   strcpy( Sqn_flnm[ st ], "SQN-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sqn_flnm[ st ], end_flnm ) ;
   strcat( Sqn_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE EIGENVECTORS*/
   strcpy( Sevr_flnm[ st ], "SEVR-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sevr_flnm[ st ], end_flnm ) ;
   strcat( Sevr_flnm[ st ], ".IAR" ) ;

/*CREATE FILENAME FOR STATE DERIVATIVES*/
   strcpy( Sdv_flnm[ st ], "SDVR-" ) ;
   sprintf( end_flnm, "%hd", ext ) ;
   strcat( Sdv_flnm[ st ], end_flnm ) ;
   strcat( Sdv_flnm[ st ], ".IAR" ) ;



/*MICROWAVE - SAME AS GND STATE FILES - RETURN SUCCESS*/
   if( st && !Rc[ EXE ][ ORI ] )
      return( 1 ) ;



/*CREATE FILE TO WRITE STATE EIGENVALUES*/
   if( (ee_fd = open( See_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT -> CAN'T OPEN '%s' FILE !\n", See_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE QUANTUM #'S*/
   if( (qn_fd = open( Sqn_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sqn_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE EIGENVECTORS*/
   if( (ev_fd = open( Sevr_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sevr_flnm[ st ] ) ;
      return( -1 ) ;
      }

/*CREATE FILE TO WRITE STATE DERIVATIVES #'S*/
   if( (dv_fd = open( Sdv_flnm[ st ], O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT -> CAN'T OPEN '%s' FILE !\n", Sdv_flnm[ st ] ) ;
      return( -1 ) ;
      }





/*CALCULATE TOTAL SIZE OF EIGEN ENERGY VECTOR*/
   sz = 2 * J_max + 1 ;

/*ALLOCATE SPACE FOR HAMILTONIAN MATRIX*/
   h2v_mat = NULL ;
   if( DAlloc1Dim( &h2v_mat, sz * sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (H2V_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR TEMPORARY VECTOR*/
   od_vec = NULL ;
   if( DAlloc1Dim( &od_vec, sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (OD_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR DERIVATIVE MATRIX*/
   dvs_mat = NULL ;
   if( DAlloc1Dim( &dvs_mat, sz * St_nodv[ st ] ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (DVS_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR <P+**2 + P-**2> MATRIX ELEMENTS*/
   pp2pm2_vec = NULL ;
   if( DAlloc1Dim( &pp2pm2_vec, sz ) == -1 )
      {
      fprintf( Log_fp, "\nRHAMINIT (PP2PM2_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR <PX> MATRIX ELEMENTS*/
   if( Rc_stat[ st ][ PX ] )
      {
      px_vec = NULL ;
      if( DAlloc1Dim( &px_vec, sz ) == -1 )
         {
         fprintf( Log_fp, "\nRHAMINIT (PX_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }
      }


/*ALLOCATE SPACE FOR <PXPZ + PZPX> MATRIX ELEMENTS*/
   if( Rc_stat[ st ][ PXPZ ] || Tp_stat[ st ][ PXPZ ] )
      {
      pxpz_vec = NULL ;
      if( DAlloc1Dim( &pxpz_vec, sz ) == -1 )
         {
         fprintf( Log_fp, "\nRHAMINIT (PXPZ_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( -1 ) ;
         }
      }



/*ERROR ANALYSIS*/
   if( Err == 1 )
      {
      sz = J_max * (4 * J_max * J_max + 12 * J_max + 11) / 3 ;
      printf( "\n%s STATE EV FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( double ) ) ;

      sz = 2 * (J_max * (J_max + 2) + 1) ;
      printf( "%s STATE KAKC FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( short ) ) ;

      sz = J_max * (J_max + 2) + 1 ;
      printf( "%s STATE ERG FILE LENGTH %ld  BYTES %ld\n", St_str[ st ], sz, sz * sizeof( double ) ) ;
      fflush( stdout ) ;
      }



/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*
/SIMULATITY TRANSFORMATION CHECK/
simtrans( bs_sz, j_qn, erg_ofs )
   long bs_sz, j_qn, erg_ofs ;
   {
   long k_qn, row_ct, col_ct ;
   double tmp1[ 100 ][ 100 ], tmp2[ 100 ][ 100 ], tmp3[ 100 ][ 100 ] ;



/INITIALIZE MATRICIES/
   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
      for( row_ct = 0; row_ct < bs_sz; row_ct++ )
          *(*(tmp1 + col_ct) + row_ct) = *(*(tmp2 + col_ct) + row_ct) =
          *(*(tmp3 + col_ct) + row_ct) = 0.0 ;



/CALCULATE ON-DIAGONAL MATRIX ELEMENTS OF ORIGINAL HAMILTONIAN/
   for( k_qn = 0; k_qn <= j_qn; k_qn++ )
      *(*(tmp1 + j_qn - k_qn) + j_qn - k_qn) =
      *(*(tmp1 + j_qn + k_qn) + j_qn + k_qn) =
           F_val * j_qn * (j_qn + 1) + (G_val - F_val) * k_qn * k_qn ;

/CALCULATE OFF-DIAGONAL MATRIX ELEMENTS OF ORIGINAL HAMILTONIAN/
   for( k_qn = -j_qn; k_qn < j_qn - 1; k_qn++ )
      *(*(tmp1 + j_qn + k_qn) + j_qn + k_qn + 2) =
      *(*(tmp1 + j_qn + k_qn + 2) + j_qn + k_qn) =
            0.5 * H_val * sqrt( (double)(j_qn * (j_qn + 1) - k_qn * (k_qn + 1)) *
            (j_qn * (j_qn + 1) - (k_qn + 1) * (k_qn + 2)) ) ;



/MATRIX MULTIPLY -> A' = D~ * (A * D)/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp2 + row_ct) + col_ct) += *(*(tmp1 + row_ct) + k_qn) * *(h2v_mat + k_qn * bs_sz + col_ct) ;


/MATRIX MULTIPLY -> A' = (D~ * (A * D))/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp3 + row_ct) + col_ct) += *(h2v_mat + k_qn * bs_sz + row_ct) * *(*(tmp2 + k_qn) + col_ct) ;


   printf( "BS = %ld J_CT = %ld\n", bs_sz, j_qn ) ;
   fflush( stdout ) ;


/PRINT EIGENVALUES/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      printf( "%12.2le", *(*(Erg_vec + st) + erg_ofs + row_ct) ) ;
   printf( "\n" ) ;


/PRINT MATRIX/
   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      {
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         printf( "%12.2le", *(*(tmp3 + row_ct) + col_ct) ) ;

      printf( "\n" ) ;
      }
   }
*/
/*
simtrans( bs_sz )
   long bs_sz ;
   {
   long k_qn, row_ct, col_ct ;
   double tmp1[ 100 ][ 100 ], tmp2[ 100 ][ 100 ], tmp3[ 100 ][ 100 ] ;


   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
      for( row_ct = 0; row_ct < bs_sz; row_ct++ )
          *(*(tmp1 + col_ct) + row_ct) = *(*(tmp1 + col_ct) + row_ct) =
          *(*(tmp2 + col_ct) + row_ct) = 0.0 ;


   for( col_ct = 0; col_ct < bs_sz; col_ct++ )
       *(*(tmp1 + col_ct) + col_ct) = *(Erg_vec + col_ct) ;


   for( row_ct = 0; row_ct <= bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp2 + row_ct) + col_ct) += *(*(tmp1 + row_ct) + k_qn) * *(h2v_mat + col_ct * bs_sz + k_qn) ;

   for( row_ct = 0; row_ct < bs_sz; row_ct++ )
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
            *(*(tmp3 + row_ct) + col_ct) += *(h2v_mat + row_ct * bs_sz + k_qn) * *(*(tmp2 + k_qn) + col_ct) ;



   for( row_ct = 0; row_ct < bs_sz; row_ct++ )        
      {
      for( col_ct = 0; col_ct < bs_sz; col_ct++ )
         printf( "%12.2le", *(*(tmp3 + row_ct) + col_ct) ) ;

      printf( "\n" ) ;
      }
   }
*/
/*
   /SKIP HEADER STUFF/
      lseek( bs_fd, (long)(BS_HEADER * sizeof( double )), 0 ) ;

   /SIMULARITY TRANSFORMATION/
      simtrans( bs_sz, j_qn, erg_ofs ) ;

      for( k_qn = 0; k_qn < bs_sz; k_qn++ )        
         {
         for( cts = 0; cts < bs_sz; cts++ )
            printf( "%10.2le", *(h2v_mat + k_qn * bs_sz + cts) ) ;

         printf( "\n" ) ;
         }
      printf( "\n" ) ;
*/
/*
double F_val, G_val, H_val ;

/DEFINE KAPPA -> PROLATE OR NEAR PROLATE TOP/
   if( (Kap[ st ] = (2 * B_rc[ st ] - A_rc[ st ] - C_rc[ st ]) / (A_rc[ st ] - C_rc[ st ])) <= -0.5 )
      {
      F_val = 0.5 * (Kap[ st ] - 1.0) ;
      G_val = 1.0 ;
      H_val = -0.5 * (Kap[ st ] + 1.0) ;
      }

/OBLATE OR NEAR OBLATE TOP/
   else if( Kap[ st ] >= 0.5 )
      {

      F_val = 0.5 * (Kap[ st ] + 1.0) ;
      G_val = -1.0 ;
      H_val = 0.5 * (Kap[ st ] - 1.0) ;
      }

/ASYMMETRY TOP/
   else
      {
      F_val = 0.0 ;
      G_val = Kap[ st ] ;
      H_val = 1.0 ;
      }

/PRINT KAPPA VALUE/
   printf( "KAPPA = %lf\n", Kap[ st ] ) ;

   /GENERATE DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn <= j_qn; k_qn++ )
         {
         tmp = *(h2v_mat + (j_qn + k_qn) * bs_sz + j_qn + k_qn) =
              F_val * j_qn * (j_qn + 1) + (G_val - F_val) * k_qn * k_qn ;
         *(h2v_mat + (j_qn - k_qn) * bs_sz + j_qn - k_qn) = tmp ;
         }


   /GENERATE OFF-DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn < 2 * j_qn - 1; k_qn++ )
         *(h2v_mat + k_qn * bs_sz + k_qn + 2) =
         *(h2v_mat + (k_qn + 2) * bs_sz + k_qn) =
               0.5 * H_val * sqrt( (double)(j_qn * (j_qn + 1) - (k_qn - j_qn) * (k_qn + 1 - j_qn)) *
               (j_qn * (j_qn + 1) - (k_qn + 1 - j_qn) * (k_qn + 2 - j_qn)) ) ;



   /GENERATE DIAGONAL ELEMENTS OF HAMILTONIAN MATRIX (A = 1.0, B = KAPPA, C = -1.0)/
      for( k_qn = 0; k_qn < 2 * j_qn; k_qn++ )
         {
         *(h2v_mat + k_qn * bs_sz + k_qn + 1) =
         *(h2v_mat + (k_qn + 1) * bs_sz + k_qn) =
               0.5 * A_val * (2.0 * k_qn + 1) *
               sqrt( (double)(j_qn * (j_qn + 1) - (k_qn - j_qn) * (k_qn + 1 - j_qn)) ) ;
         }



   /CALCULATE TOTAL ENERGY/
      for( k_qn = 0; k_qn < bs_sz; k_qn++ )
         *(*(Erg_vec + st) + erg_ofs + k_qn) =
               0.5 * (A_rc[ st ] + C_rc[ st ]) * j_qn * (j_qn + 1) +
               0.5 * (A_rc[ st ] - C_rc[ st ]) * *(*(Erg_vec + st) + erg_ofs + k_qn) ;

*/
/*
         if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
            {
            fprintf( Log_fp, "\nREAL = \n" ) ;
            for( row = 0; row < bs_sz; row++ )
               {
               for( col = 0; col < bs_sz; col++ )
                  fprintf( Log_fp, "%15.5lf", *(h2v_mat + row * bs_sz + col) ) ;
               fprintf( Log_fp, "\n" ) ;
               }

            fprintf( Log_fp, "\n" ) ;
            }
         if( j_qn <= Prt_ee[ 1 ] && j_qn >= Prt_ee[ 0 ] )
            {
            fprintf( Log_fp, "IMAGINARY = \n" ) ;
            for( row = 0; row < bs_sz; row++ )
               {
               for( col = 0; col < bs_sz; col++ )
                  fprintf( Log_fp, "%15.5lf", *(h2v_mat + row * bs_sz + col) ) ;
               fprintf( Log_fp, "\n" ) ;
               }

            fprintf( Log_fp, "\n" ) ;
            }

*/
/*
            printf( "\nPZ**2               PX**2               PY**2  J> %ld ROW> %ld\n", j_qn, row ) ;
            printf( "%-20.4lf", *(dvs_mat + row * no_dvs + 0) ) ;
            printf( "%-20.4lf%-.4lf\n", *(dvs_mat + row_ofs + 1), *(dvs_mat + row_ofs + 2) ) ;
            if( Rc_stat[ st ][ PZ ] )
               printf( "\nPZ> %.6lf\n", *(dvs_mat + row_ofs + 3) ) ;
*/
/*
   /CHANGE SIGN OF LOWER STATE DERIVATIVES/
      for( row_ofs = 0, row = 0; row < bs_sz; row_ofs = ++row * no_dvs )
         for( col = 0; col < no_dvs; col++ )
            *(dvs_mat + row_ofs + col) *= -1.0 ;
*/
/*
                        sqrt( (double)(j_qn - k_qn) * (j_qn + k_qn + 1) * 
                                      (j_qn - k_qn - 1) * (j_qn + k_qn + 2) )) ;
*/
