// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_SPECTRUM_H
#define KROT_SPECTRUM_H



#include "dataset.h"
#include "rawData.h"



class KRotData;
class QString;



/**
 * @short Spectrum container.
 *
 * Provides a container for spectra.
 * The only real functional difference to \ref DataSet is the ability to load
 * a spectrum from xy data, but since this is not a general \ref DataSet property
 * I put it into its own class.
 *
 * @author Jochen Kpper
 * @version 1999/01/17
 */
class Spectrum : virtual public DataSet
{

public:

    /**
     * Standard Constructor.
     */
    Spectrum( KRotData *krotdata=0 );

    /**
     * Almost-Copy constructor.
     * Creates a Spectrum from any dataset.
     *
     * @param set DataSet to duplicate.
     */
    Spectrum( const DataSet& set );
    
    /**
     * Constructor.
     *
     * Create new Spectrum from imported data.
     *
     * @param import Imported data. All marker positions and one absolute
     * frequency need to be know already.
     */
    Spectrum( const RawData& import, KRotData *g );


protected:

  /**
   * load spectral data from an xy-file.
   *
   * @param filename The fully qualified filename to load the data from.
   * @return True on success, false on any error.
   */
  virtual void loadXY( const QString& filename );
};



#endif



//* Local Variables:
//* c-file-style: "Stroustrup"
//* mode: C++
//* End:
