// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.



#ifndef KROT_MAINWINDOW_INLINE_H
#define KROT_MAINWINDOW_INLINE_H



inline void MainWindow::arnirot()
{
    KROT_LAUNCH( "Launching MainWindow::arnirot" );
    dialogArnirot->exec();
}



inline void MainWindow::averaging( const char *text )
{
    KROT_LAUNCH( "Launching MainWindow::averaging" );
    int av = atoi( text );
    char buffer[8];
    sprintf( buffer, "%d", av );
    toolBar()->changeComboItem( ID_AVERAGING, buffer, -1 );
    emit newAveraging( av );
    return;
}



inline void MainWindow::clearMessage()
{
    KROT_LAUNCH( "Launching MainWindow::clearMessage" );
    statusBar()->changeItem( "", ID_MESSAGE );
    return;
}



inline void MainWindow::close()
{
    KROT_LAUNCH( "Launching MainWindow::close" );
    QWidget::close();
    return;
}



inline void MainWindow::closeAll()
{
    KROT_LAUNCH( "Launching MainWindow::closeAll" );
    while( windowList.first() != this )
	windowList.first()->close();
    while( windowList.last() != this )
	windowList.last()->close();
    QWidget::close();
    return;
}



inline void MainWindow::editSpectra()
{
    KROT_LAUNCH( "Launching MainWindow::editSpectra" );
    if( ! krotData->empty( KRotData::SPECTRA ) ) {
    } else
	setMessage( i18n( "No Spectrum loaded right now." ) );
    return;
}



inline void MainWindow::geomTransform()
{
    KROT_LAUNCH( "Launching MainWindow::geomTransform" );
    if( ! krotData->empty( KRotData::DATASETS ) ) {
	dialogGeomTransform->exec();
    } else
	setMessage( i18n( "No Dataset loaded right now." ) );
    return;
}



inline void MainWindow::setFreq( const int64_t freq )
{
    KROT_LAUNCH_VERBOSE( "Launching MainWindow::setFreq" );
    char msg[16];
    sprintf( msg, "%10Ld MHz", static_cast< long long int >( freq ) );
    statusBar()->changeItem( msg, ID_FREQUENCY );
    return;
}


inline void MainWindow::save()
{
    KROT_LAUNCH( "Launching MainWindow::save" );
    KMsgBox::message( this, i18n( "Save" ),
		      i18n( "MainWindow::save not implemented yet!" ),
		      KMsgBox::EXCLAMATION, i18n( "OK" ) );
    return;
}



inline void MainWindow::setMessage( const QString& msg )
{
    statusBar()->changeItem( msg, ID_MESSAGE );
    msgTimer->start( messageTimout, true );
    return;
}



#endif // KROT_MAINWINDOW_INLINE_H



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
