c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"

      subroutine linord( maxnl, npr, ntheli, nparg, npare, iop, dlg,
     *                   dle, pqnth, lqn, lqn2, intens, thefre )
c     sort lines information by packed quantum number

      implicit none

      integer        maxnli, maxnl
      parameter      ( maxnli = ARNIROT_MAXNLI )
      integer        npar, npr
      parameter      ( npar = ARNIROT_NPAR )

      integer        i
      integer        iop(maxnl)
      integer        lqn(maxnl,6),  lqntmp(maxnli,6)
      integer        lqn2(maxnl,6)
      integer        nparg, npare
      integer        ntheli

      real*8         dlg(maxnl,npr), dlgtmp(maxnli,npar)
      real*8         dle(maxnl,npr), dletmp(maxnli,npar)
      real*8         pqnth(maxnl)
      real*8         thefre(maxnl), thetmp(maxnli)
      real*8         intens(maxnl), inttmp(maxnli)

#ifdef DEBUG_SUBBRANCH_OUTPUT
      integer        lq2tmp(maxnli,6)
#endif

      ARNIROT_LAUNCH ( "Launching linord." )

c     temporarily store lines data for sorting
      call rvcpy( inttmp, intens, maxnli, ntheli )
      call rvcpy( thetmp, thefre, maxnli, ntheli )

c     former versions : set nacols to full number of possible parameters
c     now (1998-09-11): pass this parameter as nparg, npare from call to subroutine to save time  (Arnim)
      call rmcpy( dlgtmp, dlg,  maxnli, npar, ntheli, nparg )
      call rmcpy( dletmp, dle,  maxnli, npar, ntheli, npare )
      call imcpy( lqntmp, lqn,  maxnli, 6, ntheli, 6 )
#ifdef DEBUG_SUBBRANCH_OUTPUT
      call imcpy( lq2tmp, lqn2, maxnli, 6, ntheli, 6 )
#endif

c     loop through the lines to associate an ordering pointer with each line
      do i = 1, ntheli, 1
         iop(i) = i
      end do
c     sort the frequencies into descending order by packed quantum number
      call sort2d( ntheli, pqnth, iop )

c     now exchange the theoretical lines information back according to iop order
      call rvcpyo( intens, inttmp, iop, maxnli, ntheli )
      call rvcpyo( thefre, thetmp, iop, maxnli, ntheli )
      call rmcpyo( dlg,    dlgtmp, iop, maxnli, npar, ntheli, nparg )
      call rmcpyo( dle,    dletmp, iop, maxnli, npar, ntheli, npare )
      call imcpyo( lqn,    lqntmp, iop, maxnli, 6, ntheli, 6 )
#ifdef DEBUG_SUBBRANCH_OUTPUT
      call imcpyo( lqn2,   lq2tmp, iop, maxnli, 6, ntheli, 6 )
#endif

      return
      end


c------------------------------------------------------------------------------
      subroutine sort2d( n, ra, irb )
c     fast sorting algorithm to create an index for DESCENDING order (from NUMERICAL RECIPES)

      implicit none

      integer        i, ir, irrb, j, l, n
      integer        irb(n)
      real*8         ra(n), rra

      ARNIROT_LAUNCH ( "Launching sort2d." )

      l = n/2 + 1
      ir = n
   10 continue
      if (l.gt.1) then
         l = l - 1
         rra  = ra(l)
         irrb = irb(l)
      else
         rra  = ra(ir)
         irrb = irb(ir)
         ra(ir)  = ra(1)
         irb(ir) = irb(1)
         ir = ir - 1
         if (ir.eq.1) then
            ra(1)  = rra
            irb(1) = irrb
            return
         end if
      end if
      i = l
      j = l + l
   20 if (j.le.ir) then
         if (j.lt.ir) then
c           sort into DESCENDING order
            if (ra(j).gt.ra(j+1)) j = j + 1
         end if
c        sort into DESCENDING order
         if (rra.gt.ra(j)) then
            ra(i)  = ra(j)
            irb(i) = irb(j)
            i = j
            j = j + j
         else
            j = ir + 1
         end if
         goto 20
      end if
      ra(i)  = rra
      irb(i) = irrb
      goto 10

      end


c------------------------------------------------------------------------------
      subroutine sort2a( n, ra, irb )
c     fast sorting algorithm to create an index for ASCENDING order (from NUMERICAL RECIPES)

      implicit none

      integer        i, ir, irrb, j, l, n
      integer        irb(n)
      real*8         ra(n), rra

      ARNIROT_LAUNCH ( "Launching sort2a." )

      l = n/2 + 1
      ir = n
   10 continue
      if (l.gt.1) then
         l = l - 1
         rra  = ra(l)
         irrb = irb(l)
      else
         rra  = ra(ir)
         irrb = irb(ir)
         ra(ir)  = ra(1)
         irb(ir) = irb(1)
         ir = ir - 1
         if (ir.eq.1) then
            ra(1)  = rra
            irb(1) = irrb
            return
         end if
      end if
      i = l
      j = l + l
   20 if (j.le.ir) then
         if (j.lt.ir) then
c           sort into ASCENDING order
            if (ra(j).lt.ra(j+1)) j = j + 1
         end if
c        sort into ASCENDING order
         if (rra.lt.ra(j)) then
            ra(i)  = ra(j)
            irb(i) = irb(j)
            i = j
            j = j + j
         else
            j = ir + 1
         end if
         goto 20
      end if
      ra(i)  = rra
      irb(i) = irrb
      goto 10

      end


c------------------------------------------------------------------------------
      subroutine rvcpy( rvec1, rvec2, max, iact )
c     copy a real number vector RVEC2 into RVEC1

      implicit none

      integer        i, iact, max
      real*8         rvec1(max), rvec2(max)

      ARNIROT_LAUNCH ( "Launching rvcpy." )

      do i = 1, iact, 1
         rvec1(i) = rvec2(i)
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine rvcpyo( rvec1, rvec2, iop, max, iact )
c     generate an ordered copy of a real number vector RVEC2 in RVEC1

      implicit none

      integer        i, iact, max
      integer        iop(max)
      real*8         rvec1(max), rvec2(max)

      ARNIROT_LAUNCH ( "Launching rvcpyo." )

      do i = 1, iact, 1
         rvec1(i) = rvec2(iop(i))
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine rmcpy( rmat1, rmat2, nrmax, ncmax, nr, nc )
c     copy a real number matrix RMAT2 into RMAT1

      implicit none

      integer        i, j, nrmax, ncmax, nr, nc
      real*8         rmat1(nrmax,ncmax), rmat2(nrmax,ncmax)

      ARNIROT_LAUNCH ( "Launching rmcpy." )

      do j = 1, nc, 1
         do i = 1, nr, 1
            rmat1(i,j) = rmat2(i,j)
         end do
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine rmcpyo( rmat1, rmat2, iop, nrmax, ncmax, nr, nc )
c     generate a column-ordered copy of a real number matrix RMAT2 in RMAT1

      implicit none

      integer        i, j, nrmax, ncmax, nr, nc
      integer        iop(nrmax)
      real*8         rmat1(nrmax,ncmax), rmat2(nrmax,ncmax)

      ARNIROT_LAUNCH ( "Launching rmcpyo." )

      do j = 1, nc, 1
         do i = 1, nr, 1
            rmat1(i,j) = rmat2(iop(i),j)
         end do
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine imcpy( imat1, imat2, nrmax, ncmax, nr, nc )
c     copy an integer number matrix IMAT2 into IMAT1

      implicit none

      integer        i, j, nrmax, ncmax, nr, nc
      integer        imat1(nrmax,ncmax), imat2(nrmax,ncmax)

      ARNIROT_LAUNCH ( "Launching imcpy." )

      do j = 1, nc, 1
         do i = 1, nr, 1
            imat1(i,j) = imat2(i,j)
         end do
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine imcpyo( imat1, imat2, iop, nrmax, ncmax, nr, nc )
c     generate a column-ordered copy of an integer number matrix IMAT2 in IMAT1

      implicit none

      integer        i, j, nrmax, ncmax, nr, nc
      integer        imat1(nrmax,ncmax), imat2(nrmax,ncmax), iop(nrmax)

      ARNIROT_LAUNCH ( "Launching imcpyo." )

      do j = 1, nc, 1
         do i = 1, nr, 1
            imat1(i,j) = imat2(iop(i),j)
         end do
      end do

      return
      end
