c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1999 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"


      subroutine paraIO( iunin, iunout, r0b1w2,
     *                   Jmax, npar,
     *                   swg, swe, swang, itrvec,
     *                   diaalg,
     *                   Jmxcal, dKmax, cutint,
     *                   lifile, asfile,
     *                   fitges, ifit, sigma,
     *                   polori,
     *                   shorti,
     *                   cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *                   cBran, polax1,
     *                   lbars, ldash,
     *                   temp1, temp2, weight, nuspsw,
     *                   nuzero,
     *                   divis, Jmxout, normf,
     *                   rotcog, rotcoe, idelta,
     *                   fsrcor, olitmx,
     *                   stflag )

c     read parameters from standard input

c     defined input/output units being used:
c        5 keyboard or directed input,
c        6 screen or directed output,
c        0 no output desired
c     read or/and write switch r0b1w2:
c        0 read in new value of variable
c        1 both read and write value (old input format)
c        2 write out passed value (new input format)

      implicit none

      integer        Jmax, npar

      integer        i, k
      integer        diaalg
      integer        fitges
      integer        idelta
      integer        ifit(2*npar+2)
      integer        itrvec
      integer        iunin, iunout
      integer        Jmxcal, Jmxout
      integer        dKmax
      integer        normf
      integer        nuspsw(0:3)
      integer        olitmx
      integer        r0b1w2
      integer        shorti
      integer        stflag
      integer        strlen
      integer        swe, swg

      real*8         cutint
      real*8         divis
      real*8         fsrcor
      real*8         nuzero
      real*8         polori(3)
      real*8         rotcoe(npar), rotcog(npar)
      real*8         sigma
      real*8         swang(3,2)
      real*8         temp1, temp2, weight

      character*1    ocon(3), oaxi(3)
      character*1    cBran(-1:1), polax1(3)
      character*3    no_yes(0:1), off_on(0:1)
      character*5    cRotCg(npar), cRotCe(npar), cEuler(3)
      character*7    cState(2)
      character*9    cDRotC(npar)
      character*81   lbars, ldash
      character*250  asfile, lifile


      ARNIROT_LAUNCH ( "Launching paraIO." )

      call transf( iunin, iunout, r0b1w2,
     *             Jmax, npar,
     *             swg, swe, swang, itrvec,
     *             diaalg,
     *             Jmxcal, dKmax, cutint,
     *             lifile, asfile,
     *             fitges, ifit, sigma,
     *             polori,
     *             shorti,
     *             temp1, temp2, weight, nuspsw,
     *             nuzero,
     *             divis, Jmxout, normf,
     *             rotcog, rotcoe, idelta,
     *             fsrcor, olitmx,
     *             stflag )

c     return if just outputting parameter values
      if ( r0b1w2 .gt. 0 )
     *     goto 999

      if ( shorti .eq. 0 ) then
c        define identification of axes with x,y,z respectively
         ocon(1) = 'b'
         ocon(2) = 'c'
         ocon(3) = 'a'
c        define order of axes with respect to the order a,b,c
         oaxi(1) = 'z'
         oaxi(2) = 'x'
         oaxi(3) = 'y'

c        output enhancements
         write(*,'(a)') lbars
         write(*,'(a)') 'rigid rotor hamiltonian parameters:'
         write(*,'(a)') lbars

         if ( idelta .eq. 0 ) then
c           --- output absolute constants ---
c           output the rigid rotor part of the hamiltonian for ground and excited states
            do i = 1, 3, 1
               write(*,115) cRotCg(i), rotcog(i), cRotCe(i), rotcoe(i), oaxi(i)
  115          format(a5,':',f15.6,' MHz',10x,a5,':',f15.6,' MHz',6x,a1,' axis')
            end do
            write(*,'(a)') lbars
            write(*,'(a)') 'linear angular momentum hamiltonian parameters:'
            write(*,'(a)') lbars
            do i = 4, 6, 1
               write(*,120) cRotCg(i), rotcog(i), cRotCe(i), rotcoe(i), ocon(i-3)
  120          format(a5,':',f15.6,' MHz',10x,a5,':',f15.6,' MHz',6x,a1,' axis')
            end do
            write(*,'(a)') lbars
            write(*,'(a)') 'quartic terms of the Watson hamiltonian:'
            write(*,'(a)') lbars
            do i = 7, 11, 1
               write(*,125) cRotCg(i), rotcog(i), cRotCe(i), rotcoe(i)
  125          format(a5,':',f15.6,' MHz',10x,a5,':',f15.6,' MHz')
            end do
         else
c           --- output excited state constants as deltas ---
c           output the rigid rotor part of the hamiltonian for ground and excited states
            do i = 1, 3, 1
               write(*,130) cRotCg(i), rotcog(i), cDRotC(i), rotcoe(i), oaxi(i)
  130          format(a5,':',f15.6,' MHz',6x,a9,':',f15.6,' MHz',6x,a1,' axis')
            end do
            write(*,'(a)') lbars
            write(*,'(a)') 'linear angular momentum hamiltonian parameters:'
            write(*,'(a)') lbars
            do i = 4, 6, 1
               write(*,135) cRotCg(i), rotcog(i), cDRotC(i), rotcoe(i), ocon(i-3)
  135          format(a5,':',f15.6,' MHz',6x,a9,':',f15.6,' MHz',6x,a1,' axis')
            end do
            write(*,'(a)') lbars
            write(*,'(a)') 'quartic terms of the Watson hamiltonian:'
            write(*,'(a)') lbars
            do i = 7, 11, 1
               write(*,140) cRotCg(i), rotcog(i), cDRotC(i), rotcoe(i)
  140          format(a5,':',e15.6,' MHz',6x,a9,':',e15.6,' MHz')
            end do
c           conversion of Deltas to absolute constants is now done at the
c           beginning of each iteration
c           call delabs( rotcog, rotcoe, npar, 0 )
         end if

         write(*,'(a)') lbars
         write(*,'(''absolute spectrum center (nu0)'',9x,'':'',f15.3,'' MHz'')') nuzero
         write(*,'(/,''etalon FSR correction factor'',11x,'':'',f19.7)') fsrcor
         write(*,'(a)') lbars
         write(*,'(a)') 'intensity calculation parameters:'
         write(*,'(a)') lbars
         write(*,'(''ground state rotational temperature T1 :'',f8.3,'' K'')') temp1
         write(*,'(''ground state rotational temperature T2 :'',f8.3,'' K'')') temp2
         write(*,'(''relative weighting factor T2 / T1 term :'',f8.3)') weight
         write(*,'(/,''symmetry species (KHC notation)'',11x,''ee  eo  oe  oo'')')
         write(*,'(''nuclear spin statistical weights       :'',4(i4))') (nuspsw(k), k = 0, 3, 1)
         write(*,'(a)') lbars
         write(*,'(a)') 'transition moment orientation:'
         write(*,'(a)') lbars
         write(*,'(a)') 'square of transition dipole component'
         do i = 1, 3, 1
            write(*,'(29x,a1,''('',a1,'') axis :'',f9.4,'' %'')') polax1(i), ocon(i), polori(i)
         end do
         write(*,'(a)') lbars
         write(*,'(a)') 'axis reorientation parameters:'
         write(*,'(a)') lbars
         write(*,'(''ground state:'',27x,''excited state:'',/)')
         write(*,'(''axis switching '',a3,22x,''axis switching '',a3,/)') off_on(swg), off_on(swe)
         do i = 1, 3, 1
            write(*,'(a5,'': '',f6.2,'' cc degrees'',16x,a5,'': '',f6.2,'' cc degrees'')') cEuler(i), swang(i,1), cEuler(i), swang(i,2)
         end do
         write(*,'(/,a,a3)') 'rotate transition moment vector ', off_on(itrvec)
         write(*,'(a)') lbars
         write(*,'(a)') 'extent of calculation:'
         write(*,'(a)') lbars
         write(*,'(''algorithm for diagonalization  Jacobi(1) / tridi(2) :'',i6)') diaalg
         write(*,'(''maximum J in this calculation  (current limit: '',i3,'') :'',i6)') Jmax, Jmxcal
         write(*,'(''lower limit on intensity of calculated lines'',8x,'':'',f13.6)') cutint
         write(*,'(''Delta Ka, Delta Kc search limit for transitions'',5x,'':'',i6)') dKmax
         write(*,'(a)') lbars
         write(*,'(a)') 'output manipulation:'
         write(*,'(a)') lbars
         write(*,'(''maximum J block to output calculation details (<11) :'',i6)') Jmxout
         write(*,'(2a)') 'file to store line information (stick spectrum)     : ', lifile(1:strlen(lifile))
         write(*,'(''divisor for scaling frequencies'',21x,'':'',f13.6)') divis
         write(*,'(''normalization factor to scale intensities'',11x,'':'',i6)') normf
         write(*,'(a)') lbars
         write(*,'(a)') 'statistical analysis parameters:'
         write(*,'(a)') lbars
         write(*,'(2a)') 'file containing assigned experimental lines         : ', asfile(1:strlen(asfile))
         write(*,'(2a)') 'fit ground and/or excited state parameters          : ', no_yes(fitges)
       write(*,'(a,i6)') 'number of complete calculation and fit cycles       :', olitmx
         write(*,'(a)') ldash
c        output the fit status
         write(*,'(''parameter status  active (ON)/invariant (OFF)'',7x,'':'',/)')
         do i = 1, npar, 1
            write(*,150) cRotCg(i), off_on(ifit(i)), cRotCe(i), cDRotC(i), off_on(ifit(i+npar))
  150       format(a5, 2x, a3, 20x, a5, '/', a9, 2x, a3)
         end do
         write(*,'(/,10x,''nuzero    '',a3)') off_on(ifit(2*npar+1))
         write(*,'(/,10x,''fsrcor    '',a3)') off_on(ifit(2*npar+2))
      end if

  999 continue
      ARNIROT_LAUNCH ( "Leaving paraIO." )

      return
      end

c------------------------------------------------------------------------------
      subroutine transf( iunin, iunout, r0b1w2,
     *                   Jmax, npar,
     *                   swg, swe, swang, itrvec,
     *                   diaalg,
     *                   Jmxcal, dKmax, cutint,
     *                   lifile, asfile,
     *                   fitges, ifit, sigma,
     *                   polori,
     *                   shorti,
     *                   temp1, temp2, weight, nuspsw,
     *                   nuzero,
     *                   divis, Jmxout, normf,
     *                   rotcog, rotcoe, idelta,
     *                   fsrcor, olitmx,
     *                   stflag )
c     transfer data with various options between files and program

      implicit none

      integer        npar

      integer        atoi
      integer        diaalg
      integer        fites, fitgs, fitges
      integer        i
      integer        idelta
      integer        ierr
      integer        ifit(2*npar+2)
      integer        iline1
      integer        itrvec
      integer        iunin, iunout
      integer        Jmax, Jmxcal, Jmxout
      integer        dKmax
      integer        normf
      integer        nuspsw(0:3)
      integer        olitmx
      integer        r0b1w2
      integer        shorti
      integer        stflag
      integer        swe, swg

      real*8         cutint
      real*8         divis
      real*8         fsrcor
      real*8         nuzero
      real*8         polori(3)
      real*8         rotcoe(npar), rotcog(npar)
      real*8         sigma
      real*8         swang(3,2)
      real*8         temp1, temp2, weight

      character*250  line1, asfile, lifile

      ARNIROT_LAUNCH ( "Launching transf." )

c     reset error control
      ierr = 0

      if ( r0b1w2 .eq. 0 ) then
c        READ ONLY
c        assign some default values to prevent collapse in case of incompatible (old) input files
         temp2  = 1.d0
         weight = 0.d0
         do i = 0, 3, 1
            nuspsw(i) = 1
         end do
         fsrcor = 1.d0
         ifit(2*npar+2) = 0
         olitmx = 1

c        determine type of input file by examining the first line
         call rwlin1( line1, iunin, iunout, r0b1w2, ierr )
         iline1 = atoi( line1 )
         if ( iline1 .eq. -1 ) then
            shorti = 1
         else
            shorti = 0
         end if

      else if ( r0b1w2 .eq. 1 ) then
c        READ AND WRITE - OLD VERSION
c        read and write first line of input file
         call rwlins( 1, iunin, iunout, ierr )

      else
c        WRITE ONLY - NEW VERSION (short IO)
         if ( iunout .eq. 6 ) then
c           output parameters to standard output
c
c           *** rotational model parameters ***
c
            do i = 1, npar, 1
               write(*,*) rotcog(i), rotcoe(i)
            end do
            write(*,*) nuzero
#ifdef DEBUG_NEW_INPUT
         else
c           output parameters to specified output unit
c
c           *** rotational model parameters ***
c
            do i = 1, npar, 1
               write(iunout,'(2(3x,f18.9,i3))') rotcog(i), ifit(i), rotcoe(i), ifit(npar+i)
            end do
            write(iunout,'(f21.9,i3)') nuzero, ifit(2*npar+1)
c
c           *** intensity parameters ***
c
            write(iunout,'(3(3x,f7.2))') polori(3), polori(1), polori(2)
            write(iunout,'(2(3x,f7.2),3x,f7.4)') temp1, temp2, weight
            write(iunout,'(4(i5))') (nuspsw(i), i = 0, 3, 1)
c
c           *** axis reorientation parameters ***
c
            write(iunout,'(i6,3x,i6)') swg, swe
            do i = 1, 3, 1
               write(iunout,'(2(3x,f6.2))') swang(i,1), swang(i,2)
            end do
            write(iunout,'(i6)') itrvec
c
c           *** extent of calculation ***
c
            write(iunout,'(2(i6))') Jmxcal, dKmax
            write(iunout,'(f12.6)') cutint
c
c           *** parameters for least squares fit ***
c
            write(iunout,'(i6)') fitges
            write(iunout,'(f12.6)') sigma
#endif
         end if
      end if

c/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

      if ( ( r0b1w2 .eq. 0 ) .and. ( shorti .eq. 1 ) ) then
c        read in parameters with new IO format from standard input
c
c        *** rotational model parameters and fit flags ***
c
c        excited state parameters are always absolute values
         idelta = 0
         do i = 1, npar
            read(iunin,*) rotcog(i), ifit(i), rotcoe(i), ifit( npar+i )
         end do
         read(iunin,*) nuzero, ifit(2*npar+1)
c
c        *** intensity parameters ***
c
         read(iunin,*) polori(3), polori(1), polori(2)
         read(iunin,*) temp1, temp2, weight
         read(iunin,*) ( nuspsw( i ), i = 0, 3 )
c
c        *** axis reorientation parameters ***
c
         read(iunin,*) swg, swe
         do i = 1, 3
            read(iunin,*) swang( i, 1 ), swang( i, 2 )
         end do
         read(iunin,*) itrvec
c
c        *** extent of calculation ***
c
         read(iunin,*) Jmxcal, dKmax
         read(iunin,*) cutint
c
c        *** output manipulation and other parameters to initialize ***
c
         Jmxout = -1
         lifile = 'noname.dat'
         divis  = 1.d0
         normf  = 1
         asfile = 'noname.exp'
         diaalg = 1
c
c        *** parameters for least squares fit ***
c
         read(iunin,*) fitges
         read(iunin,*) sigma

c/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

      else if ( r0b1w2 .ne. 2 ) then
c        read (and write) parameters from standard input (file to file) using old IO format
c        read/write five remaining commentary lines
         call rwlins( 5, iunin, iunout, ierr )
         if ( ierr .gt. 0 ) goto 999
c
c        *** lower vibronic state ***
c
         call rwlins( 4, iunin, iunout, ierr )
c        three rigid rotor ground state rotational constants
         do i = 1, 3, 1
            call rwreal( rotcog(i), iunin, iunout, r0b1w2, ierr )
         end do
c        three linear angular momentum ground state rotational constants
         call rwlins( 4, iunin, iunout, ierr )
         do i = 4, 6, 1
            call rwreal( rotcog(i), iunin, iunout, r0b1w2, ierr )
         end do
c        quartic terms of Watson hamiltonian
         do i = 7, 11, 1
            call rwreal( rotcog(i), iunin, iunout, r0b1w2, ierr )
         end do
c        switch: delta or absolute excited state constants
         call rwflag( idelta, iunin, iunout, r0b1w2, ierr )
c
c        *** upper vibronic state ***
c
         call rwlins( 4, iunin, iunout, ierr )
c        three rigid rotor excited state rotational constants
         do i = 1, 3, 1
            call rwreal( rotcoe(i), iunin, iunout, r0b1w2, ierr )
         end do
c        three linear angular momentum excited state rotational constants
         call rwlins( 4, iunin, iunout, ierr )
         do i = 4, 6, 1
            call rwreal( rotcoe(i), iunin, iunout, r0b1w2, ierr )
         end do
c        quartic terms of Watson hamiltonian
         do i = 7, 11, 1
            call rwreal( rotcoe(i), iunin, iunout, r0b1w2, ierr )
         end do
c
c        *** further parameters ***
c
c        absolute spectrum center (nuzero) [MHz]
         call rwreal( nuzero, iunin, iunout, r0b1w2, ierr )
         call rwlins( 4, iunin, iunout, ierr )

c        ground state rotational temperature 1
         call rwreal( temp1, iunin, iunout, r0b1w2, ierr )

c        transition dipole orientation
         do i = 1, 3, 1
            call rwreal( polori(i), iunin, iunout, r0b1w2, ierr )
         end do
         call rwlins( 8, iunin, iunout, ierr )

c        ground state axis switching parameters; axis switching on/off 1/0
         call rwflag( swg, iunin, iunout, r0b1w2, ierr )
c        theta, phi, chi ground state Euler angles
         do i = 1, 3, 1
            call rwreal( swang(i,1), iunin, iunout, r0b1w2, ierr )
         end do
         call rwlins( 4, iunin, iunout, ierr )
c        excited state axis switching parameters; axis switching on/off 1/0
         call rwflag( swe, iunin, iunout, r0b1w2, ierr )
c        theta, phi, chi excited state Euler angles
         do i = 1, 3, 1
            call rwreal( swang(i,2), iunin, iunout, r0b1w2, ierr )
         end do
c        rotate transition moment vector yes/no 1/0
         call rwflag( itrvec, iunin, iunout, r0b1w2, ierr )
         call rwlins( 4, iunin, iunout, ierr )

c        maximum J used for calculation
         call rwint( Jmxcal, iunin, iunout, r0b1w2, ierr )

c        lower limit on intensity of calculated lines
         call rwreal( cutint, iunin, iunout, r0b1w2, ierr )

c        restriction on Delta K selection rules
         call rwint( dKmax, iunin, iunout, r0b1w2, ierr )
         call rwlins( 4, iunin, iunout, ierr )

c        maximum J block to output calculation details
         call rwint( Jmxout, iunin, iunout, r0b1w2, ierr )
         Jmxout = min0( Jmxout, Jmxcal, 10 )

c        file to output line information
         call rwchar( lifile, iunin, iunout, r0b1w2, ierr )

c        floating point divisor for conversion of frequency unit on output (default MHz)
         call rwreal( divis, iunin, iunout, r0b1w2, ierr )
c        normalization factor to scale intensities
         call rwint( normf, iunin, iunout, r0b1w2, ierr )
         call rwlins( 4, iunin, iunout, ierr )

c        assignment file name
         call rwchar( asfile, iunin, iunout, r0b1w2, ierr )
c        extract values of fitgs and fites from fitges in case of writing parameters
         if ( r0b1w2 .eq. 1 ) then
            fitgs = fitges
            fites = fitges
         end if
c        switch for fitting the ground state parameters  yes(1)/no(0)
         call rwflag( fitgs, iunin, iunout, r0b1w2, ierr )
c        switch for fitting the excited state parameters
         call rwflag( fites, iunin, iunout, r0b1w2, ierr )
c        merge fitgs and fites to fitges in case of reading
         if ( r0b1w2 .eq. 0 ) then
            if ( ( fitgs .eq. 1 ) .or. ( fites .eq. 1 ) ) then
               fitges = 1
            else
               fitges = 0
            end if
         end if
c        assumed uncertainty in experimental line positions
         call rwreal( sigma, iunin, iunout, r0b1w2, ierr )

c        algorithm chosen for diagonalization
         call rwint( diaalg, iunin, iunout, r0b1w2, ierr )
         call rwlins( 8, iunin, iunout, ierr )

c        individual least squares fitting status  active(1)/invariant(0)
c        ground state parameters
         do i = 1, npar, 1
            call rwflag( ifit(i), iunin, iunout, r0b1w2, ierr )
         end do
         call rwlins( 4, iunin, iunout, ierr )
c        excited state parameters
         do i = 1, npar, 1
            call rwflag( ifit(npar+i), iunin, iunout, r0b1w2, ierr )
         end do
c        nuzero
         call rwflag( ifit(2*npar+1), iunin, iunout, r0b1w2, ierr )
c
c        *** supplements by A. Westphal ***
c        (supplements concerning the line intensities)
         call rwlins( 4, iunin, iunout, ierr )

c        ground state rotational temperature 2 for two-temperature model
         call rwreal( temp2, iunin, iunout, r0b1w2, ierr )
c        weight factor for the relative contribution of T2 (to T1) term
         call rwreal( weight, iunin, iunout, r0b1w2, ierr )
         if ( weight .le. 0.d0 ) then
            weight = 0.d0
            temp2  = 1.d0
         end if

c        nuclear spin statistical weights for symmetry species  ee, eo, oe, oo
         do i = 0, 3, 1
            call rwint( nuspsw(i), iunin, iunout, r0b1w2, ierr )
         end do

c        Arnim read in a debug flag - removed that on Nov 7, 1997 - Jochen
c        For debug purposes I use the C preprocessor and test whether DEBUG
c        is defined, in that case debug information is printed, otherwise no
c        code is executed (since it is not visible to the compiler at all),
c        so there is no runtime penalty.
c        idebug removed from all program modules on Sep 10, 1998 - Arnim

c        etalon FSR correction factor and corresponding fitting switch
c        added on Nov 26, 1998 - Arnim
#warning Does this work?
         call rwreal( fsrcor, iunin, iunout, r0b1w2, ierr )
c        error handling in case of incomplete (old) input files
         if ( ierr .ne. 0 ) then
            fsrcor = 1.d0
            ifit(2*npar+2) = 0
            olitmx = 1
            ierr = 0
         else
            call rwint( ifit(2*npar+2), iunin, iunout, r0b1w2, ierr )
c           number of optimization cycles
c           added on Jan 06, 1999 - Arnim
            call rwint( olitmx, iunin, iunout, r0b1w2, ierr )
            if ( ierr .ne. 0 ) then
               olitmx = 1
               ierr = 0
            end if
         end if
      end if

c     make sure Jmxcal is not too large
      Jmxcal = min0( Jmxcal, Jmax )

  999 if ( ierr .gt. 0 ) then
         write(*,'(a)') 'ERROR  : incorrectly formatted input - program termination'
         stflag = 2
      end if

      ARNIROT_LAUNCH ( "Leaving transf." )

      return
      end


c------------------------------------------------------------------------------
      subroutine rwlin1( line1, iunin, iunout, r0b1w2, ierr )
c     read (and possibly write) first line of input file

      implicit none

      integer        ierr, lerr, iunin, iunout, r0b1w2
      integer        strlen
      character*250  line1

      ARNIROT_LAUNCH ( "Launching rwlin1." )

      lerr = 1
c     read one (the first) line from an input file
      read(iunin, 10, end=999, err=999) line1
   10 format(a)
c     output if output unit specified
      if (iunout.ne.0) then
         write(iunout,'(a)') line1(1:strlen(line1))
      end if
      lerr = 0

  999 ierr = ierr + lerr

      return
      end


c------------------------------------------------------------------------------
      subroutine rwlins( nl, iunin, iunout, ierr )
c     read (and possibly write) NL commentary text lines

      implicit none

      integer        i, ierr, lerr, iunin, iunout, nl
      integer        strlen
      character*250  line(12)

      ARNIROT_LAUNCH ( "Launching rwlins." )

      lerr = 1
c     read NL comment lines from an input file
      do i = 1, nl, 1
         read(iunin, 10, end=999, err=999) line(i)
   10    format(a)
      end do
c     output if output unit specified
      if (iunout.ne.0) then
         do i = 1, nl, 1
            write(iunout,'(a)') line(i)(1:strlen(line(i)))
         end do
      end if
      lerr = 0

  999 ierr = ierr + lerr

      return
      end


c------------------------------------------------------------------------------
      subroutine rwflag( lvar, iunin, iunout, r0b1w2, ierr )
c     read (and possibly write) an integer flag variable (0 or 1) into an input field of the following form
c
c     blank line
c     |
c     variable descriptor
c     |
c     integer number variable
c

      implicit none

      integer        lvar, ierr, iunin, iunout, r0b1w2

      ARNIROT_LAUNCH ( "Launching rwflag." )

      if (r0b1w2.eq.1) then
         if (lvar.ne.0) lvar = 1
      end if

      call rwint(lvar, iunin, iunout, r0b1w2, ierr)

      if (lvar.ne.0) lvar = 1

      return
      end


c------------------------------------------------------------------------------
      subroutine rwint( ivar, iunin, iunout, r0b1w2, ierr )
c     read (and possibly write) an integer number variable into an input field of the following form
c
c     blank line
c     |
c     variable descriptor
c     |
c     integer number variable
c

      implicit none

      integer        ivar, idvar, ierr, lerr, iunin, iunout, r0b1w2

      ARNIROT_LAUNCH ( "Launching rwint." )

      lerr = 0
      call rwlins(4, iunin, iunout, lerr)
      if (lerr.eq.0) then
         lerr = 1
c        input new value of integer number variable
         read(iunin, *, end=999, err=999) idvar
c        if read only, equate this value to ivar, else reject it
         if (r0b1w2.eq.0) ivar = idvar
c        output delivered or input value if output unit specified
         if (iunout.ne.0) write(iunout,*) ivar
         lerr = 0
      end if
  999 ierr = ierr + lerr

      return
      end


c------------------------------------------------------------------------------
      subroutine rwreal( rvar, iunin, iunout, r0b1w2, ierr )
c     read (and possibly write) a real number variable in an input field of the following form
c
c     blank line
c     |
c     variable descriptor
c     |
c     real number variable
c

      implicit none

      integer        ierr, lerr, iunin, iunout, r0b1w2
      real*8         rvar, rdvar

      ARNIROT_LAUNCH ( "Launching rwreal." )

      lerr = 0
      call rwlins(4, iunin, iunout, lerr)
      if (lerr.eq.0) then
         lerr = 1
c        input new value of real number variable
         read(iunin, *, end=999, err=999) rdvar
c        if read only, equate this value to rvar, else reject it
         if (r0b1w2.eq.0) rvar = rdvar
c        output delivered or input value if output unit specified
         if (iunout.ne.0) write(iunout,*) rvar
         lerr = 0
      end if
  999 ierr = ierr + lerr

      return
      end


c------------------------------------------------------------------------------
      subroutine rwchar( char, iunin, iunout, r0b1w2, ierr )
c     read (and possibly write) a string variable in an input field of the following form
c
c     blank line
c     |
c     variable descriptor
c     |
c     character*(*) variable
c

      implicit none

      integer        ierr, lerr, iunin, iunout, r0b1w2
      integer        strlen
      character*250  char, line

      ARNIROT_LAUNCH ( "Launching rwchar." )

      lerr = 0
      call rwlins(4, iunin, iunout, lerr)
      if (lerr.eq.0) then
         lerr = 1
c        input new value of string variable
         read(iunin, *, end=999, err=999) line
c        if read only, equate this string to char, else reject it
         if (r0b1w2.eq.0) char = line
c        output delivered or input string if output unit specified
         if (iunout.ne.0) write(iunout,'(a)') char(1:strlen(char))
         lerr = 0
      end if
  999 ierr = ierr + lerr

      return
      end
