/***************************************************************************
                          kstack.cpp  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstack.h"
#include "kelement.h"
#include "kscalar.h"
#include <math.h>
#include <iostream.h>

KStack::KStack(){
//	baseElement = new KElement();
	baseElement = '\0';
	currentElement = '\0';
	stackHeight = 0;
}
KStack::KStack(KStack& newStack){
	KElement * currentElement;
	baseElement = '\0';
  currentElement = '\0';
	stackHeight = 0;
	currentElement = newStack.getBase();
	while(currentElement != '\0') {
		pushCopy(currentElement);
		currentElement = currentElement->getPrevious();
	}	
}
KStack::~KStack(){
	clear();
	delete baseElement;
	baseElement = '\0';
}

//Stack Functions
void KStack::swap(){
	KElement * tempElement0;
	KElement * tempElement1;
	tempElement0 = baseElement;
	hop();
	tempElement1 = baseElement;
	hop();
	push(tempElement0);
	push(tempElement1);
}
void KStack::hop(){
	baseElement = baseElement->getPrevious();
	stackHeight--;
}
void KStack::pop(){
	KElement * tempElement;
	tempElement = baseElement;
	hop();
	delete tempElement;
}
void KStack::push(KElement * newElement){
	newElement->setPrevious(baseElement);
	baseElement = newElement;
	stackHeight++;
}
void KStack::pushCopy(KElement * anElement){
	KElement * newElement;
	newElement = new KElement(*anElement);
	newElement->setPrevious(baseElement);
	baseElement = newElement;
	stackHeight++;
}
void KStack::clear(){
	while (baseElement != '\0') {
		pop();
	}
}
void KStack::roll(int top){
	KStack * tempStackA;
	KElement * rollElement;
	tempStackA=new KStack();
	for (int i=0;i<=top;i++){
		tempStackA->pushCopy(baseElement);
		pop();
	}
	rollElement = tempStackA->baseElement;
	tempStackA->hop();
	for (int i=0;i<top;i++){
		pushCopy(tempStackA->getBase());
		tempStackA->pop();
	}
	pushCopy(rollElement);
	delete rollElement;
	delete tempStackA;
}
void KStack::flip(int top){
	KStack * tempStackA;
	KStack * tempStackB;
	tempStackA=new KStack();
	for (int i=0;i<=top;i++){
		tempStackA->pushCopy(getBase());
 		pop();
	}
	tempStackB=new KStack();
	for (int i=0;i<=top;i++){
		tempStackB->pushCopy(tempStackA->getBase());
		tempStackA->pop();
	}
	for (int i=0;i<=top;i++){
		pushCopy(tempStackB->getBase());
		tempStackB->pop();
	}
	delete tempStackA;
	delete tempStackB;
}
void KStack::floate(int element){
	KStack * tempStackA;
 	tempStackA=new KStack();       					//Load temporary stack with elements until
	for (int i=0;i<=element+1;i++){         //element above the selected element
		tempStackA->pushCopy(getBase());          //is the base element
 		hop();
	}
 	tempStackA->swap(); 										//Put the selected element on top
	for (int i=0;i<=element+1;i++){					//Reload the stack from the temporary stack.
		pushCopy(tempStackA->getBase());
		tempStackA->hop();
	}
	delete tempStackA;
}
void KStack::sink(int element){
	KStack * tempStackA;
	tempStackA=new KStack();
	for (int i=0;i<=element;i++){
		tempStackA->pushCopy(getBase());
 		pop();
	}
	tempStackA->swap();
	for (int i=0;i<=element;i++){
		pushCopy(tempStackA->getBase());
		tempStackA->pop();
	}
	delete tempStackA;
}
void KStack::add(){
	baseElement->getPrevious()->add(*baseElement);								
	pop();
}
void KStack::subtract(){
	baseElement->getPrevious()->subtract(*baseElement);
	pop();
}
void KStack::multiply(){
	baseElement->getPrevious()->multiply(*baseElement);
	pop();
}
void KStack::divide(){
	baseElement->getPrevious()->divide(*baseElement);
	pop();
}
void KStack::power(){
	baseElement->getPrevious()->power(*baseElement);
	pop();
}
void KStack::root(){
	baseElement->getPrevious()->root(*baseElement);
	pop();
}
void KStack::modulous(){
	baseElement->getPrevious()->modulous(*baseElement);
	pop();
}
void KStack::AND(){
	baseElement->getPrevious()->AND(*baseElement);	
	pop();
}
void KStack::OR(){
	baseElement->getPrevious()->OR(*baseElement);
	pop();
}
void KStack::negate(){
  baseElement->negate();
}
void KStack::inverse(){
  baseElement->inverse();
}
void KStack::compliment(){
 	baseElement->compliment();
}
void KStack::sine(int unit=0){
  baseElement->sine(unit);
}
void KStack::cosine(int unit=0){
  baseElement->cosine(unit);
}
void KStack::tangent(int unit=0){
  baseElement->tangent(unit);
}
void KStack::hypSine(){
  baseElement->hypSine();
}
void KStack::hypCosine(){
  baseElement->hypCosine();
}
void KStack::hypTangent(){
  baseElement->hypTangent();
}
void KStack::arcsine(int unit=0){
  baseElement->arcsine(unit);
}
void KStack::arccosine(int unit=0){
  baseElement->arccosine(unit);
}
void KStack::arctangent(int unit=0){
  baseElement->arctangent(unit);
}
void KStack::hypArcsine(){
  baseElement->hypArcsine();
}
void KStack::hypArccosine(){
  baseElement->hypArccosine();
}
void KStack::hypArctangent(){
  baseElement->hypArctangent();
}
void KStack::ln(){
  baseElement->ln();
}	
void KStack::log10(){
  baseElement->log10();
}
void KStack::ten2X(){
  baseElement->ten2X();
}
void KStack::e2X(){
  baseElement->e2X();
}	
void KStack::factorial(){
  baseElement->factorial();
}

KElement * KStack::getBase(){
	return baseElement;
}
