#include <stdlib.h>

#include "ws_insertrow.h"



// ****************************  new Rows Widget  *****************************


insertRowWidget::insertRowWidget (QWidget*, const char* name)
  : QDialog (0, name, TRUE)
  {  
    setFixedSize (300, 200);

    if (strcmp (name, "Insert") == 0) setCaption ("Insert new Rows");
    else setCaption ("Append new Rows");
    
    numberOf = new QLineEdit (this);
    numberOf->setText ("1");
    numberOf->setGeometry (100, 50, 90, 25);

    ok = new QPushButton ("Ok", this);
    ok->setGeometry (60, 160, 90, 25);
    ok->setDefault (TRUE);

    cancel = new QPushButton ("Cancel", this);
    cancel->setGeometry (180, 160, 90, 25);
    
    connect (ok, SIGNAL (clicked()), SLOT (accept()));
    connect (cancel, SIGNAL (clicked ()), SLOT (reject()));
    connect (numberOf, SIGNAL (returnPressed ()), SLOT (accept ()));

    numberOf->setFocus ();
  }


insertRowWidget::~insertRowWidget ()
  {
    delete ok;
    delete cancel;
    delete numberOf;
  }


int insertRowWidget::getNumberToInsert ()
  {
    return ( atoi ( numberOf->text () ) );
  }

