/*
  
  The KOrigin Page Widget
  -----------------------

  " This was the wrong thing to do,
    This was the wrong one to be doing.
    This was the road to destiny,
    This was the way to our ruin. "

  (Megadeth, This Was My Life, from the album Countdown to Extinction)

  (C) 1997,98 Patrick Schemitz.
  KOrigin (C) 1997,98 Patrick Schemtz, Martin Hfner.

  History:
  97/11/09  Getting started.
  97/11/12  Started KDNDWidget.
  97/11/22  Moving plots works!
  97/11/23  Resizing plots works!
  98/01/14  Reorganized menus and responsibilities.
  98/01/28  New mouse mode: touch-plot

  TODO: (in dieser Reihenfolge :-)
        - Options-Dialog(e) schreiben
		- Skalierung fr Drucker implementieren
		- Text-Klasse implementieren
  
*/


#include "page.h"
#include "page.moc"
#include "pg_options.h"
#include "pg_info.h"
#include "centre.h"

#include <stdio.h>
#include <iostream.h>
#include <signal.h>
#include <qprinter.h>
#include <qcursor.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qmlined.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <kiconloader.h>
#include <kapp.h>

#include "debug.h"



Page* activePage = 0;


int Page::the_mouseMode = Page::MoveMode;

QColor* Page::defaultColor = 0;

double Page::defaultWidth  = 20.0;
double Page::defaultHeight = 29.5;

int Page::pageNumber = 0;


QList<Page>& Page::list ()
{
  static QList<Page> the_page_list;
  return the_page_list;
}


Page::Page (double width=0.0, double height=0.0, QWidget* parent = 0,
			const char* name = 0)
  : KDNDWidget(parent,name)
{
  IFDEBUG("korigin.page",4)
	cout << "Page::Page() starts." << endl;
  ENDDEBUG;

  if (pageNumber == 0)
	loadDefaults(KApplication::getKApplication()->getConfig());

  if (width == 0.0 || height == 0.0)
	{
	  cm_width = defaultWidth;
	  cm_height = defaultHeight;
	}
  else
	{
	  cm_width = width;
	  cm_height = height;
	}
  the_background = QColor(*defaultColor);

  pageNumber++;

  QString title;
  title.sprintf("Page #%i",pageNumber);
  setCaption(title);
  setBackgroundColor(the_background);
  resize(400,564);

  active_icon = new QPixmap(
    KApplication::getKApplication()->getIconLoader()->loadIcon("page-a.xpm"));
  inactive_icon = new QPixmap(
	KApplication::getKApplication()->getIconLoader()->loadIcon("page-i.xpm"));

  the_treeitem = new TreeItem();
  the_treeitem->setPixmap(icon());
  the_treeitem->setText(caption());
  the_treeitem->setObject(this);

  resizing = false;
  objectList.setAutoDelete(true);
  notes = new char [2048];
  notes[0] = 0;

  IFDEBUG("korigin.page",3)
	cout << "Page::Page() build menu..." << endl;
  ENDDEBUG;

  the_menu = menu(0);

  dropZone = new KDNDDropZone(this,DndText);
  connect(dropZone,SIGNAL(dropAction(KDNDDropZone*)),
  		  SLOT(slotDropped(KDNDDropZone*)));

  IFDEBUG("korigin.page",4)
	cout << "Page::Page() ends." << endl;
  ENDDEBUG;
}


Page::~Page ()
{
  IFDEBUG("korigin.page",4)
	cout << "Page::~Page() starts." << endl;
  ENDDEBUG;

  if (activePage == this) activePage = 0;

  objectList.setAutoDelete(true);
  objectList.clear();

  delete dropZone;
  delete the_menu;
  delete [] notes;

  if (the_treeitem && the_treeitem->getParent())
  	the_treeitem->getParent()->removeChild(the_treeitem);
  delete the_treeitem;

  emit treeItemChanged();

  IFDEBUG("korigin.page",4)
	cout << "Page::~Page() ends." << endl;
  ENDDEBUG;
}


void Page::loadDefaults (KConfig* conf)
{
  bool ok;
  double number;

  if (conf == 0)
	conf = KApplication::getKApplication()->getConfig();

  IFDEBUG("korigin.page",3)
	cout << "Page::loadDefaults() loading configuration..." << endl;
  ENDDEBUG;

  conf->setGroup("Page");
  if (strcmp("Page",conf->group()) == 0)
	{
	  IFDEBUG("korigin.page",3)
		cout << "  section [Page] found." << endl;
	  ENDDEBUG;

	  defaultColor = new QColor(conf->readColorEntry("background",&white));
	  number = conf->readEntry("width","glunz!").toDouble(&ok);
	  if (ok) defaultWidth = number;
	  number = conf->readEntry("height","glunz!").toDouble(&ok);
	  if (ok) defaultHeight = number;
	} 
  else 
	{
	  IFDEBUG("korigin.page",3)
		cout << "  section [Page] not found. Using built-in." << endl;
	  ENDDEBUG;

	  defaultColor = new QColor(white);
	}
}


void Page::storeDefaults (KConfig* conf)
{
  char buffer [128];

  if (conf == 0)
	conf = KApplication::getKApplication()->getConfig();

  IFDEBUG("korigin.page",3)
	cout << "Page::storeDefaults() storing configuration..." << endl;
  ENDDEBUG;

  conf->setGroup("Page");
  if (strcmp("Page",conf->group()) == 0)
	{
	  IFDEBUG("korigin.page",3)
		cout << "  section [Page] found." << endl;
	  ENDDEBUG;
	  
	  conf->writeEntry("background",*defaultColor);
	  sprintf(buffer,"%.2f",defaultWidth);
	  conf->writeEntry("width",buffer);
	  sprintf(buffer,"%.2f",defaultHeight);
	  conf->writeEntry("height",buffer);
	  conf->sync();
	}
  else
	{
	  IFDEBUG("korigin.page",1)
		cout << "  section [Page] not found, config not saved." << endl;
	  ENDDEBUG;
	  QMessageBox::critical(0,"Cant save options",
							"Could not save the default values for pages:\n"\
							"page format and color not stored.\n"\
							"Your configuration file has no [Page] section.");
	}
}


void Page::restoreOptions (KConfig* conf)
{
  loadDefaults(conf);
}


void Page::storeOptions (KConfig* conf)
{
  storeDefaults(conf);
}


QPopupMenu* Page::buildPlotMenu ()
{
  IFDEBUG("korigin.page",4)
	cout << "Page::buildPlotMenu() starts." << endl;
  ENDDEBUG;

  Plot* iter;
  QPopupMenu* newPlot = new QPopupMenu();
  for (iter=Plots().first(); iter!=0; iter=Plots().next())
	newPlot->insertItem(iter->name());
  connect(newPlot,SIGNAL(activated(int)),SLOT(slotNewPlot(int)));

  IFDEBUG("korigin.page",4)
	cout << "Page::buildPlotMenu() ends." << endl;
  ENDDEBUG;

  return newPlot;
}


QPopupMenu* Page::menu (QPopupMenu* predefined)
{
  QPopupMenu* menue;
  if (predefined != 0) {
	menue = predefined;
	menue->clear();
  } else {
	menue = new QPopupMenu();
  }
  menue->insertItem("New plot", buildPlotMenu());
  menue->insertSeparator();
  menue->insertItem("Page info", this, SLOT(pageInfoDialog()));
  menue->insertItem("Page settings", this, SLOT(optionsDialog()));
  menue->insertItem("Save layout", this, SLOT(saveLayout()));
  return menue;
}


void Page::slotNewPlot (int id)
{
  IFDEBUG("korigin.page",4)
	cout << "Page::slotNewPlot() starts." << endl;
  ENDDEBUG;

  Plot* prototype = Plots().at(id);
  if (prototype) make_plot(prototype,false);

  IFDEBUG("korigin.page",4)
	cout << "Page::slotNewPlot() ends." << endl;
  ENDDEBUG;
}


void Page::activate ()
{
  if (the_treeitem)
	the_treeitem->setPixmap(active_icon);
}


void Page::deactivate ()
{
  if (the_treeitem)
	the_treeitem->setPixmap(inactive_icon);
}


QPixmap* Page::icon ()
{
  if (activePage == this)
	return active_icon;
  else
	return inactive_icon;
}


TreeItem* Page::treeitem ()
{
  the_treeitem->setPixmap(icon());
  return the_treeitem;
}


int Page::mouseMode ()
{
  return the_mouseMode;
}


void Page::setMouseMode (int newMode)
{
  switch(newMode) {
  case MoveMode :
  case PlotMode :
  case TextMode :
	the_mouseMode = newMode;
	return;
  }
  IFDEBUG("korigin.page",1)
	cout << "Page::setMouseMode(): Oooops, a mouse mode " << newMode 
		 << " does not exist for pages. This is a bug!" << endl;
  ENDDEBUG;
}


void Page::make_plot (Plot* prototype, bool fill)
{
  IFDEBUG("korigin.page",4)
	cout << "Page::make_plot() starts." << endl;
  ENDDEBUG;

  Plot* newplot;

  newplot = prototype->clone();
  if (!newplot)
	return;
  newplot->instantiate(this);
  connect(newplot,SIGNAL(changedTreeItem()),
		  this,SLOT(pageObjectChanged()));

  if (activePage != this)
	emit activePageChanged(this);

  newplot->widget()->resize(1000,1000);

  objectList.append(newplot);

  emit addTreeChild(the_treeitem,newplot->treeitem());
  emit activePlotChanged(newplot);
  emit treeItemChanged();

  if (fill)
	newplot->plotSelectedColumns();
  newplot->widget()->update();

  repaint();

  IFDEBUG("korigin.page",4)
	cout << "Page::make_plot() ends." << endl;
  ENDDEBUG;
}


void Page::remove_object (PageObject* obj)
{
  char msg [1024];
  if (obj == 0) return;
  if (objectList.remove(obj) == false) {
	sprintf(msg,"The following object was not\nfound on this page:\n %s",
			obj->className());
	QMessageBox::information(0,"Could not delete",msg);
  } else {
	repaint();
  }
}


void Page::enterEvent (QEvent*)
{
  switch(the_mouseMode) {
  case MoveMode :
	setCursor(arrowCursor);
	break;
  case PlotMode :
	setCursor(crossCursor);
	break;
  case TextMode :
	setCursor(ibeamCursor);
	break;
  }
}


void Page::pageObjectChanged ()
{
  emit treeItemChanged();
}


void Page::getScaleFactors (double& xf, double& yf)
{
  IFDEBUG("korigin.page",4)
	cout << "Page::getScaleFactors() starts." << endl;
  ENDDEBUG;

  double tmp1, tmp2, tmp3;
  tmp1 = width();
  tmp2 = cm_width;
  tmp3 = (tmp2/2.54*300.0)/tmp1;
  xf = tmp3;
  yf = (cm_height/2.54*300.0)/height();

  IFDEBUG("korigin.page",4)
	cout << "Page::getScaleFactors() ends." << endl;
  ENDDEBUG;
}


PageObject* Page::identifyObject (QPoint p)
{
  int i;
  double xf, yf;
  QPoint logical_pos;
  QRect area;
  PageObject* iter;

  getScaleFactors(xf,yf);
  logical_pos = QPoint(int(xf*p.x()),int(yf*p.y()));

  IFDEBUG("korigin.page",3)
	cout << "Page::identifyObject():" << endl
		 << "   scale factors = " << xf << ", " << yf << endl
		 << "   pos within window = " << p.x() << ", " << p.y() << endl
		 << "   logical position = " 
		 << logical_pos.x() << ", " << logical_pos.y() << endl;
  ENDDEBUG;

  for (iter=objectList.first(), i=0; iter!=0; iter=objectList.next(), i++)
	{
	  area = iter->virtual_area();

	  IFDEBUG("korigin.page",3)
		cout << "   * obj. #" << i << " (" << iter->className() 
			 << ") coordinate transformation:" << endl
			 << "     area = " << area.left() << ", " << area.top()
			 << ", " << area.right() << ", " << area.bottom() << endl;
	  ENDDEBUG;

	  if (area.contains(logical_pos))
		{
		  IFDEBUG("korigin.page",3)
			cout << "     *** match ***" << endl;
		  ENDDEBUG;
		  return iter;
		}
	}

  IFDEBUG("korigin.page",2)
	cout << "Page::identifyObject(): there *is* nothing, Captain." << endl;
  ENDDEBUG;
  return 0;
}


void Page::paint (QPainter* p, bool corner)
{
  int i;
  PageObject* iter;
  int pixx, pixy;
  float sx, sy;
  double scale_x, scale_y;
  QRect area, tip;

  corner = true; // for debugging only! TODO 
  getScaleFactors(scale_x,scale_y);
  pixx = int(width()*scale_x);
  pixy = int(height()*scale_y);

  IFDEBUG("korigin.page",3)
	cout << "Page::paint() parameters:" << endl
		 << "   virtual  size = " << pixx << " x " << pixy << endl
		 << "   physical size = " << width() << " x " << height() << endl
		 << "   scale factor  = " << scale_x << " x " << scale_y << endl;
  ENDDEBUG;

  p->setBackgroundColor(the_background);
  p->setWindow(0,0,pixx,pixy);
  p->setViewport(0,0,width(),height());

  for (iter=objectList.first(), i=0; iter!=0; iter=objectList.next(), i++)
	{
	  if (!(iter->inherits("PageObject"))) {
		cout << "Page::paint() found The Thing That Should Not Be!" << endl;
		cout << "There is a " << iter->className() << " in the list "
			 << "of page objects. Skipped." << endl;
		continue;
	  }
	  IFDEBUG("korigin.page",3)
		cout << "   Obj. number " << i << " ("
			 << iter->className() << ") paint..." << endl;
	  ENDDEBUG;

	  iter->position(sx,sy);
	  if (corner)
		{
		  area = iter->virtual_area();
		  tip = QRect(QPoint(area.right()-int(10*scale_x),
							 area.bottom()-int(10*scale_y)),
					  QPoint(area.right(),area.bottom()));
		  p->setBrush(black);
		  p->drawRect(tip);
		  p->setBrush(NoBrush);
		}
	  p->translate(sx,sy);
	  iter->paint(p);
	  p->translate(-sx,-sy);
	}

  IFDEBUG("korigin.page",4)
	cout << "Page::paint() ends." << endl;
  ENDDEBUG;
}


void Page::paintPage ()
{
  QPainter p;
  p.begin(this);
  p.setBackgroundColor(the_background);
  paint(&p);
  p.end();
}


void Page::printPage ()
{
  IFDEBUG("korigin.page",4)
	cout << "Page::printPage() starts." << endl;
  ENDDEBUG;

  double scale_x, scale_y;
  int pixx, pixy;
  QPrinter prn;

  if (prn.setup(0) == true)
	{
	  QPainter p;

	  IFDEBUG("korigin.page",3)
		cout << "Page::printPage() Es wird ernst!" << endl;
	  ENDDEBUG;

	  getScaleFactors(scale_x,scale_y);
	  pixx = int(width()*scale_x);
	  pixy = int(height()*scale_y);
	  p.begin(&prn);
	  // debug! p.setWindow(0,0,pixx,pixy);
	  // debug! p.setViewport(0,0,width(),height());
	  paint(&p);
	  p.end();
	}
  IFDEBUG("korigin.page",4)
	cout << "Page::printPage() ends." << endl;
  ENDDEBUG;
}


void Page::paintEvent (QPaintEvent*)
{
  paintPage();
}


void Page::resizeEvent (QResizeEvent* re)
{
  if (re->oldSize() == re->size())
	return;

  double ratio = cm_width / cm_height;
  int adjusted_width = int(ratio * re->size().height());
  int adjusted_height = int(re->size().width() / ratio);

  IFDEBUG("korigin.page",3)
	cout << "Page::resizeEvent() --" << endl
		 << "   size ratio = " << ratio << " (inverse = " << 1.0/ratio << ")"
		 << endl << "   proposed size: " 
		 << re->size().width() << " x " << re->size().height() << endl;
  ENDDEBUG;

  if (adjusted_width <= re->size().width())
	{
	  IFDEBUG("korigin.page",3)
		cout << "   actual size: " << adjusted_width << " x " 
			 << re->size().height() << " (width adjusted)" << endl;
	  ENDDEBUG;
	  resize(adjusted_width,re->size().height());
	}
  else
	{
	  IFDEBUG("korigin.page",3)
		cout << "   actual size: " << re->size().width() << " x " 
			 << adjusted_height << " (height adjusted)" << endl;
	  ENDDEBUG;
	  resize(re->size().width(),adjusted_height);
	}
}


void Page::mousePressEvent (QMouseEvent* me)
{
  static QMouseEvent mouse_event (*me);

  PageObject* what;
  QPoint global_pos, obj_pos;
  global_pos = mapToGlobal(me->pos());
  char buffer [1024];

  pressed = false;

  if (activePage != this)
	emit activePageChanged(this);

  switch(the_mouseMode) {

  case MoveMode :
	IFDEBUG("korigin.page",3)
	  cout << "Page::mousePressEvent(): Page is in move mode." << endl;
	ENDDEBUG;
	if (me->button() == RightButton)
	  {
		what = identifyObject(me->pos());
		if (what == 0)
		  {
			the_menu->popup(me->pos()+pos());
		  }
		else
		  {
			if (what->object()->inherits("Plot"))
			  emit activePlotChanged((Plot*)(what->object()));

			obj_pos = global_pos - what->widget()->pos();
		
			IFDEBUG("korigin.page",3)
			  cout << "   passing on mouse event..." << endl
				   << "   coords within object are: " << obj_pos.x() << ", "
				   << obj_pos.y() << endl;
			ENDDEBUG;

			mouse_event = QMouseEvent(Event_MouseButtonPress,
									  obj_pos,me->button(),
									  me->state());
			what->mousePressEvent(&mouse_event);
		  }
	  }
	else if (me->button() == LeftButton)
	  {
		pressed = true;
	  }
	break;

  case PlotMode :

	what = identifyObject(me->pos());
	if (what == 0) break;
	if (!what->object()->inherits("Plot")) {
	  if (KCentre::IlikeWindows) {
		sprintf(buffer,
				"Youre currently in Plot mouse mode, so you\n"\
				"can only click on Plots. What you clicked on\n"\
				"was a %s. Use the toolbar icons to\n"\
				"change the mouse mode.",what->className());
		QMessageBox::information(0,"This was not a Plot",buffer);
	  }
	  break;
	}

	emit activePlotChanged((Plot*)(what->object()));

	obj_pos = global_pos - what->widget()->pos();
		
	IFDEBUG("korigin.page",3)
	  cout << "   passing on mouse event..." << endl
		   << "   coords within object are: " << obj_pos.x() << ", "
		   << obj_pos.y() << endl;
	ENDDEBUG;

	mouse_event = QMouseEvent(Event_MouseButtonPress,
							  obj_pos,me->button(),
							  me->state());
	what->mousePressEvent(&mouse_event);
	break;

  case TextMode :

	QMessageBox::information(0,"Text Mode Not Available",
							 "We are terribly sorry but must tell you that\n"\
							 "the text objects are not yet implemented.\n"
							 "Again, we apologize :-)");
	break;
  }
}


void Page::startObjectDND (QMouseEvent* _mouse, PageObject* object)
{
  float x, y;
  double xfactor, yfactor;
  int pixx, pixy;
  int dx, dy;
  int object_w, object_h;
  QString data;
  QPixmap pixmap;
  QPoint p;
  QPainter painter;

  IFDEBUG("korigin.page",3)
	cout << "Page::startObjectDND() starts." << endl;
  ENDDEBUG;

  p = _mouse->pos();

  getScaleFactors(xfactor,yfactor);
  object->position(x,y);
  pixx = int(width()*xfactor);
  pixy = int(height()*yfactor);
  dx = int(x/xfactor) - p.x();
  dy = int(y/yfactor) - p.y();

  IFDEBUG("korigin.page",4)
	cout << "Page::startObjectDND()" << endl
		 << "   pixels x/y = " << pixx << ", " << pixy << endl
		 << "   delta  x/y = " << dx << ", " << dy << endl;
  ENDDEBUG;

  p = mapToGlobal(_mouse->pos());

  data.sprintf("%i %i %u",dx,dy,uint(object));
  object_w = int(object->widget()->width()/xfactor);
  object_h = int(object->widget()->height()/yfactor);

  pixmap = QPixmap(object_w,object_h);
  pixmap.fill(backgroundColor());
  painter.begin(&pixmap);
  painter.drawRect(0,0,object_w,object_h);
  painter.drawLine(0,0,object_w,object_h);
  painter.drawLine(0,object_h,object_w,0);
  painter.end();
  
  IFDEBUG("korigin",2)
	cout << "   starting drag of "<< object->className() <<" ..." << endl;
  ENDDEBUG;

  startDrag(new KDNDIcon(pixmap,p.x()+dx,p.y()+dy),data.data(),data.length(),
			DndText,dx,dy);

  IFDEBUG("korigin.page",3)
	cout << "   drag started." << endl;
  ENDDEBUG;
}


void Page::startObjectResize (QMouseEvent* _mouse, PageObject* object)
{
  IFDEBUG("korigin.page",3)
	cout << "Page::startObjectResize()" << endl;
  ENDDEBUG;
  resizing = true;
  obj_being_resized = object;
  resizeX0 = _mouse->x();
  resizeY0 = _mouse->y();
  resizeW0 = object->widget()->width();
  resizeH0 = object->widget()->height();
}


void Page::duringObjectResize (QMouseEvent* _mouse)
{
  int newWidth, newHeight;
  float x, y;
  double xf, yf;

  IFDEBUG("korigin.page",3)
	cout << "Page::duringObjectResize() delta = "
		 << int((_mouse->x()-resizeX0)) << ", " 
		 << int((_mouse->y()-resizeY0)) << endl;
  ENDDEBUG;

  getScaleFactors(xf,yf);
  newWidth = resizeW0
	+ int(xf*(_mouse->x()-resizeX0));
  newHeight = resizeH0
	+ int(yf*(_mouse->y()-resizeY0));

  if (newHeight<200 || newWidth<200)
	{
	  IFDEBUG("korigin.page",1)
		cout << "You can't make the object smaller than it is now. Sorry." 
			 << endl;
	  ENDDEBUG;
	  return;
	}
  obj_being_resized->position(x,y);
  if (newWidth+x >= xf*width() ||
	  newHeight+y >= yf*height())
	{
	  IFDEBUG("korigin.page",1)
		cout << "You can't make the plot bigger than it is now. Sorry." 
			 << endl;
	  ENDDEBUG;
	  return;
	}

  obj_being_resized->widget()->resize(newWidth,newHeight);
  repaint();
}


void Page::stopObjectResize ()
{
  IFDEBUG("korigin.page",3)
	cout << "Page::stopObjectResize()" << endl;
  ENDDEBUG;
  resizing = false;
}


void Page::dndMouseMoveEvent (QMouseEvent* _mouse)
{
  QPoint p;
  QRect tip, area;
  PageObject* obj;

  if (!pressed) return;

  if (resizing)
	{
	  duringObjectResize(_mouse);
	  return;
	}

  p = _mouse->pos();
  obj = identifyObject(p);
  if (obj == 0) return;

  IFDEBUG("korigin.page",4)
	cout << "Page::dndMouseMoveEvent(): object (void*)"
		 << (void*)obj << endl;
  ENDDEBUG;

  //
  // Check whether it is a resize action or move action:
  //
  area = obj->pixel_area();
  tip = QRect(QPoint(area.right()-10,area.bottom()-10),
			  QPoint(area.right()+2,area.bottom()+2));

  if (tip.contains(p))
	startObjectResize(_mouse,obj);
  else
	startObjectDND(_mouse,obj);
}


void Page::dndMouseReleaseEvent (QMouseEvent*)
{
  pressed = false;
  if (resizing) stopObjectResize();
  resizing = false;
  obj_being_resized = 0;
}

void Page::slotDropped (KDNDDropZone* rainDrop)
{
  bool isUint;
  int dx, dy;
  uint objAsUint;
  double xf, yf;
  QString data;
  PageObject* object;
  int x, y;
  QPoint real_pos, logical_pos;

  IFDEBUG("korigin.page",2)
	cout << "Page::slotDropped() starts." << endl;
  ENDDEBUG;

  getScaleFactors(xf,yf);
  x = rainDrop->getMouseX();
  y = rainDrop->getMouseY();
  real_pos = QPoint(x,y) - geometry().topLeft();
  logical_pos = QPoint(int(xf*real_pos.x()),int(yf*real_pos.y()));

  IFDEBUG("korigin.page",3)
	cout << "   rain drop at (" << x << ", " << y << ") "
		 << rainDrop->getData() << endl
		 << "   real pos = " << real_pos.x() << ", " << real_pos.y() << endl
		 << "   logical pos = " << int(xf*real_pos.x()) << ", "
		 << int(yf*real_pos.y()) << endl;
  ENDDEBUG;

  data = rainDrop->getData();
  isUint = (sscanf(data.data(),"%i %i %u", &dx, &dy, &objAsUint) == 3);
  if (isUint)
	{
	  IFDEBUG("korigin.page",3)
		cout << "   object = (void*)" << (void*)objAsUint 
			 << " with dx, dy = " << dx << ", " << dy << endl;
	  ENDDEBUG;

	  object = (PageObject*)objAsUint;

	  if (object->page() != this)
		{
		  IFDEBUG("korigin.page",1)
			cout << "Cannot do trans-page drags yet, sorry." << endl;
		  ENDDEBUG;
		  return;
		}

	  IFDEBUG("korigin.page",3)
		cout << "   moving object " << object->className() << endl;
	  ENDDEBUG;

	  object->setPosition(logical_pos.x()+xf*dx,logical_pos.y()+yf*dy);

	  if (object->inherits("Plot"))
		emit activePlotChanged((Plot*)object);
	  repaint();
	  return;
	}
  else
	{
	  IFDEBUG("korigin.page",1)
		cout << "Only plots and text can be dropped on pages!" << endl;
	  ENDDEBUG;
	}
}


void Page::slotDummy ()
{
  QMessageBox::information(0,"Unimplemented!",
						   "Whatever you tried to do, its\nnot "\
						   "implemented yet.");
}


void Page::pageInfoDialog ()
{
  QDialog* dialog = new PageInfoDialog(this);
  dialog->exec();
  delete dialog;
}


void Page::optionsDialog ()
{
  double old_w, old_h;
  old_w = cm_width;
  old_h = cm_height;
  QDialog* dialog = new PageOptionsDialog(this);
  dialog->exec();
  delete dialog;
  setBackgroundColor(the_background);
  if (old_h != cm_height || old_w != cm_width)
	resize(width()-1,height()-1);
  repaint();
}


const char* Page::start_mark ()
{
  return "<page>\n";
}


const char* Page::end_mark ()
{
  return "</page>\n";
}


void Page::savePageSettings (QFile& file)
{
  char buffer [128];

  sprintf(buffer,"%s\n",caption());
  file.writeBlock(buffer,strlen(buffer));
  sprintf(buffer,"%.2f %.2f\n",cm_width,cm_height);
  file.writeBlock(buffer,strlen(buffer));
  sprintf(buffer,"%i %i %i\n",the_background.red(),the_background.green(),
		  the_background.blue());
  file.writeBlock(buffer,strlen(buffer));
  file.writeBlock("<notes>\n",strlen("<notes>\n"));
  file.writeBlock(notes,strlen(notes));
  file.writeBlock("\n</notes>\n",strlen("\n</notes>\n"));
}


Page* Page::loadPageSettings (QFile& file)
{
  Page* page;
  char name [128];
  char buffer [128];
  char notes [2048];
  double w, h;
  int r, g, b;

  file.readLine(buffer,126);
  if (file.atEnd()) return 0;
  strcpy(name,buffer);
  while (name[strlen(name)-1] == 10) name[strlen(name)-1] = 0;
  file.readLine(buffer,126);
  if (file.atEnd()) return 0;
  if (sscanf(buffer,"%lf %lf",&w,&h) != 2) {
	IFDEBUG("korigin.page",1)
	  cout << "Page file format failure: width, height not matched." << endl;
	ENDDEBUG;
	return 0;
  }
  file.readLine(buffer,126);
  if (sscanf(buffer,"%i %i %i",&r,&g,&b) != 3) {
	IFDEBUG("korigin.page",1)
	  cout << "Page file format failure: RGB not matched." << endl;
	ENDDEBUG;
	return 0;
  }
  notes[0] = 0;
  file.readLine(buffer,126);
  if (strcmp(buffer,"<notes>\n") == 0)
	{
	  file.readLine(buffer,126);
	  while (strcmp(buffer,"</notes>\n") != 0) 
		{
		  strcat(notes,buffer);
		  file.readLine(buffer,126);
		}
	  while (notes[strlen(notes)-1] == 10)
		notes[strlen(notes)-1] = 0;
	}

  page = new Page(w,h);
  page->setCaption(name);
  page->setBackgroundColor((page->the_background = QColor(r,g,b)));
  strcpy(page->notes,notes);
  return page;
}

void Page::savePageObjects (QFile& file, bool with_data)
{
  int i;
  PageObject* iter;

  for (iter=objectList.first(), i=0; iter!=0; iter=objectList.next(), i++)
	{
	  if (!(iter->inherits("PageObject"))) {
		IFDEBUG("korigin.page",1)
		  cout << "Page::saveLayout() found The Thing That Should Not Be!" 
			   << endl;
		ENDDEBUG;
		IFDEBUG("korigin.page",2)
		  cout << "There is a " << iter->className() << " in the list "
			   << "of page objects. Skipped." << endl;
		ENDDEBUG;
		continue;
	  }
	  IFDEBUG("korigin.page",3)
		cout << "   Obj. number " << i << " ("
			 << iter->className() << ") store..." << endl;
	  ENDDEBUG;
	  if (iter->inherits("Plot")) {
		((Plot*)iter)->store(file,with_data);
	  } else {
		iter->store(file);
	  }
	}
}

bool Page::loadPageObjects (QFile& file, bool with_data)
{
  char buffer [128];
  uint i;
  PageObject* po;
  Plot* plot;

  do 
	{
	  file.readLine(buffer,126);
	  if (strcmp(buffer,end_mark()) == 0) return true;
	  if (file.atEnd()) return false;
	  if (strlen(buffer) == 0) return false;

	  po = 0;
	  plot = 0;
	  //
	  // Plots can be identified by their prototypes.
	  //
	  for (i=0; i<Plots().count(); i++)
		if (strcmp(Plots().at(i)->start_mark(),buffer) == 0) {
		  IFDEBUG("korigin.page",3)
			cout << "restore: " << Plots().at(i)->start_mark() << endl;
		  ENDDEBUG;
		  plot = Plots().at(i)->clone();
		  plot->instantiate(this);
		  if ((plot->restore(file,with_data)) == true) {
			objectList.append(plot);
			emit addTreeChild(treeitem(),plot->treeitem());
		  } else
			delete plot;
		  break;
		}
	  if (plot == 0)
		{
		  //
		  // Non-plot PageObjects must be manually identified.
		  // 
		  if (strcmp(buffer,"<text>\n") == 0) {
			//
			// Sample code:
			//
			//po = new TextObject(this);
			//po->restore(file);
			//objectList.append(po);
			cout << "Text Widget not yet implemented." << endl;
		  }
		}
	  if (plot == 0 && po == 0)
		{
		  IFDEBUG("korigin.page",1)
			cout << "PageObject " << buffer << " unknown." << endl;
		  ENDDEBUG;
		  return false;
		}
	}
  while (!file.atEnd());
  return false;
}


void Page::saveLayout ()
{
  QString fileName;
  QString dir;
  bool accepted;
  KConfig* conf;
  char buffer [1024];

  conf = kapp->getConfig();
  conf->setGroup("Settings");
  if (strcmp(conf->group(),"Settings") == 0)
	dir = conf->readEntry("directory");

  do
	{
	  fileName = QFileDialog::getSaveFileName(dir,"*.kop");
	  if (fileName.isEmpty()) return;
	  if (QFile::exists(fileName)) {
		sprintf(buffer,"%s\nThis file already exists. Replace?",
				(const char*)fileName);
		accepted = (QMessageBox::warning(0,"Replace File?",
										 buffer,
										 "Yes","No",0,1) == 0);
	  } else
		accepted = true;
	}
  while (!accepted);
  
  QFile file (fileName);
  file.open(IO_WriteOnly);
  if (!QFileInfo(file).isWritable()) {
	QMessageBox::critical(0,"Save Layout Error",
						  "File is not writable!"\
						  "Are you nuts? Dare to"\
						  "give me a xr- file!!!");
	return;
  }
  file.writeBlock(start_mark(),strlen(start_mark()));
  savePageSettings(file);
  savePageObjects(file,false);
  file.writeBlock(end_mark(),strlen(end_mark()));
  file.close();
}


bool Page::store (QFile& file, bool with_obj)
{
  file.writeBlock(start_mark(),strlen(start_mark()));
  savePageSettings(file);
  if (with_obj)
	savePageObjects(file,true);
  file.writeBlock(end_mark(),strlen(end_mark()));
  return true;
}


Page* Page::restore_page (QFile& file)
{
  int pos;
  char buffer [128];
  Page* page;

  // load settings, check for error and file end.
  page = loadPageSettings(file);
  if (page == 0) return 0;
  if (file.atEnd()) return page;

  // check for empty page.
  pos = file.at();
  file.readLine(buffer,126);
  if (strcmp(buffer,end_mark()) != 0)
	file.at(pos);
  return page;
}


bool Page::restore_objects (QFile& file, bool with_obj)
{
  int pos;
  char buffer [128];

  pos = file.at();
  file.readLine(buffer,126);
  if (strcmp(buffer,end_mark()) == 0)
	return true;
  file.at(pos);

  return loadPageObjects(file,with_obj);
}
