#include <stdio.h>
#include <iostream.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qpainter.h>
#include <qslider.h>
#include <kcolorbtn.h>
#include <klocale.h>

//


#include "kpen.h"
#include "kpen.moc"


//
// I wont type myself to death! Im into Unix, not VMS!
//

//#define MSG(string) klocale->translate(string)
#define MSG(string) string


/*
 * The Qt PenStyles. Note that the constants names are not capitalized
 * in order to avoid name conflicts with Qts PenStyle.
 *
 */

static const int penStyles = 6;
static const char* penStyle [] =
{
  "no line",
  "solid",
  "dashed",
  "dotted",
  "dash-dot",
  "da-do-do"
};


/*
 * KPenDialog Implementation
 *
 */

QList<QPen> KPenDialog::the_recent;


KPenDialog::KPenDialog (QWidget* parent, const char* name, const char* title)
  : QDialog (parent,name,TRUE)
{
  int i;
  QPen* p;
  QPixmap* colorfield;
  QPainter paint;
  QLabel* label;

  setCaption(title);
  the_recent.setAutoDelete(TRUE);
  pixlist.setAutoDelete(TRUE);

  the_style = NoPen;
  the_width = 0;
  the_color = black;

  label = new QLabel(this,"label-style");
  label->setText(MSG("Line style:"));
  label->setGeometry(20,20,170,25);
  style_w = new QComboBox(this,"list-style");
  for (i=0; i<penStyles; i++)
	style_w->insertItem(penStyle[i]);
  style_w->setGeometry(200,20,150,25);
  connect(style_w,SIGNAL(highlighted(int)),SLOT(penChanged()));
  connect(style_w,SIGNAL(activated(int)),SLOT(penChanged()));
  QToolTip::add(style_w,MSG("Select line style"));

  label = new QLabel(this,"label-width");
  label->setText(MSG("Line width:"));
  label->setGeometry(20,55,170,25);
  width_w = new QSlider(0,10,1,0,QSlider::Horizontal,this,"slider-width");
  width_w->setSteps(1,1);
  width_w->setTickmarks(QSlider::Below);
  width_w->setGeometry(200,55,150,25);
  connect(width_w,SIGNAL(sliderMoved(int)),SLOT(penChanged()));
  connect(width_w,SIGNAL(valueChanged(int)),SLOT(penChanged()));
  QToolTip::add(width_w,MSG("Select line width"));

  label = new QLabel(this,"label-color");
  label->setText(MSG("Line color:"));
  label->setGeometry(20,90,170,25);
  color_w = new KColorButton(this,"colorbutton-color");
  color_w->setColor(black);
  color_w->setGeometry(200,90,50,25);
  connect(color_w,SIGNAL(changed(const QColor&)),SLOT(penChanged()));
  QToolTip::add(color_w,MSG("Select line color"));

  label = new QLabel(this,"label-recent");
  label->setText(MSG("Recent lines:"));
  label->setGeometry(20,125,170,25);
  recent_w = new QComboBox(this,"combo-recent");
  for (i=0; i<(int)the_recent.count(); i++) {
	p = the_recent.at(i);
	// The colorfiend pixmaps will be deleted by pixlists destructor,
	// implicitly called in ~KPenDialog(). No ressource leak here.
	colorfield = new QPixmap(115,18);
	colorfield->fill(p->color());
	paint.begin(colorfield);
	paint.drawText(0,0,110,18,AlignCenter,MSG(penstring(*p)));
	paint.end();
	recent_w->insertItem(*colorfield,i);
	pixlist.append(colorfield);
  }
  recent_w->setMaxCount(8);
  recent_w->setGeometry(200,125,150,25);
  connect(recent_w,SIGNAL(highlighted(int)),SLOT(clickedRecent(int)));
  connect(recent_w,SIGNAL(activated(int)),SLOT(clickedRecent(int)));
  QToolTip::add(recent_w,MSG("Select recent line"));

  example_w = new QLabel(this,"label_example");
  example_w->setText("");
  example_w->setGeometry(20,160,360,20);
  QToolTip::add(example_w,MSG("What you see is what you (might) get"));

  ok = new QPushButton(this,"button_ok");
  ok->setText(MSG("OK"));
  ok->setGeometry(30,210,90,25);
  ok->setAutoRepeat(FALSE);
  ok->setAutoResize(FALSE);
  ok->setDefault(TRUE);
  connect(ok,SIGNAL(clicked()),SLOT(clickedOK()));

  help = new QPushButton(this,"button_help");
  help->setText(MSG("Help"));
  help->setGeometry(150,210,90,25);
  help->setAutoRepeat(FALSE);
  help->setAutoResize(FALSE);
  connect(help,SIGNAL(clicked()),SLOT(clickedHelp()));

  cancel = new QPushButton(this,"button_cancel");
  cancel->setText(MSG("Cancel"));
  cancel->setGeometry(270,210,90,25);
  cancel->setAutoRepeat(FALSE);
  cancel->setAutoResize(FALSE);
  connect(cancel,SIGNAL(clicked()),SLOT(clickedCancel()));

  actualizeControls();

  setFixedSize(400,250);
}


KPenDialog::~KPenDialog ()
{
  delete example_w;
  delete recent_w;
  delete color_w;
  delete style_w;
  delete width_w;
  delete ok;
  delete help;
  delete cancel;
}


char* KPenDialog::penstring (const QPen& p)
{
  static char buffer [128];
  sprintf(buffer,"%s, %i pt.",penStyle[(int)(p.style())],p.width());
  return buffer;
}


void KPenDialog::actualizeControls ()
{
  color_w->setColor(the_color);
  style_w->setCurrentItem((int)the_style);
  width_w->setValue(the_width);
  example_w->setPixmap(penImage(350,18,pen()));
}


void KPenDialog::evaluateControls()
{
  the_color = color_w->color();
  the_width = width_w->value();
  the_style = (enum PenStyle)(style_w->currentItem());
}


QPen KPenDialog::pen ()
{
  evaluateControls();
  return QPen(the_color,the_width,the_style);
}


void KPenDialog::setPen (const QPen& p)
{
  the_color = p.color();
  the_width = p.width();
  the_style = p.style();
  actualizeControls();
}


void KPenDialog::penChanged ()
{
  evaluateControls();
  actualizeControls();
}


void KPenDialog::clickedRecent (int index)
{
  setPen(*(the_recent.at(index)));
  penChanged();
}


void KPenDialog::clickedOK ()
{
  bool in_recent;
  int i;
  for (i=0, in_recent=false; i<(int)the_recent.count(); i++)
	if (*the_recent.at(i) == pen())
	  in_recent = true;
  if (!in_recent)
	the_recent.insert(0,new QPen(pen()));
  while (the_recent.count() > 8)
	the_recent.remove(8);
  emit pressedOK ();
  accept();
}


void KPenDialog::clickedCancel ()
{
  emit pressedCancel ();
  reject();
}


/*
 * static KPenDialog methods.
 */

QPen KPenDialog::selectPen ()
{
  QPen p;
  KPenDialog* dialog = new KPenDialog ();
  if (dialog->exec() == Accepted)
	p = dialog->pen();
  delete dialog;
  return p;
}


QPen KPenDialog::selectPen (const QPen& predef)
{
  QPen p = predef;
  KPenDialog* dialog = new KPenDialog ();
  dialog->setPen(p);
  if (dialog->exec() == Accepted)
	p = dialog->pen();
  delete dialog;
  return p;
}


QPixmap KPenDialog::penImage (int width, int height, const QPen& p)
{
  QPixmap pix (width,height);
  pix.fill(white);
  QPainter paint;
  paint.begin(&pix);
  paint.setPen(p);
  paint.drawLine(2,height/2,width-2,height/2);
  paint.end();
  return pix;
}


/*
 * The kapp.h header confuses GCC, so I had to put the implementation
 * of KPenDialog::clickedHelp() to the very end of this file.
 * I apologize for the inconvenience.
 */

/*
 * KPenButton Implementation
 *
 */

KPenButton::KPenButton (QWidget* parent, const char* name)
  : QPushButton (parent,name)
{
  connect(this,SIGNAL(clicked()),SLOT(slotClicked()));
}


KPenButton::KPenButton (const QPen& deflt, QWidget* parent,
						const char* name)
  : QPushButton (parent,name), the_pen(deflt)
{
  connect(this,SIGNAL(clicked()),SLOT(slotClicked()));
}


KPenButton::~KPenButton ()
{
}


void KPenButton::setPen (const QPen& p)
{
  the_pen = p;
  update();
  emit changed (the_pen);
}


QPen KPenButton::pen ()
{
  return the_pen;
}


void KPenButton::slotClicked ()
{
  the_pen = KPenDialog::selectPen(the_pen);
  update();
  emit changed (the_pen);
}


void KPenButton::drawButtonLabel (QPainter* p)
{
  p->drawPixmap(5,5,KPenDialog::penImage(width()-10,height()-10,the_pen));
}


/*
 * KPenWidget Implementation
 *
 */

KPenWidget::KPenWidget (int f, QWidget* parent, const char* name)
  : QWidget(parent,name)
{
  int i;
  t_width = 0;
  style_w = 0;
  width_w = 0;
  color_w = 0;
  example_w = 0;
  if (f & KPen_style) {
	style_w = new QComboBox(this,"combo-style");
	style_w->setGeometry(t_width,0,100,25);
	for (i=0; i<penStyles; i++)
	  style_w->insertItem(penStyle[i]);
	connect(style_w,SIGNAL(highlighted(int)),SLOT(penChanged()));
	connect(style_w,SIGNAL(activated(int)),SLOT(penChanged()));
	t_width += 110;
  }
  if (f & KPen_width) {
	width_w = new QSlider(0,10,1,0,QSlider::Horizontal,this,"slider-width");
	width_w->setSteps(1,1);
	width_w->setTickmarks(QSlider::Below);
	width_w->setGeometry(t_width,0,100,25);
	connect(width_w,SIGNAL(sliderMoved(int)),SLOT(penChanged()));
	connect(width_w,SIGNAL(valueChanged(int)),SLOT(penChanged()));
	t_width += 110;
  }
  if (f & KPen_color) {
	color_w = new KColorButton(this,"button-color");
	color_w->setColor(black);
	color_w->setGeometry(t_width,0,50,25);
	connect(color_w,SIGNAL(changed(const QColor&)),SLOT(penChanged()));
	t_width += 60;
  }
  if (f & KPen_example) {
	example_w = new QLabel(this,"label_example");
	example_w->setText("");
	example_w->setGeometry(0,30,t_width-10,20);
  }
  cout << "KPenWidget width " << t_width << endl;
  setFixedSize(t_width,30+25*((f & KPen_example) > 0));
  QPen empty;
  the_width = empty.width();
  the_style = empty.style();
  the_color = empty.color();
  actualize();
}

KPenWidget::~KPenWidget ()
{
  delete style_w;
  delete width_w;
  delete color_w;
  delete example_w;
}

void KPenWidget::evaluate ()
{
  if (color_w)
	the_color = color_w->color();
  if (width_w)
	the_width = width_w->value();
  if (style_w)
	the_style = (enum PenStyle)(style_w->currentItem());
}

void KPenWidget::actualize ()
{
  if (color_w)
	color_w->setColor(the_color);
  if (style_w)
	style_w->setCurrentItem((int)the_style);
  if (width_w)
	width_w->setValue(the_width);
  if (example_w)
	example_w->setPixmap(KPenDialog::penImage(t_width-10,20,pen()));
}

void KPenWidget::setPen (const QPen& p)
{
  the_color = p.color();
  the_width = p.width();
  the_style = p.style();
  actualize();
}

QPen KPenWidget::pen ()
{
  evaluate();
  return QPen(the_color,the_width,the_style);
}

void KPenWidget::penChanged ()
{
  if (example_w) {
	example_w->setPixmap(KPenDialog::penImage(t_width-10,20,pen()));
  }
}


/*
 * The kapp.h header confuses the shit out of GCC, so its been put to
 * the end of kpen.cc to minimize damage :-(
 * 
 */

#include <kapp.h>

void KPenDialog::clickedHelp ()
{
  if(kapp != 0)
    kapp->invokeHTMLHelp("kpendialog.html","");
}
