/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _aristaT0_h
#define _aristaT0_h

#include <header.hxx>
#include <v_t0.hxx>

class Triangulo_T0;

class Arista_T0{ 
      friend ostream& operator<<(ostream&,Arista_T0&);   
   public:
      Vertice_T0*    s[2]; // Tablero que contiene los dos
                            // punteros de los vertices de la arista.
      Triangulo_T0*    tr; // Puntero sobre un triangulo que contiene
                            // dicha arista.
      int              ref; // referencia de la arista.
      Boolean        front; // si !=0 arista en la frontera.


      Arista_T0 () : ref(0),front(0) {s[0]=NIL; s[1]=NIL; tr=NIL;}
      Arista_T0 (Vertice_T0* a, Vertice_T0* b, Triangulo_T0* tt,\
          int reff=0, Boolean ff=0): ref(reff), front(ff)
                 {s[0]=a; s[1]=b;tr=tt;}
      Arista_T0 (Vertice_T0& a,Vertice_T0& b,Triangulo_T0* tt,\
          int reff=0, Boolean ff=0): ref(reff),front(ff)
                 {s[0]=&a; s[1]=&b; tr=tt;}
      Arista_T0 (Vertice_T0* a[], Triangulo_T0* tt,int reff=0,\
          Boolean ff=0):ref(reff), front(ff)
                 {s[0]=a[0]; s[1]=a[1]; tr=tt;}
      Arista_T0 (const Arista_T0& aa) {s[0]=aa.s[0]; s[1]=aa.s[1];
                 ref=aa.ref; front=aa.front; tr=aa.tr;}
      void write(ostream&);

      void set (Vertice_T0* a, Vertice_T0* b,Triangulo_T0* tt,\
             int reff, Boolean ff) {
                s[0]=a; s[1]=b;
                ref=reff;
                front=ff;
                tr=tt;
      }
      void set (Vertice_T0& a, Vertice_T0& b, Triangulo_T0* tt,\
             int reff, Boolean ff) {
                s[0]=&a; s[1]=&b;
                ref=reff;
                front=ff;
                tr=tt;}
      void set (const Arista_T0& aa) {s[0]=aa.s[0]; s[1]=aa.s[1];
                 ref=aa.ref; front=aa.front;tr=aa.tr;}
      Arista_T0& operator=(const Arista_T0& aa) {
                s[0]=aa.s[0]; s[1]=aa.s[1]; ref=aa.ref;
                front=aa.front; tr=aa.tr;
                return *this;}
      int operator==(const Arista_T0& aa) {
        int v=0;
        if ((*s[0])==(*(aa.s[0])) && (*s[1])==(*(aa.s[1]))) v=1;
        return v;
      }
      Boolean frontera() { return front;}
      void m_ref();
      int operator<(Arista_T0& aa)
        {return (s[1]==aa.s[0]);}
      int vertice(Vertice_T0*);
      friend Scalar angle(Arista_T0*,Arista_T0*);
      friend Scalar  d_arete(const Arista_T0&, const R2&,R2&);
};                  


#endif
