/***************************************************************************
                          btextmatrix.h  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BTEXTMATRIX_H
#define BTEXTMATRIX_H

#include <qwidget.h>
#include <qtableview.h>
//#include <qfont.h>
#include <qlist.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include "resource.h"

/** Widget for output hebtext in a matrix
	* with marked patterns (coloor)
  *	@author Hans-Jrgen Schumann
  */
class BTextMatrix : public QTableView  {
   Q_OBJECT

public:
	BTextMatrix(QWidget *parent=0, const char *name=0);
  /** Anz.Spalten der Matrix - Zeilen werden berechnet 0-> nur Zeilen setzen */
  void setSpalten( int s);
  /** Anz.Zeilen der Matrix - 0 -> Zeilen werden berechnet */
  void setZeilen( int z);
		
	~BTextMatrix();
  /**  */
  int addMatrixLine(QString s);
	void clear();

protected:
  /**  */
  virtual void paintCell(QPainter *p, int y, int x);

private:
  /** Zeigerliste auf Color-objekte */
  QList<QColor> ftab;
  /** Matrix auszugebende Zeichenkette */
	QString	matrix;
	/** Struktur fr Zeichenmarkierungen */
	struct mark {
		int	pos;	
		int	color;
  };
  /** Markierungstabelle/Liste */
	QList<mark>  mtab;

private:
  /** Umrechnung Spalte Zeile nach Position */
  int coordsToIndex(int x, int y);
  /** prft, ob Position markiert ist und gibt Zeigar auf Farbe aus Farbtabelle */
  QColor* isColored(int pos);

};

#endif















