#ifndef __FITTER_INCLUDED__
#define __FITTER_INCLUDED__

#include <stdio.h>
#include <qarray.h>
#include <qstring.h>
#include <qobject.h>

class Fitter : public QObject
{
 Q_OBJECT 
 public:
   Fitter();
   ~Fitter();  

   int num_data, num_params;

   bool regress(bool multi=false);
   void setData(QArray<double> *x, QArray<double> *z, QArray<double> *err=0);
   virtual double function(double) = 0;
   const char *messages(void) const {return mesg;}
   double epsilon(void) const {return d_epsilon;}   
   void setEpsilon(double eps){d_epsilon=eps;}
   void stopFit(void){ctrlc_flag=TRUE;}
   bool autoFit(void) const {return d_autofit;}
   void setAutoFit(bool a) {d_autofit=a;}
   
 protected:
   enum marq_res {OK, ERROR, BETTER, WORSE};
   char *fit_index;
   
   int max_data;
   int max_params;

   bool d_autofit;
   double d_epsilon;   /* convergence limit */
   int maxiter;         /* HBB 970304: maxiter patch */
   
   int columns;
   QArray<double> *fit_x,*fit_z,*err_data;
   QArray<double> fpartbl;
   QString mesg;

   bool ctrlc_flag;
   bool user_stop;
   bool show_iter;
   
   double startup_lambda, lambda_down_factor,lambda_up_factor;
      
   marq_res marquardt(double a[], double **alpha, double *chisq, double *lambda);
   bool analyze(double a[], double **alpha, double beta[],double *chisq);
   void calculate(double *zfunc, double **dzda, double a[]);

   
   void call_parser(double *par, double *data);
   void printmatrix(double **C, int m, int n);
   void print_matrix_and_vectors(double **C, double *d, double *r, int m, int n);
   

   virtual const char *parName(int) = 0;

   void addMessage(const char *format, ...);
   
 private:
   double  *vec(int n);
   double  **matr(int r, int c);
   void    free_matr(double **m);
   double  *redim_vec(double **v, int n);
   void    redim_ivec(int **v, int n);
   int     Givens(double **C, double *d, double *x,
 		  double *r, int N, int n, int want_r); 
   int   Invert_RtR (double **R, double **I, int n);

 signals:
   void fitting();
   void finished();
};

#endif



