/**************************************************************************
 * $Id: SamplinScaleBox.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_SCALE_BOX_H
#define SAMPLIN_SCALE_BOX_H

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstring.h>
#include <qpainter.h>
#include <qdstream.h>

#include <SamplinScaleBar.h>


class SamplinScaleBox: public SamplinScaleBar
{
 public:
   SamplinScaleBox(Orientation, const char *title = 0);
   ~SamplinScaleBox();
      
   QRect d_scaleRect;
   
   int d_scaleOffset[2];
   int d_scaleLength;
   int d_borderDist;

   int d_autoRedraw;
   int d_titleOffset;
   int d_titleXDist, d_titleYDist;
   QFont d_titlefont;
   QColor d_titlecolor;
   QString d_title;
   
public:
   void setTitle(const char *title);
   void setTitleFont(const QFont &f);
   void setTitleColor(const QColor &c);
   const QString &title(void) const{return d_title;}
   const QFont &titleFont(void) const{return d_titlefont;}
   const QColor &titleColor(void) const{return d_titlecolor;}
   
   void setScaleOffset(int start, int end);
   void setBorderDist(int bd);
   void adjustWidth(bool tf);
   

//   const QwtDiMap &map() const { return d_scale; }
   
   int minScaleOffset(QPainter &p) const;
    
   QSize sizeHint(QPainter &p) const;
   
   void draw(QPainter &p, QRect &r);
      
 protected:
   void scaleChanged();
   
 private:
   void resizeScale(QPainter *p, QRect *r);
				  
    
};

QDataStream &operator<<( QDataStream &, const SamplinScaleBox &);
QDataStream &operator>>( QDataStream &, SamplinScaleBox &);

#endif
