/**************************************************************************
 * $Id: pcl818-driver.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This is the Linux driver for Advantech PCL-818 card
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef __PCL818_DRIVER_H
#define __PCL818_DRIVER_H


#define  PCL818_VERSION  "Linux PCL-818 driver 0.0.3, April 13 1999"
#define  PCL818_ID       "pcl818: "


#ifndef  PCL818_MAX_CARDS
   #define  PCL818_MAX_CARDS  (2)      /*  Max number of cards to probe for.  */
#endif


#define  PCL818_MAJOR  (39)            /*  The device major number.           */


#define  PCL818_PROBE_IO_START  0x200  /*  Lowest I/O port to probe.          */
#define  PCL818_PROBE_IO_END    0x3ff  /*  Highest I/O port.                  */

#define  PCL818_PROBE_IRQ_START  (2)   /*  Lowest IRQ to look for cards.      */
#define  PCL818_PROBE_IRQ_END    (7)   /*  Highest IRQ to look for cards.     */

#define  PCL818_MINOR_LARGEST  (21)   /*  The largest minor number used.      */
#define  PCL818_MINOR_RANGE    (32)   /*  Number of minor numbers allocated   */
                                     /*  per card.                           */
#define  PCL818_MINOR_ADC0     (0)    /*  These minor numbers are added to    */
#define  PCL818_MINOR_ADC1     (1)    /*  the appropriate base minor number   */
#define  PCL818_MINOR_ADC2     (2)    /*  of a card to find the actual minor  */
#define  PCL818_MINOR_ADC3     (3)    /*  minor number.                       */
#define  PCL818_MINOR_ADC4     (4)    /*                                      */
#define  PCL818_MINOR_ADC5     (5)    /*                                      */
#define  PCL818_MINOR_ADC6     (6)    /*                                      */
#define  PCL818_MINOR_ADC7     (7)    /*                                      */
#define  PCL818_MINOR_ADC8     (8)    /*                                      */
#define  PCL818_MINOR_ADC9     (9)    /*                                      */
#define  PCL818_MINOR_ADC10    (10)   /*                                      */
#define  PCL818_MINOR_ADC11    (11)   /*                                      */
#define  PCL818_MINOR_ADC12    (12)   /*                                      */
#define  PCL818_MINOR_ADC13    (13)   /*                                      */
#define  PCL818_MINOR_ADC14    (14)   /*                                      */
#define  PCL818_MINOR_ADC15    (15)   /*                                      */
#define  PCL818_MINOR_DAC0     (16)   /*                                      */
#define  PCL818_MINOR_DAC1     (17)   /*                                      */
#define  PCL818_MINOR_DIGITAL  (18)   /*                                      */
#define  PCL818_MINOR_CT0      (19)   /*                                      */
#define  PCL818_MINOR_CT1      (20)   /*                                      */
#define  PCL818_MINOR_CT2      (21)   /*                                      */


/*  Number of jiffies to wait for conversion in hardware probe.              */
#define  PCL818_PROBE_TIME  (10)


/*  Read from the selected ADC here.                                         */
#define  PCL818_ADC_IN         (0x0)

/*  Write here to start ADC conversion.                                      */
#define  PCL818_ADC_START      (0x0)


#define  PCL818_ADC_RANGE      (0x1)
/*  Write here to reset the End-of-ADC-Conversion flag.                      */
#define  PCL818_RESET_INT_REQ  (0x8)
#define  PCL818_STATUS         (0x8)

/*  Command bytes are written here.                                          */
/*  See "driver/PCL818.h" for a description of Command bits.                  */
#define  PCL818_COMMAND        (0x9)

#define  PCL818_MUX            (0x2)

#define  PCL818_DIGITAL_IN1   (0x3)
#define  PCL818_DIGITAL_OUT1  (0x3)

#define  PCL818_DIGITAL_IN2   (0x11)
#define  PCL818_DIGITAL_OUT2  (0x11)

#define  PCL818_DAC0         (0x4)
#define  PCL818_DAC1         (0x6)

#define  PCL818_CT0_READ     (0x8)
#define  PCL818_CT0_WRITE    (0x8)

#define  PCL818_CT1_READ     (0x9)
#define  PCL818_CT1_WRITE    (0x9)

#define  PCL818_CT2_READ     (0xa)
#define  PCL818_CT2_WRITE    (0xa)


/*  Write commands here to control the counter/timers.                       */
/*  See sys/PCL818.h for bit patterns and constants.                          */
#define  PCL818_CT_CONTROL  (0xb)

#define  PCL818_CT_LATCH_CMD  (0x00)
#define  PCL818_CT_W_LSB_MSB  (0x30)

#define  PCL818_CT_BIN  (0x00)
#define  PCL818_CT_BCD  (0x01)




/*  Macro definitions.                                                       */
#define  PCL818_ADC_START_CONVERSION(cardnum)  \
   outb(0x00, pcl818_card[cardnum].baseaddress + PCL818_ADC_START)

#define  PCL818_ADC_GET(cardnum)  \
   ((inb(pcl818_card[cardnum].baseaddress + PCL818_ADC_IN)>>4) | \
   (inb(pcl818_card[cardnum].baseaddress + PCL818_ADC_IN + 1)<<4))

#define PCL818_ADC_SET_RANGE(cardnum, range)  \
   outb(range, pcl818_card[cardnum].baseaddress + PCL818_ADC_RANGE)

#define  PCL818_ADC_GETL(cardnum)  \
   (inb(pcl818_card[cardnum].baseaddress + PCL818_ADC_IN)>>4)

#define  PCL818_ADC_GETH(cardnum)  \
   (inb(pcl818_card[cardnum].baseaddress + PCL818_ADC_IN + 1))

#define  PCL818_ADC_SELECT(adcnum, cardnum)  \
   outb(adcnum | (adcnum<<4), pcl818_card[cardnum].baseaddress + PCL818_MUX)

//outb(pcl818_card[cardnum].adcmode[minor], pcl818_card[cardnum].baseaddress + PCL818_COMMAND)

#define  PCL818_ADC_RESET_INT_REQ(cardnum)  \
   outb(0x00, pcl818_card[cardnum].baseaddress + PCL818_RESET_INT_REQ)

#define  PCL818_DAC_SET(val, dac_num, cardnum)  \
outb((val&0xf)<<4, pcl818_card[cardnum].baseaddress + PCL818_DAC0 + dac_num*2); \
outb((val&0xff0)>>4, pcl818_card[cardnum].baseaddress + PCL818_DAC0 + dac_num*2 + 1)

//   outw(val, pcl818_card[cardnum].baseaddress + PCL818_DAC0 + dac_num*2 ) 
/*   outb((val & 0xff00), pcl818_card[cardnum].baseaddress + PCL818_DAC0 + dac_num*2 + 1 )*/

#define  PCL818_DIGITAL_GET(cardnum)  (\
   inb(pcl818_card[cardnum].baseaddress + PCL818_DIGITAL_IN1) + \
   (inb(pcl818_card[cardnum].baseaddress + PCL818_DIGITAL_IN2) << 8) \
)

#define  PCL818_DIGITAL_SET(val, cardnum)  \
   pcl818_card[cardnum].diglines = val;  \
   outb((pcl818_card[cardnum].diglines & 0xff), pcl818_card[cardnum].baseaddress + PCL818_DIGITAL_OUT1); \
   outb(((pcl818_card[cardnum].diglines & 0xff00) >> 8), pcl818_card[cardnum].baseaddress + PCL818_DIGITAL_OUT2)
#define  PCL818_CT_GET(ct_num, cardnum)  \
   inb(pcl818_card[cardnum].baseaddress + PCL818_CT0_READ + ct_num)

#define  PCL818_CT_SET(val, ct_num, cardnum)  \
   outb(val, pcl818_card[cardnum].baseaddress + PCL818_CT0_WRITE + ct_num)


#define  PCL818_CARD_NUM(minor)       (minor / PCL818_MINOR_RANGE)
#define  PCL818_MINOR_START(cardnum)  (cardnum * PCL818_MINOR_RANGE)


/*  Miscellaneous constants.                                                 */
#define  PCL818_FALSE  (0)
#define  PCL818_TRUE   (!PCL818_FALSE)


#define  PCL818_DIFFERENTIAL  (0)
#define  PCL818_SINGLE_ENDED  (1)




struct pcl818_data {
   unsigned short baseaddress;   /*  Base address of card.                   */
   unsigned char irq;            /*  IRQ of card.                            */

   unsigned char adcmode[16];    /*  One status byte per ADC channel.        */ 
   unsigned char analog_type;    /*  Differential or Single-Ended?           */

   unsigned int diglines;       /*  Value currently on the digital lines.   */

   unsigned int dac[2];          /* Value currently on the dac1 & dac2       */

   unsigned char ctmode[3];      /*  The Counter Control values of each c/t. */

   unsigned long read_in_use;    /*  Bitfield, minor numbers opened for      */
                                 /*  reading are 1's.                        */

   unsigned long write_in_use;   /*  Bitfield, minor numbers opened for      */
                                 /*  writing are 1's.                        */

   struct semaphore sem;         /*  Block use of card (waiting for ADC).    */
   struct wait_queue *wait_q;    /*  Sleep while waiting for interrupt.      */
};

#endif /* __PCL818_DRIVER_H */


